/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.Iterator;
import jp.ossc.nimbus.core.ArgumentMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.InvokeMetaData;
import jp.ossc.nimbus.core.MetaData;
import org.w3c.dom.Element;

public class StaticInvokeMetaData
extends InvokeMetaData
implements Serializable {
    public static final String STATIC_INVOKE_TAG_NAME = "static-invoke";
    protected static final String CODE_ATTRIBUTE_NAME = "code";
    protected String code;

    public StaticInvokeMetaData(MetaData parent) {
        super(parent);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void importXML(Element element) throws DeploymentException {
        if (!element.getTagName().equals(STATIC_INVOKE_TAG_NAME)) {
            throw new DeploymentException("Tag must be static-invoke : " + element.getTagName());
        }
        this.code = StaticInvokeMetaData.getUniqueAttribute(element, CODE_ATTRIBUTE_NAME);
        this.name = StaticInvokeMetaData.getUniqueAttribute(element, "name");
        Iterator argElements = StaticInvokeMetaData.getChildrenByTagName(element, "argument");
        while (argElements.hasNext()) {
            ArgumentMetaData argData = new ArgumentMetaData(this, this.getParentObjectMetaData());
            argData.importXML((Element)argElements.next());
            this.addArgument(argData);
        }
    }
}

