/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.util.converter.CharacterConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;
import jp.ossc.nimbus.util.converter.StringConverter;

public class CustomConverter
implements Converter,
StringConverter,
CharacterConverter,
Serializable {
    protected List converters;

    public CustomConverter() {
    }

    public CustomConverter(Converter[] convs) {
        if (convs != null && convs.length != 0) {
            this.converters = new ArrayList();
            for (int i = 0; i < convs.length; ++i) {
                this.converters.add(convs[i]);
            }
        }
    }

    public Converter add(Converter converter) {
        if (this.converters == null) {
            this.converters = new ArrayList();
        }
        this.converters.add(converter);
        return this;
    }

    public void remove(Converter converter) {
        if (this.converters == null) {
            return;
        }
        this.converters.remove(converter);
    }

    public void clear() {
        if (this.converters == null) {
            return;
        }
        this.converters.clear();
    }

    public Object convert(Object obj) throws ConvertException {
        Object tmp = obj;
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                tmp = ((Converter)this.converters.get(i)).convert(tmp);
            }
        }
        return tmp;
    }

    public String convert(String str) throws ConvertException {
        String tmp = str;
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.converters.get(i) instanceof StringConverter)) continue;
                tmp = ((StringConverter)this.converters.get(i)).convert(tmp);
            }
        }
        return tmp;
    }

    public char convert(char c) throws ConvertException {
        char tmp = c;
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.converters.get(i) instanceof CharacterConverter)) continue;
                tmp = ((CharacterConverter)this.converters.get(i)).convert(tmp);
            }
        }
        return tmp;
    }

    public Character convert(Character c) throws ConvertException {
        Character tmp = c;
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.converters.get(i) instanceof CharacterConverter)) continue;
                tmp = ((CharacterConverter)this.converters.get(i)).convert(tmp);
            }
        }
        return tmp;
    }
}

