/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.AttributeMetaData;
import jp.ossc.nimbus.core.ConstructorMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.FieldMetaData;
import jp.ossc.nimbus.core.InvokeMetaData;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ObjectMetaData;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import org.w3c.dom.Element;

public class ServiceMetaData
extends ObjectMetaData
implements Serializable {
    public static final String SERVICE_TAG_NAME = "service";
    public static final String INSTANCE_TYPE_SINGLETON = "singleton";
    public static final String INSTANCE_TYPE_FACTORY = "factory";
    public static final String INSTANCE_TYPE_THREADLOCAL = "threadlocal";
    private static final String DEPENDS_TAG_NAME = "depends";
    private static final String OPT_CONF_TAG_NAME = "optional-config";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String INIT_STATE_ATTRIBUTE_NAME = "initState";
    private static final String INSTANCE_ATTRIBUTE_NAME = "instance";
    private static final String MANAGEMENT_ATTRIBUTE_NAME = "management";
    private String name;
    private String initState = Service.STATES[3];
    private int initStateValue = 3;
    private String instance = "singleton";
    private boolean isFactory;
    private boolean isManagement;
    private transient Element optionalConfig;
    private final List depends = new ArrayList();
    private ManagerMetaData manager;

    public ServiceMetaData(ServiceLoader loader, MetaData parent, ManagerMetaData manager) {
        super(loader, parent, manager.getName());
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInitState() {
        return this.initState;
    }

    public void setInitState(String state) {
        this.initState = state;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String val) {
        if (INSTANCE_TYPE_SINGLETON.equals(val)) {
            this.instance = val;
        } else if (INSTANCE_TYPE_FACTORY.equals(val) || INSTANCE_TYPE_THREADLOCAL.equals(val)) {
            this.isFactory = true;
            this.instance = val;
        } else {
            throw new IllegalArgumentException(val);
        }
    }

    public boolean isFactory() {
        return this.isFactory;
    }

    public boolean isManagement() {
        return this.isManagement;
    }

    public void setManagement(boolean flg) {
        this.isManagement = flg;
    }

    public int getInitStateValue() {
        return this.initStateValue;
    }

    public void setInitStateValue(int state) {
        this.initStateValue = state;
    }

    public Element getOptionalConfig() {
        return this.optionalConfig;
    }

    public List getDepends() {
        return this.depends;
    }

    public void addDepends(DependsMetaData depends) {
        this.depends.add(depends);
    }

    public ManagerMetaData getManager() {
        return this.manager;
    }

    public void setManager(ManagerMetaData manager) {
        this.manager = manager;
    }

    public void importXML(Element element) throws DeploymentException {
        Element constElement;
        if (!element.getTagName().equals(SERVICE_TAG_NAME)) {
            throw new DeploymentException("Tag must be service : " + element.getTagName());
        }
        this.code = ServiceMetaData.getUniqueAttribute(element, "code");
        this.name = ServiceMetaData.getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        String tmpInitState = ServiceMetaData.getOptionalAttribute(element, INIT_STATE_ATTRIBUTE_NAME);
        if (Service.STATES[1].equals(tmpInitState)) {
            this.initState = tmpInitState;
            this.initStateValue = 1;
        } else if (Service.STATES[3].equals(tmpInitState)) {
            this.initState = tmpInitState;
            this.initStateValue = 3;
        }
        this.setInstance(ServiceMetaData.getOptionalAttribute(element, INSTANCE_ATTRIBUTE_NAME, INSTANCE_TYPE_SINGLETON));
        String management = ServiceMetaData.getOptionalAttribute(element, MANAGEMENT_ATTRIBUTE_NAME);
        if (management != null) {
            this.isManagement = Boolean.valueOf(management);
        }
        if ((constElement = ServiceMetaData.getOptionalChild(element, "constructor")) != null) {
            ConstructorMetaData constData = new ConstructorMetaData(this);
            constData.importXML(constElement);
            this.constructor = constData;
        }
        Iterator fieldElements = ServiceMetaData.getChildrenByTagName(element, "field");
        while (fieldElements.hasNext()) {
            FieldMetaData fieldData = new FieldMetaData(this);
            fieldData.importXML((Element)fieldElements.next());
            this.addField(fieldData);
        }
        Iterator attributeElements = ServiceMetaData.getChildrenByTagName(element, "attribute");
        while (attributeElements.hasNext()) {
            AttributeMetaData attributeData = new AttributeMetaData(this);
            attributeData.importXML((Element)attributeElements.next());
            this.addAttribute(attributeData);
        }
        this.optionalConfig = ServiceMetaData.getOptionalChild(element, OPT_CONF_TAG_NAME);
        Iterator invokeElements = ServiceMetaData.getChildrenByTagName(element, "invoke");
        while (invokeElements.hasNext()) {
            InvokeMetaData invokeData = new InvokeMetaData(this);
            invokeData.importXML((Element)invokeElements.next());
            this.addInvoke(invokeData);
        }
        Iterator dependsElements = ServiceMetaData.getChildrenByTagName(element, DEPENDS_TAG_NAME);
        while (dependsElements.hasNext()) {
            Element dependsElement = (Element)dependsElements.next();
            DependsMetaData dependsData = new DependsMetaData(this.manager.getName());
            dependsData.importXML(dependsElement);
            this.depends.add(dependsData);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append('@');
        buf.append(this.hashCode());
        buf.append('{');
        if (this.getName() != null) {
            buf.append(NAME_ATTRIBUTE_NAME);
            buf.append('=');
            buf.append(this.getName());
            buf.append(',');
        }
        buf.append("code");
        buf.append('=');
        buf.append(this.getCode());
        buf.append('}');
        return buf.toString();
    }

    public class DependsMetaData
    extends ServiceNameMetaData
    implements Serializable {
        public DependsMetaData(String manager) {
            super(ServiceMetaData.this, manager);
        }

        public DependsMetaData(String manager, String service) {
            super(ServiceMetaData.this, manager, service);
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals(ServiceMetaData.DEPENDS_TAG_NAME)) {
                throw new DeploymentException("Tag must be depends : " + element.getTagName());
            }
            Element serviceElement = DependsMetaData.getOptionalChild(element, ServiceMetaData.SERVICE_TAG_NAME);
            if (serviceElement == null) {
                ServiceMetaData parent = (ServiceMetaData)this.getParent();
                if (parent != null) {
                    this.setManagerName(parent.getManager().getName());
                }
                super.importXML(element);
            } else {
                ServiceMetaData serviceData = new ServiceMetaData(ServiceMetaData.this.myLoader, (MetaData)this, ServiceMetaData.this.manager);
                serviceData.importXML(serviceElement);
                this.setServiceName(serviceData.getName());
                ServiceMetaData.this.manager.addService(serviceData);
                this.setManagerName(ServiceMetaData.this.manager.getName());
            }
        }
    }
}

