/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.ioc.ejb;

import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvokerFactory;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.log.Logger;

public class BeanFlowClient {
    private Logger mLogger = null;
    private InterceptorChainInvokerFactory mIcFactory = null;
    private BeanFlowInvokerFactory mBfFactory = null;

    protected BeanFlowInvokerFactory getBfFactory() {
        return this.mBfFactory;
    }

    protected InterceptorChainInvokerFactory getIcFactory() {
        return this.mIcFactory;
    }

    protected Logger getLogger() {
        return this.mLogger;
    }

    public void init(Logger logger, InterceptorChainInvokerFactory icFactory, BeanFlowInvokerFactory bfFactory) {
        this.mLogger = logger;
        this.mIcFactory = icFactory;
        this.mBfFactory = bfFactory;
    }

    public Object invokeBeanFlow(Command input) throws Exception {
        if (this.mLogger != null) {
            this.mLogger.write("IOC__00013", (Object)input.getFlowKey());
        }
        BeanFlowInvoker flow = this.mBfFactory.createFlow(input.getFlowKey());
        if (this.mLogger != null && flow == null) {
            this.mLogger.write("IOC__00014");
        }
        return flow.invokeFlow(input.getInputObject());
    }
}

