/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aspect.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.service.aspect.metadata.InterceptorMappingMetaData;
import org.w3c.dom.Element;

public class InterceptorMappingsMetaData
extends MetaData
implements Serializable {
    public static final String INTERCEPTOR_MAPPINGS_TAG_NAME = "interceptor-mappings";
    private final List mInterceptorMappingList = new ArrayList();

    public List getInterceptorMappingList() {
        return this.mInterceptorMappingList;
    }

    public void addInterceptorMapping(InterceptorMappingMetaData interceptorMapping) {
        this.mInterceptorMappingList.add(interceptorMapping);
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(INTERCEPTOR_MAPPINGS_TAG_NAME)) {
            throw new DeploymentException("Tag must be interceptor-mappings : " + element.getTagName());
        }
        Iterator interceptorMappingElements = InterceptorMappingsMetaData.getChildrenByTagName(element, "interceptor-mapping");
        while (interceptorMappingElements.hasNext()) {
            InterceptorMappingMetaData interceptorMappingData = new InterceptorMappingMetaData(this);
            interceptorMappingData.importXML((Element)interceptorMappingElements.next());
            this.addInterceptorMapping(interceptorMappingData);
        }
    }
}

