/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import jp.ossc.nimbus.service.graph.DatasetFactory;
import jp.ossc.nimbus.service.graph.MovingAverageCreateException;
import jp.ossc.nimbus.service.graph.MovingAverageFactoryServiceMBean;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MovingAverageFactoryService
extends ServiceBase
implements DatasetFactory,
MovingAverageFactoryServiceMBean {
    private DatasetFactory datasetFactory;
    private double[] periodCounts;
    private double[] skips;
    private String[] suffixs;
    private String name;
    private List dsConditionList;

    public void createService() throws Exception {
        this.dsConditionList = new ArrayList();
    }

    public void startService() throws Exception {
        if (this.datasetFactory == null) {
            throw new IllegalArgumentException("DatasetFactory must be specified.");
        }
        if (this.name == null) {
            this.name = this.getServiceName();
        }
        if (this.periodCounts == null || this.periodCounts.length == 0) {
            throw new IllegalArgumentException("periodCounts must be specified.");
        }
        if (this.skips != null && this.skips.length != this.periodCounts.length) {
            throw new IllegalArgumentException("Length of skips and periodCounts must equal.");
        }
        if (this.suffixs != null && this.suffixs.length != this.periodCounts.length) {
            throw new IllegalArgumentException("Length of suffixs and periodCounts must equal.");
        }
    }

    public void stopService() throws Exception {
        this.dsConditionList.clear();
    }

    public void destroyService() throws Exception {
        this.dsConditionList = null;
    }

    public void setDatasetFactory(DatasetFactory datasetFactory) {
        this.datasetFactory = datasetFactory;
    }

    public DatasetFactory getDatasetFactory() {
        return this.datasetFactory;
    }

    public void setPeriodCounts(double[] counts) {
        this.periodCounts = counts;
    }

    public double[] getPeriodCounts() {
        return this.periodCounts;
    }

    public void setSkips(double[] skips) {
        this.skips = skips;
    }

    public double[] getSkips() {
        return this.skips;
    }

    public void setSuffixs(String[] names) {
        this.suffixs = names;
    }

    public String[] getSuffixs() {
        return this.suffixs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addDatasetCondition(DatasetCondition dsCondition) {
        this.dsConditionList.add(dsCondition);
    }

    public DatasetCondition[] getDatasetConditions() {
        return this.dsConditionList.toArray(new DatasetCondition[this.dsConditionList.size()]);
    }

    public Dataset createDataset(DatasetCondition[] dsConditions) throws DatasetCreateException {
        if (dsConditions == null || dsConditions.length == 0) {
            return null;
        }
        Dataset dataset = null;
        try {
            dataset = this.datasetFactory.createDataset(dsConditions);
        }
        catch (DatasetCreateException e) {
            throw new MovingAverageCreateException(e);
        }
        Dataset datasetMV = dataset;
        if (dataset instanceof TimeSeriesCollection) {
            List seriesList = ((TimeSeriesCollection)dataset).getSeries();
            int seriesLength = seriesList.size();
            TimeSeriesCollection newCollection = new TimeSeriesCollection();
            for (int i = 0; i < this.periodCounts.length; ++i) {
                for (int j = 0; j < seriesLength; ++j) {
                    TimeSeries series = (TimeSeries)seriesList.get(j);
                    series = MovingAverage.createMovingAverage((TimeSeries)series, (String)(series.getKey() + (this.suffixs == null ? "" : this.suffixs[i])), (int)((int)this.periodCounts[i]), (int)((int)(this.skips == null ? 0.0 : this.skips[i])));
                    newCollection.addSeries(series);
                }
            }
            datasetMV = newCollection;
        } else if (dataset instanceof XYDataset) {
            XYSeriesCollection newCollection = new XYSeriesCollection();
            XYDataset inDataset = (XYDataset)dataset;
            for (int i = 0; i < this.periodCounts.length; ++i) {
                for (int j = 0; j < inDataset.getSeriesCount(); ++j) {
                    XYSeries series = MovingAverage.createMovingAverage((XYDataset)inDataset, (int)j, (String)(inDataset.getSeriesKey(j) + (this.suffixs == null ? "" : this.suffixs[i])), (double)this.periodCounts[i], (double)(this.skips == null ? 0.0 : this.skips[i]));
                    newCollection.addSeries(series);
                }
            }
            datasetMV = newCollection;
        }
        return datasetMV;
    }
}

