/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.service.journal.editor.HttpServletRequestMapJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ServletRequestMapJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpServletRequestMapJournalEditorService
extends ServletRequestMapJournalEditorService
implements HttpServletRequestMapJournalEditorServiceMBean,
Serializable {
    private boolean isOutputRequestURL = true;
    private boolean isOutputRequestURI = true;
    private boolean isOutputServletPath = true;
    private boolean isOutputContextPath = true;
    private boolean isOutputPathInfo = true;
    private boolean isOutputPathTranslated = true;
    private boolean isOutputQueryString = true;
    private boolean isOutputSessionID = true;
    private boolean isOutputIsRequestedSessionIdFromCookie = true;
    private boolean isOutputIsRequestedSessionIdFromURL = true;
    private boolean isOutputMethod = true;
    private boolean isOutputAuthType = true;
    private boolean isOutputRemoteUser = true;
    private boolean isOutputUserPrincipal = true;
    private boolean isOutputHeaders = true;
    private boolean isOutputCookies = true;
    private String[] secretHeaders;
    protected Set secretHeaderSet;
    private String[] enabledHeaders;
    protected Set enabledHeaderSet;
    private String[] secretCookies;
    protected Set secretCookieSet;
    private String[] enabledCookies;
    protected Set enabledCookieSet;

    public void setOutputRequestURL(boolean isOutput) {
        this.isOutputRequestURL = isOutput;
    }

    public boolean isOutputRequestURL() {
        return this.isOutputRequestURL;
    }

    public void setOutputRequestURI(boolean isOutput) {
        this.isOutputRequestURI = isOutput;
    }

    public boolean isOutputRequestURI() {
        return this.isOutputRequestURI;
    }

    public void setOutputServletPath(boolean isOutput) {
        this.isOutputServletPath = isOutput;
    }

    public boolean isOutputServletPath() {
        return this.isOutputServletPath;
    }

    public void setOutputContextPath(boolean isOutput) {
        this.isOutputContextPath = isOutput;
    }

    public boolean isOutputContextPath() {
        return this.isOutputContextPath;
    }

    public void setOutputPathInfo(boolean isOutput) {
        this.isOutputPathInfo = isOutput;
    }

    public boolean isOutputPathInfo() {
        return this.isOutputPathInfo;
    }

    public void setOutputPathTranslated(boolean isOutput) {
        this.isOutputPathTranslated = isOutput;
    }

    public boolean isOutputPathTranslated() {
        return this.isOutputPathTranslated;
    }

    public void setOutputQueryString(boolean isOutput) {
        this.isOutputQueryString = isOutput;
    }

    public boolean isOutputQueryString() {
        return this.isOutputQueryString;
    }

    public void setOutputSessionID(boolean isOutput) {
        this.isOutputSessionID = isOutput;
    }

    public boolean isOutputSessionID() {
        return this.isOutputSessionID;
    }

    public void setOutputIsRequestedSessionIdFromCookie(boolean isOutput) {
        this.isOutputIsRequestedSessionIdFromCookie = isOutput;
    }

    public boolean isOutputIsRequestedSessionIdFromCookie() {
        return this.isOutputIsRequestedSessionIdFromCookie;
    }

    public void setOutputIsRequestedSessionIdFromURL(boolean isOutput) {
        this.isOutputIsRequestedSessionIdFromURL = isOutput;
    }

    public boolean isOutputIsRequestedSessionIdFromURL() {
        return this.isOutputIsRequestedSessionIdFromURL;
    }

    public void setOutputMethod(boolean isOutput) {
        this.isOutputMethod = isOutput;
    }

    public boolean isOutputMethod() {
        return this.isOutputMethod;
    }

    public void setOutputAuthType(boolean isOutput) {
        this.isOutputAuthType = isOutput;
    }

    public boolean isOutputAuthType() {
        return this.isOutputAuthType;
    }

    public void setOutputRemoteUser(boolean isOutput) {
        this.isOutputRemoteUser = isOutput;
    }

    public boolean isOutputRemoteUser() {
        return this.isOutputRemoteUser;
    }

    public void setOutputUserPrincipal(boolean isOutput) {
        this.isOutputUserPrincipal = isOutput;
    }

    public boolean isOutputUserPrincipal() {
        return this.isOutputUserPrincipal;
    }

    public void setOutputHeaders(boolean isOutput) {
        this.isOutputHeaders = isOutput;
    }

    public boolean isOutputHeaders() {
        return this.isOutputHeaders;
    }

    public void setOutputCookies(boolean isOutput) {
        this.isOutputCookies = isOutput;
    }

    public boolean isOutputCookies() {
        return this.isOutputCookies;
    }

    public void setSecretHeaders(String[] names) {
        this.secretHeaders = names;
    }

    public String[] getSecretHeaders() {
        return this.secretHeaders;
    }

    public void setEnabledHeaders(String[] names) {
        this.enabledHeaders = names;
    }

    public String[] getEnabledHeaders() {
        return this.enabledHeaders;
    }

    public void setSecretCookies(String[] names) {
        this.secretCookies = names;
    }

    public String[] getSecretCookies() {
        return this.secretCookies;
    }

    public void setEnabledCookies(String[] names) {
        this.enabledCookies = names;
    }

    public String[] getEnabledCookies() {
        return this.enabledCookies;
    }

    public void createService() {
        super.createService();
        this.secretHeaderSet = new HashSet();
        this.enabledHeaderSet = new HashSet();
        this.secretCookieSet = new HashSet();
        this.enabledCookieSet = new HashSet();
    }

    public void startService() {
        int i;
        super.startService();
        if (this.secretHeaders != null) {
            for (i = 0; i < this.secretHeaders.length; ++i) {
                this.secretHeaderSet.add(this.secretHeaders[i]);
            }
        }
        if (this.enabledHeaders != null) {
            for (i = 0; i < this.enabledHeaders.length; ++i) {
                this.enabledHeaderSet.add(this.enabledHeaders[i]);
            }
        }
        if (this.secretCookies != null) {
            for (i = 0; i < this.secretCookies.length; ++i) {
                this.secretCookieSet.add(this.secretCookies[i]);
            }
        }
        if (this.enabledCookies != null) {
            for (i = 0; i < this.enabledCookies.length; ++i) {
                this.enabledCookieSet.add(this.enabledCookies[i]);
            }
        }
    }

    public void stopService() {
        super.stopService();
        this.secretHeaderSet.clear();
        this.enabledHeaderSet.clear();
        this.secretCookieSet.clear();
        this.enabledCookieSet.clear();
    }

    public void destroyService() {
        super.destroyService();
        this.secretHeaderSet = null;
        this.enabledHeaderSet = null;
        this.secretCookieSet = null;
        this.enabledCookieSet = null;
    }

    public Map toMap(EditorFinder finder, Object key, Object value) {
        ServletRequest request = (ServletRequest)value;
        Map result = super.toMap(finder, key, request);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isOutputRequestURL()) {
            this.makeRequestURLFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputRequestURI()) {
            this.makeRequestURIFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputServletPath()) {
            this.makeServletPathFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputContextPath()) {
            this.makeContextPathFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputPathInfo()) {
            this.makePathInfoFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputPathTranslated()) {
            this.makePathTranslatedFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputQueryString()) {
            this.makeQueryStringFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputSessionID()) {
            this.makeSessionIDFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputIsRequestedSessionIdFromCookie()) {
            this.makeIsRequestedSessionIdFromCookieFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputIsRequestedSessionIdFromURL()) {
            this.makeIsRequestedSessionIdFromURLFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputMethod()) {
            this.makeMethodFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputAuthType()) {
            this.makeAuthTypeFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputRemoteUser()) {
            this.makeRemoteUserFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputUserPrincipal()) {
            this.makeUserPrincipalFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputHeaders()) {
            this.makeHeadersFormat(finder, key, httpRequest, result);
        }
        if (this.isOutputCookies()) {
            this.makeCookiesFormat(finder, key, httpRequest, result);
        }
        return result;
    }

    protected Map makeAuthTypeFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("AuthenticationType", request.getAuthType());
        return map;
    }

    protected Map makeRemoteUserFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("RemoteUser", request.getRemoteUser());
        return map;
    }

    protected Map makeUserPrincipalFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("UserPrincipal", request.getUserPrincipal());
        return map;
    }

    protected Map makeRequestURLFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("RequestURL", request.getRequestURL().toString());
        return map;
    }

    protected Map makeRequestURIFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("RequestURI", request.getRequestURI());
        return map;
    }

    protected Map makeServletPathFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("ServletPath", request.getServletPath());
        return map;
    }

    protected Map makeContextPathFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("ContextPath", request.getContextPath());
        return map;
    }

    protected Map makePathInfoFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("PathInfo", request.getPathInfo());
        return map;
    }

    protected Map makePathTranslatedFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("PathTranslated", request.getPathTranslated());
        return map;
    }

    protected Map makeQueryStringFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("QueryString", request.getQueryString());
        return map;
    }

    protected Map makeSessionIDFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("RequestSessionID", request.getRequestedSessionId());
        return map;
    }

    protected Map makeIsRequestedSessionIdFromCookieFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("IsRequestSessionIDFromCookie", new Boolean(request.isRequestedSessionIdFromCookie()));
        return map;
    }

    protected Map makeIsRequestedSessionIdFromURLFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("IsRequestSessionIDFromURL", new Boolean(request.isRequestedSessionIdFromURL()));
        return map;
    }

    protected Map makeMethodFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        map.put("HTTPMethod", request.getMethod());
        return map;
    }

    protected Map makeHeadersFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        Enumeration headerNames = request.getHeaderNames();
        if (!headerNames.hasMoreElements()) {
            return map;
        }
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (!this.enabledHeaderSet.isEmpty() && !this.enabledHeaderSet.contains(name)) continue;
            if (this.secretHeaderSet.contains(name)) {
                subMap.put(name, null);
                continue;
            }
            Enumeration headers = request.getHeaders(name);
            if (headers == null) continue;
            ArrayList values = new ArrayList();
            while (headers.hasMoreElements()) {
                values.add(headers.nextElement());
            }
            subMap.put(name, this.makeObjectFormat(finder, key, values));
        }
        map.put("HTTPHeaders", this.makeObjectFormat(finder, key, subMap));
        return map;
    }

    protected Map makeCookiesFormat(EditorFinder finder, Object key, HttpServletRequest request, Map map) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return map;
        }
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        for (int i = 0; i < cookies.length; ++i) {
            String name = cookies[i].getName();
            if (!this.enabledCookieSet.isEmpty() && !this.enabledCookieSet.contains(name)) continue;
            if (this.secretCookieSet.contains(name)) {
                subMap.put(name, null);
                continue;
            }
            subMap.put(name, this.makeObjectFormat(finder, key, cookies[i].getValue()));
        }
        map.put("Cookie", this.makeObjectFormat(finder, key, subMap));
        return map;
    }
}

