/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.msgresource;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.QueueSession;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.byteconvert.ByteConverter;
import jp.ossc.nimbus.service.msgresource.CommonMessageFormat;
import jp.ossc.nimbus.service.msgresource.MessageResourceDefine;
import jp.ossc.nimbus.service.msgresource.MessageResourceUtil;
import jp.ossc.nimbus.util.CsvArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ObjectMessageFormat
extends CommonMessageFormat
implements MessageResourceDefine {
    private String mClassName;
    private ArrayList mPayloadObjAttributes = new ArrayList();
    private HashMap mMethodMap = new HashMap();
    private String mEscapeChar = null;

    public ObjectMessageFormat(ByteConverter converter) {
        super(converter);
    }

    public String marshal(Message msg) {
        if (!(msg instanceof ObjectMessage)) {
            return null;
        }
        StringBuffer ret = new StringBuffer("[property] ");
        ret.append(this.dumpProperties(msg));
        ret.append(" [payload] ");
        Serializable obj = null;
        ObjectMessage objMsg = (ObjectMessage)msg;
        try {
            obj = objMsg.getObject();
        }
        catch (JMSException e) {
            throw new ServiceException();
        }
        ret.append(obj.toString());
        return ret.toString();
    }

    public Message unMarshal(QueueSession session) {
        ObjectMessage msg = null;
        try {
            msg = session.createObjectMessage();
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY400", "createObjectMessage() failed.", e);
        }
        String recordStr = null;
        Properties prop = null;
        if (this.mMessageInput != null) {
            recordStr = this.mMessageInput.getInputString();
            prop = this.mMessageInput.getMessageHeadProp();
            this.mMessageInput.nextLine();
        }
        this.setMessageHeadProperties((Message)msg, prop);
        this.setPayload((Message)msg, recordStr);
        return msg;
    }

    protected void setPayload(Message msg, String recordStr) {
        ObjectMessage objMsg = (ObjectMessage)msg;
        Object obj = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.mClassName, true, NimbusClassLoader.getInstance());
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY401", "setPayload() failed. Class not Found.", e);
        }
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY402", "setPayload() failed. Instancing failed.", e);
        }
        try {
            this.invokeSetterMethods(clazz, obj, recordStr);
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY402", "settter invocation failed.", e);
        }
        try {
            objMsg.setObject((Serializable)obj);
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY402", "ObjectMessage's setObject() Method failed.", e);
        }
    }

    private void invokeSetterMethods(Class clazz, Object obj, String recordStr) throws InvocationTargetException, IllegalAccessException {
        HashMap result = new HashMap();
        Iterator attrs = this.mPayloadObjAttributes.iterator();
        while (attrs.hasNext()) {
            PayloadAttribute attr = (PayloadAttribute)attrs.next();
            String name = attr.getName();
            String valStr = attr.getValue();
            if (attr.useFile()) {
                CsvArrayList elems = new CsvArrayList();
                if (this.mEscapeChar != null) {
                    elems.setEscapeString(this.mEscapeChar);
                }
                elems.split(recordStr);
                int index = 0;
                try {
                    index = Integer.parseInt(valStr);
                    valStr = (String)elems.get(index);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ServiceException("MESSAGERESOURCEFACTORY403", "Data File does not have column[" + index + "]");
                }
                catch (NumberFormatException e) {
                    throw new ServiceException("MESSAGERESOURCEFACTORY404", valStr + " is not recognized as number.");
                }
            }
            String setterName = "set" + name.toUpperCase().charAt(0) + name.substring(1);
            Method method = (Method)this.mMethodMap.get(setterName);
            Class<?>[] paramTypes = method.getParameterTypes();
            Object val = this.convertStringToObject(paramTypes[0], valStr);
            if (method == null) continue;
            method.invoke(obj, val);
        }
    }

    private Object convertStringToObject(Class clazz, String valStr) {
        PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
        if (editor == null) {
            throw new ServiceException("MESSAGERESOURCEFACTORY016", "Not Found PropertyEditor Class is " + clazz.getName());
        }
        editor.setAsText(valStr);
        return editor.getValue();
    }

    protected void sendPayloadParse(Element elem, boolean fileSpecifiedFlag) {
        NodeList escapeChars = elem.getElementsByTagName("escapechar");
        if (escapeChars.getLength() > 1) {
            throw new ServiceException("MESSAGERESOURCEFACTORY012", "<escapechar> must be specified at least one (and only).");
        }
        for (int rCnt = 0; rCnt < escapeChars.getLength(); ++rCnt) {
            Element escapeChar = (Element)escapeChars.item(rCnt);
            this.mEscapeChar = MessageResourceUtil.getValue(escapeChar);
        }
        NodeList list = elem.getElementsByTagName("payload");
        if (list.getLength() != 1) {
            throw new ServiceException("MESSAGERESOURCEFACTORY012", "<payload> must be specified at least one (and only one).");
        }
        Element payLoad = (Element)list.item(0);
        NodeList classNames = payLoad.getElementsByTagName("className");
        if (classNames.getLength() != 1) {
            throw new ServiceException("MESSAGERESOURCEFACTORY012", "<className> Must be specifiled at least one (and only only one).");
        }
        Element className = (Element)classNames.item(0);
        this.mClassName = MessageResourceUtil.getValueMustbeSpecified(className);
        this.setMethodMap(this.mClassName);
        NodeList payLoadAttributes = payLoad.getElementsByTagName("attribute");
        for (int rCnt = 0; rCnt < payLoadAttributes.getLength(); ++rCnt) {
            String name = null;
            String val = null;
            boolean useFile = false;
            Element payloadAttribute = (Element)payLoadAttributes.item(rCnt);
            name = MessageResourceUtil.getAttMustBeSpecified(payloadAttribute, "name");
            val = MessageResourceUtil.getValueMustbeSpecified(payloadAttribute);
            String resourceType = payloadAttribute.getAttribute("resourceType");
            if (resourceType.equals("file")) {
                if (fileSpecifiedFlag) {
                    useFile = true;
                } else {
                    throw new ServiceException("MESSAGERESOURCEFACTORY015", "File not specified. But type has fileattribute.");
                }
            }
            this.mPayloadObjAttributes.add(new PayloadAttribute(name, val, useFile));
        }
    }

    protected void setMethodMap(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY016", "Class Not Found. Class name is " + className);
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.mMethodMap.put(methods[i].getName(), methods[i]);
        }
    }

    protected void recvPayloadParse(Element elem) {
    }

    private class PayloadAttribute {
        private String mName;
        private String mVal;
        private boolean mUseFile;

        public PayloadAttribute(String name, String val, boolean useFile) {
            this.mName = name;
            this.mVal = val;
            this.mUseFile = useFile;
        }

        public String getName() {
            return this.mName;
        }

        public String getValue() {
            return this.mVal;
        }

        public boolean useFile() {
            return this.mUseFile;
        }
    }
}

