/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.datasource;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.datasource.JdbcConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.resource.datasource.JdbcConnectionTransactionResource;

public class JdbcConnectionFactoryService
extends ServiceBase
implements ResourceFactory,
JdbcConnectionFactoryServiceMBean {
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactoryServiceName or ConnectionFactory must be specified.");
        }
    }

    public void stopService() throws Exception {
        this.connectionFactory = null;
    }

    public TransactionResource makeResource(String key) throws Exception {
        if (this.connectionFactory == null) {
            return null;
        }
        return new JdbcConnectionTransactionResource(this.connectionFactory.getConnection());
    }
}

