/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.service.writer.EvaluateCategoryServiceMBean;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.SimpleCategoryService;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class EvaluateCategoryService
extends SimpleCategoryService
implements EvaluateCategoryServiceMBean {
    private String[] writableConditions;
    private List conditions;

    public void setWritableConditions(String[] conditions) {
        this.writableConditions = conditions;
    }

    public String[] getWritableConditions() {
        return this.writableConditions;
    }

    public void createService() throws Exception {
        super.createService();
        this.conditions = new ArrayList();
    }

    public void startService() throws Exception {
        super.startService();
        if (this.writableConditions != null) {
            for (int i = 0; i < this.writableConditions.length; ++i) {
                this.conditions.add(new Condition(this.writableConditions[i]));
            }
        }
    }

    public void stopService() throws Exception {
        this.conditions.clear();
        super.stopService();
    }

    public void destroyService() throws Exception {
        this.conditions = null;
        super.destroyService();
    }

    public void write(Object elements) throws MessageWriteException {
        if (this.conditions.size() != 0) {
            Iterator condList = this.conditions.iterator();
            while (condList.hasNext()) {
                Condition cond = (Condition)condList.next();
                if (cond.evaluate(elements)) continue;
                return;
            }
        }
        super.write(elements);
    }

    private class Condition {
        public List properties;
        public Expression expression;
        public List keyList = new ArrayList();
        public static final String DELIMITER = "@";

        Condition(String cond) throws Exception {
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_evaluatectgyserv" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        this.properties.add(PropertyFactory.createProperty(beforeToken));
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            if (this.keyList.size() == 0) {
                throw new IllegalArgumentException(cond);
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            this.evaluate("");
        }

        public boolean evaluate(Object object) throws MessageWriteException {
            JexlContext jexlContext = JexlHelper.createContext();
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                String keyString = (String)this.keyList.get(i);
                Property property = (Property)this.properties.get(i);
                Object val = null;
                try {
                    val = property.getProperty(object);
                }
                catch (NoSuchPropertyException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
                jexlContext.getVars().put(keyString, val);
            }
            try {
                Object exp = this.expression.evaluate(jexlContext);
                if (exp instanceof Boolean) {
                    return (Boolean)exp;
                }
                throw new MessageWriteException(this.expression.getExpression());
            }
            catch (Exception e) {
                throw new MessageWriteException(e);
            }
        }
    }
}

