/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TopicSubscriber;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.FacadeValueAccess;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.codemaster.CodeMasterServiceMBean;
import jp.ossc.nimbus.service.codemaster.PartUpdate;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory;
import jp.ossc.nimbus.service.sequence.Sequence;

public class CodeMasterService
extends ServiceBase
implements CodeMasterServiceMBean,
CodeMasterFinder,
MessageListener {
    private static final long serialVersionUID = -4013884085932487905L;
    public static final String UPDATE_TIME_KEY = "$updateTime";
    private static final String C_REQUEST_ID = "REQUEST_ID";
    private static final String C_USER_ID = "USER_ID";
    private static final String FIND_DATE_KEY = "date";
    private static final String MASTER_DATA_KEY = "data";
    private ServiceName facadeCallerServiceName;
    private FacadeCaller facadeCaller;
    private String[] masterNames;
    private ServiceName jmsTopicSubscriberFactoryServiceName;
    private JMSMessageConsumerFactory jmsTopicSubscriberFactory;
    private ServiceStateListener jmsMessageConsumerFactoryStateListener = new JMSMessageConsumerFactoryStateListener();
    protected HashMap master;
    private ServiceName sequenceServiceName;
    private Sequence sequence;
    private String userId;

    public void setMasterNames(String[] names) {
        this.masterNames = names;
    }

    public String[] getMasterNames() {
        return this.masterNames;
    }

    public ServiceName getFacadeCallerServiceName() {
        return this.facadeCallerServiceName;
    }

    public void setFacadeCallerServiceName(ServiceName name) {
        this.facadeCallerServiceName = name;
    }

    public void setJMSTopicSubscriberFactoryServiceName(ServiceName name) {
        this.jmsTopicSubscriberFactoryServiceName = name;
    }

    public ServiceName getJMSTopicSubscriberFactoryServiceName() {
        return this.jmsTopicSubscriberFactoryServiceName;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String id) {
        this.userId = id;
    }

    public void setFacadeCaller(FacadeCaller caller) {
        this.facadeCaller = caller;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void setJMSMessageConsumerFactory(JMSMessageConsumerFactory factory) {
        this.jmsTopicSubscriberFactory = factory;
    }

    public void createService() throws Exception {
        this.master = new HashMap();
    }

    public void startService() throws Exception {
        if (this.facadeCallerServiceName != null) {
            this.facadeCaller = (FacadeCaller)ServiceManagerFactory.getServiceObject(this.facadeCallerServiceName);
        } else if (this.facadeCaller == null) {
            throw new IllegalArgumentException("Attribute : FacadeCallerServiceName or FacadeCaller is null");
        }
        if (this.jmsTopicSubscriberFactoryServiceName != null) {
            this.jmsTopicSubscriberFactory = (JMSMessageConsumerFactory)ServiceManagerFactory.getServiceObject(this.jmsTopicSubscriberFactoryServiceName);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)((Object)ServiceManagerFactory.getService(this.sequenceServiceName));
        }
        this.initMasterHash();
        this.entryTopicListener();
    }

    public void stopService() throws Exception {
        if (this.master != null) {
            this.master.clear();
        }
        if (this.jmsTopicSubscriberFactoryServiceName != null) {
            ServiceManagerFactory.removeServiceStateListener(this.jmsTopicSubscriberFactoryServiceName, this.jmsMessageConsumerFactoryStateListener);
        }
    }

    public void destroyService() {
        this.master = null;
    }

    private void entryTopicListener() throws Exception {
        if (this.jmsTopicSubscriberFactory != null) {
            Service service = ServiceManagerFactory.getService(this.jmsTopicSubscriberFactoryServiceName);
            if (service.getState() == 3) {
                TopicSubscriber subscriber = (TopicSubscriber)this.jmsTopicSubscriberFactory.createConsumer();
                subscriber.setMessageListener((MessageListener)this);
                this.jmsTopicSubscriberFactory.getSessionFactory().getConnection().start();
            }
            ServiceManagerFactory.addServiceStateListener(this.jmsTopicSubscriberFactoryServiceName, this.jmsMessageConsumerFactoryStateListener);
        }
    }

    private void initMasterHash() throws Exception {
        int status;
        this.master.clear();
        if (this.masterNames == null) {
            return;
        }
        FacadeValue value = FacadeValueAccess.createCommandsValue();
        for (int cnt = 0; cnt < this.masterNames.length; ++cnt) {
            TimeManageMaster tmp = new TimeManageMaster();
            tmp.setMasterName(this.masterNames[cnt]);
            Command cmd = FacadeValueAccess.createCommand(this.masterNames[cnt], null);
            this.master.put(this.masterNames[cnt], tmp);
            value.addCommand(cmd);
        }
        FacadeValue ret = null;
        if (this.userId != null) {
            value.putHeader(C_USER_ID, this.userId);
        }
        if (this.sequence != null) {
            value.putHeader(C_REQUEST_ID, this.sequence.increment());
        }
        if ((status = (ret = this.facadeCaller.syncFacadeCall(value)).getStatus()) == 0) {
            for (int cnt = 0; cnt < value.commandSize(); ++cnt) {
                Command tmp = (Command)value.getCommand(cnt);
                String key = tmp.getFlowKey();
                if (tmp.getOutputObject() == null) continue;
                TimeManageMaster mst = (TimeManageMaster)this.master.get(key);
                mst.addMaster(new Date(), tmp.getOutputObject());
            }
        } else if (ret.getExceptionCount() > 0) {
            Throwable[] th = ret.getExceptions();
            if (th[0] instanceof Exception) {
                throw (Exception)th[0];
            }
            throw (Error)th[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCodeMasters() throws ServiceException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Date nowDate = new Date();
        Set keys = this.master.keySet();
        Iterator ite = keys.iterator();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            TimeManageMaster tmp = null;
            HashMap hashMap = this.master;
            synchronized (hashMap) {
                tmp = (TimeManageMaster)this.master.get(key);
            }
            Object mst = tmp.getMaster(nowDate);
            map.put(key, mst);
        }
        return map;
    }

    public void onMessage(Message msg) {
        block11: {
            if (!(msg instanceof MapMessage)) {
                this.getLogger().write("CMS__00003", msg.getClass());
                return;
            }
            MapMessage mapMsg = (MapMessage)msg;
            try {
                FacadeValue value = FacadeValueAccess.createCommandsValue();
                Enumeration en = mapMsg.getMapNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    Object tmp = this.master.get(key);
                    if (tmp == null) continue;
                    Object input = mapMsg.getObject(key);
                    Command cmd = null;
                    cmd = FacadeValueAccess.createCommand(key, input);
                    value.addCommand(cmd);
                }
                if (value.commandSize() <= 0) break block11;
                FacadeValue ret = null;
                if (this.userId != null) {
                    value.putHeader(C_USER_ID, this.userId);
                }
                if (this.sequence != null) {
                    value.putHeader(C_REQUEST_ID, this.sequence.increment());
                }
                ret = this.facadeCaller.syncFacadeCall(value);
                for (int cnt = 0; cnt < ret.commandSize(); ++cnt) {
                    Command rec = (Command)ret.getCommand(cnt);
                    Date updateTime = null;
                    try {
                        long utc = mapMsg.getLong(rec.getFlowKey() + UPDATE_TIME_KEY);
                        updateTime = new Date(utc);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        this.updateCodeMaster(rec, updateTime);
                        continue;
                    }
                    catch (Exception e) {
                        this.getLogger().write("CMS__00002", (Object)rec.getFlowKey(), (Throwable)e);
                    }
                }
            }
            catch (JMSException e) {
                this.getLogger().write("CMS__00004", e);
                return;
            }
        }
    }

    public void updateCodeMaster(String key, Object input, Date updateTime) throws Exception {
        Object tmp = this.master.get(key);
        if (tmp == null) {
            return;
        }
        FacadeValue value = FacadeValueAccess.createCommandsValue();
        Command cmd = FacadeValueAccess.createCommand(key, input);
        value.addCommand(cmd);
        if (this.userId != null) {
            value.putHeader(C_USER_ID, this.userId);
        }
        if (this.sequence != null) {
            value.putHeader(C_REQUEST_ID, this.sequence.increment());
        }
        FacadeValue ret = this.facadeCaller.syncFacadeCall(value);
        this.updateCodeMaster((Command)ret.getCommand(0), updateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCodeMaster(Command rec, Date updateTime) throws Exception {
        if (rec.getStatus() == 0) {
            Object mst = rec.getOutputObject();
            if (mst == null) {
                this.getLogger().write("CMS__00001", new Object[]{rec.getFlowKey(), null});
                return;
            }
            TimeManageMaster tm = (TimeManageMaster)this.master.get(rec.getFlowKey());
            Date effectDt = updateTime;
            if (effectDt == null) {
                effectDt = new Date();
            }
            if (mst instanceof PartUpdate) {
                PartUpdate pu = (PartUpdate)tm.getMaster(effectDt);
                PartUpdate indata = (PartUpdate)mst;
                Iterator ite = indata.keySet().iterator();
                while (ite.hasNext()) {
                    String key = (String)ite.next();
                    pu.put(key, indata.get(key));
                }
                tm.clear();
            } else {
                TimeManageMaster newTm = tm.cloneOwn();
                newTm.addMaster(effectDt, mst);
                newTm.clear();
                HashMap hashMap = this.master;
                synchronized (hashMap) {
                    this.master.put(rec.getFlowKey(), newTm);
                }
            }
            this.getLogger().write("CMS__00001", new Object[]{rec.getFlowKey(), effectDt});
        } else if (rec.getExceptionCount() > 0) {
            Throwable[] th = rec.getExceptions();
            if (th[0] instanceof Exception) {
                throw (Exception)th[0];
            }
            throw (Error)th[0];
        }
    }

    private class JMSMessageConsumerFactoryStateListener
    implements ServiceStateListener {
        private JMSMessageConsumerFactoryStateListener() {
        }

        public void stateChanged(ServiceStateChangeEvent e) throws Exception {
            Service service = e.getService();
            int state = service.getState();
            ServiceName name = new ServiceName(service.getServiceManagerName(), service.getServiceName());
            if (!name.equals(CodeMasterService.this.jmsTopicSubscriberFactoryServiceName)) {
                return;
            }
            switch (state) {
                case 3: {
                    CodeMasterService.this.entryTopicListener();
                    break;
                }
            }
        }

        public boolean isEnabledState(int state) {
            return state == 3;
        }
    }

    private class TimeManageMaster {
        private String mFlowKey = null;
        private ArrayList mTimeList = new ArrayList();

        public void setMasterName(String name) {
            this.mFlowKey = name;
        }

        public String getMasterName() {
            return this.mFlowKey;
        }

        public void addMaster(Date time, Object master) {
            HashMap<String, Object> rec = new HashMap<String, Object>();
            rec.put(CodeMasterService.MASTER_DATA_KEY, master);
            rec.put(CodeMasterService.FIND_DATE_KEY, time);
            boolean instFlg = false;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time)) continue;
                if (cnt == this.mTimeList.size() - 1) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(cnt + 1, rec);
                }
                instFlg = true;
                break;
            }
            if (!instFlg) {
                if (this.mTimeList.size() == 0) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(0, rec);
                }
            }
        }

        public Object getMaster(Date time) {
            Object ret = null;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time)) continue;
                ret = map.get(CodeMasterService.MASTER_DATA_KEY);
                break;
            }
            return ret;
        }

        public void clear() {
            Date now = new Date();
            for (int cnt = this.mTimeList.size() - 1; cnt >= 0; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(now) || cnt <= 0) continue;
                for (int rcnt = cnt - 1; rcnt >= 0; --rcnt) {
                    this.mTimeList.remove(rcnt);
                }
                break;
            }
        }

        public TimeManageMaster cloneOwn() {
            TimeManageMaster ret = new TimeManageMaster();
            ret.setMasterName(this.getMasterName());
            for (int cnt = 0; cnt < this.mTimeList.size(); ++cnt) {
                ret.mTimeList.add(this.mTimeList.get(cnt));
            }
            return ret;
        }
    }
}

