/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.DataSourceConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class DataSourceConnectionFactoryService
extends ServiceBase
implements DataSourceConnectionFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = -5837939620922806932L;
    private String dataSourceName;
    private JndiFinder jndiFinder;
    private ServiceName jndiFinderName;

    public void startService() throws Exception {
        if (this.getName() == null) {
            throw new IllegalArgumentException("DataSource name is null.");
        }
        if (this.getJndiFinderServiceName() != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderName);
        } else if (this.jndiFinder == null) {
            throw new IllegalArgumentException("Argument : JndiFinderName or JndiFinder is null.");
        }
    }

    public Connection getConnection() throws ConnectionFactoryException {
        Connection con = null;
        try {
            DataSource dataSource = (DataSource)this.jndiFinder.lookup(this.dataSourceName);
            con = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionFactoryException(e);
        }
        catch (NamingException e) {
            throw new ConnectionFactoryException(e);
        }
        return con;
    }

    public void setName(String name) {
        this.dataSourceName = name;
    }

    public String getName() {
        return this.dataSourceName;
    }

    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderName;
    }

    public JndiFinder getJndiFinderService() {
        return this.jndiFinder;
    }

    public void setJndiFinderService(JndiFinder finder) {
        this.jndiFinder = finder;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }
}

