/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ioccall.interceptor;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aspect.interfaces.Interceptor;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChain;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetCheckedException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetUncheckedException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.ioccall.interceptor.JournalInterceptorServiceMBean;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;

public class JournalInterceptorService
extends ServiceBase
implements JournalInterceptorServiceMBean,
Interceptor,
jp.ossc.nimbus.service.aop.Interceptor {
    private static final long serialVersionUID = -5639122310302405874L;
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected ServiceName contextServiceName;
    protected Context context;
    protected ServiceName stepEditorFinderServiceName;
    protected EditorFinder stepEditorFinder;
    protected ServiceName inputEditorFinderServiceName;
    protected EditorFinder inputEditorFinder;
    protected ServiceName outputEditorFinderServiceName;
    protected EditorFinder outputEditorFinder;
    protected String stepJournalKey = "Step";
    protected String inputJournalKey = "Input";
    protected String outputJournalKey = "Output";
    protected String requestIdKey = "REQUEST_ID";

    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    public void setStepEditorFinderServiceName(ServiceName name) {
        this.stepEditorFinderServiceName = name;
    }

    public ServiceName getStepEditorFinderServiceName() {
        return this.stepEditorFinderServiceName;
    }

    public void setInputEditorFinderServiceName(ServiceName name) {
        this.inputEditorFinderServiceName = name;
    }

    public ServiceName getInputEditorFinderServiceName() {
        return this.inputEditorFinderServiceName;
    }

    public void setOutputEditorFinderServiceName(ServiceName name) {
        this.outputEditorFinderServiceName = name;
    }

    public ServiceName getOutputEditorFinderServiceName() {
        return this.outputEditorFinderServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    public void setRequestIDKey(String key) {
        this.requestIdKey = key;
    }

    public String getRequestIDKey() {
        return this.requestIdKey;
    }

    public void setStepJournalKey(String key) {
        this.stepJournalKey = key;
    }

    public String getStepJournalKey() {
        return this.stepJournalKey;
    }

    public void setInputJournalKey(String key) {
        this.inputJournalKey = key;
    }

    public String getInputJournalKey() {
        return this.inputJournalKey;
    }

    public void setOutputJournalKey(String key) {
        this.outputJournalKey = key;
    }

    public String getOutputJournalKey() {
        return this.outputJournalKey;
    }

    public void startService() throws Exception {
        if (this.journalServiceName == null) {
            throw new IllegalArgumentException("journalServiceName must be specified.");
        }
        this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        if (this.stepEditorFinderServiceName != null) {
            this.stepEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.stepEditorFinderServiceName);
        }
        if (this.inputEditorFinderServiceName != null) {
            this.inputEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.inputEditorFinderServiceName);
        }
        if (this.outputEditorFinderServiceName != null) {
            this.outputEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.outputEditorFinderServiceName);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.contextServiceName != null) {
            this.context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
        }
    }

    public Object invokeChain(Object inputObj, InterceptorChain interceptChain) throws InterceptorException, TargetCheckedException, TargetUncheckedException {
        try {
            return this.invokeInternal(inputObj, interceptChain, null);
        }
        catch (InterceptorException e) {
            throw e;
        }
        catch (TargetCheckedException e) {
            throw e;
        }
        catch (TargetUncheckedException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new InterceptorException(th);
        }
    }

    public Object invoke(InvocationContext context, jp.ossc.nimbus.service.aop.InterceptorChain chain) throws Throwable {
        return this.invokeInternal(context, null, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInternal(Object inputObj, InterceptorChain interceptChain, jp.ossc.nimbus.service.aop.InterceptorChain chain) throws Throwable {
        Object input = inputObj;
        if (chain != null) {
            input = ((MethodInvocationContext)input).getParameters()[0];
        }
        if (this.getState() == 3) {
            try {
                this.journal.startJournal(this.stepJournalKey, this.stepEditorFinder);
                if (this.sequence != null) {
                    this.journal.setRequestId(this.sequence.increment());
                } else if (this.context != null) {
                    this.journal.setRequestId((String)this.context.get(this.requestIdKey));
                }
                Object ret = null;
                this.journal.addInfo(this.inputJournalKey, input);
                ret = interceptChain != null ? interceptChain.invokeChain(input) : chain.invokeNext((InvocationContext)inputObj);
                this.journal.addInfo(this.outputJournalKey, ret);
                Object object = ret;
                return object;
            }
            finally {
                this.journal.endJournal();
            }
        }
        if (interceptChain != null) {
            return interceptChain.invokeChain(input);
        }
        return chain.invokeNext((InvocationContext)inputObj);
    }
}

