/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import jp.ossc.nimbus.service.journal.editor.ByteArrayJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class ByteArrayJournalEditorService
extends ImmutableJournalEditorServiceBase
implements ByteArrayJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -5535571335184302651L;
    private static final int CONVERT_HEX_VALUE = 0;
    private static final int CONVERT_DECIMAL_VALUE = 1;
    private static final int CONVERT_OCTAL_VALUE = 2;
    private static final int CONVERT_ENCODE_VALUE = 3;
    private String convertMode = "HEX";
    private int convertModeValue;
    private String encode;

    public void setConvertMode(String mode) {
        if (mode != null) {
            this.convertMode = mode;
        }
    }

    public String getConvertMode() {
        return this.convertMode;
    }

    public void startService() throws Exception {
        super.startService();
        if (this.convertMode.equals("HEX")) {
            this.convertModeValue = 0;
        } else if (this.convertMode.equals("DECIMAL")) {
            this.convertModeValue = 1;
        } else if (this.convertMode.equals("OCTAL")) {
            this.convertModeValue = 2;
        } else {
            new String(new byte[0], this.convertMode);
            this.encode = this.convertMode;
            this.convertModeValue = 3;
        }
    }

    protected String toString(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        byte[] bytes = (byte[])value;
        switch (this.convertModeValue) {
            case 0: {
                this.makeHexStringFormat(finder, key, bytes, buf);
                break;
            }
            case 1: {
                this.makeDecimalStringFormat(finder, key, bytes, buf);
                break;
            }
            case 2: {
                this.makeOctalStringFormat(finder, key, bytes, buf);
                break;
            }
            default: {
                this.makeEncodeStringFormat(finder, key, bytes, buf);
            }
        }
        return buf.toString();
    }

    protected StringBuffer makeHexStringFormat(EditorFinder finder, Object key, byte[] bytes, StringBuffer buf) {
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i]).toUpperCase();
            if (hex.length() == 1) {
                buf.append('0');
            }
            buf.append(hex);
            if (i == bytes.length - 1) continue;
            buf.append(' ');
        }
        return buf;
    }

    protected StringBuffer makeDecimalStringFormat(EditorFinder finder, Object key, byte[] bytes, StringBuffer buf) {
        for (int i = 0; i < bytes.length; ++i) {
            String decimal = Byte.toString(bytes[i]);
            buf.append(decimal);
            if (i == bytes.length - 1) continue;
            buf.append(' ');
        }
        return buf;
    }

    protected StringBuffer makeOctalStringFormat(EditorFinder finder, Object key, byte[] bytes, StringBuffer buf) {
        for (int i = 0; i < bytes.length; ++i) {
            String octal = Integer.toOctalString(bytes[i]).toUpperCase();
            if (octal.length() == 1) {
                buf.append('0').append('0');
            } else if (octal.length() == 2) {
                buf.append('0');
            }
            buf.append(octal);
            if (i == bytes.length - 1) continue;
            buf.append(' ');
        }
        return buf;
    }

    protected StringBuffer makeEncodeStringFormat(EditorFinder finder, Object key, byte[] bytes, StringBuffer buf) {
        try {
            buf.append(new String(bytes, this.encode));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return buf;
    }
}

