/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import jp.ossc.nimbus.service.journal.editor.HttpServletResponseWrapperCSVJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.JournalHttpServletResponseWrapper;
import jp.ossc.nimbus.service.journal.editor.ServletResponseCSVJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpServletResponseWrapperCSVJournalEditorService
extends ServletResponseCSVJournalEditorService
implements HttpServletResponseWrapperCSVJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -8048911048598967051L;
    private static final String HEADER_SEPARATOR = ",";
    private static final String HEADER_VALUE_SEPARATOR = "=";
    private static final String COOKIE_VALUE_SEPARATOR = "=";
    private static final String COOKIE_SEPARATOR = ",";
    private static final String DEFAULT_SECRET_STRING = "******";
    private String secretString = "******";
    private String[] secretHeaders;
    protected Set secretHeaderSet;
    private String[] enabledHeaders;
    protected Set enabledHeaderSet;
    private String[] secretCookies;
    protected Set secretCookieSet;
    private String[] enabledCookies;
    protected Set enabledCookieSet;
    private static final String[] DEFAULT_OUTPUT_ELEMENT_KEYS = new String[]{"CONTENT_LENGTH", "CONTENT", "HTTP_HEADER", "COOKIE", "STATUS", "STATUS_MESSAGE", "IS_SENT_ERROR", "REDIRECT_LOCATION"};

    public HttpServletResponseWrapperCSVJournalEditorService() {
        String[] tmpKeys = new String[DEFAULT_OUTPUT_ELEMENT_KEYS.length + this.outputElementKeys.length];
        System.arraycopy(DEFAULT_OUTPUT_ELEMENT_KEYS, 0, tmpKeys, 0, DEFAULT_OUTPUT_ELEMENT_KEYS.length);
        System.arraycopy(this.outputElementKeys, 0, tmpKeys, DEFAULT_OUTPUT_ELEMENT_KEYS.length, this.outputElementKeys.length);
        this.outputElementKeys = tmpKeys;
    }

    protected void defineElements() {
        super.defineElements();
        this.defineElementEditor("CONTENT_LENGTH", new ElementEditor(){
            private static final long serialVersionUID = 5409658398823021851L;

            public StringBuffer toString(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
                return HttpServletResponseWrapperCSVJournalEditorService.this.makeContentLengthFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("CONTENT", new ElementEditor(){
            private static final long serialVersionUID = -1925415627831916916L;

            public StringBuffer toString(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
                return HttpServletResponseWrapperCSVJournalEditorService.this.makeContentFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("HTTP_HEADER", new ElementEditor(){
            private static final long serialVersionUID = 3420111630705804294L;

            public StringBuffer toString(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
                return HttpServletResponseWrapperCSVJournalEditorService.this.makeHeadersFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("COOKIE", new ElementEditor(){
            private static final long serialVersionUID = 11146304405115322L;

            public StringBuffer toString(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
                return HttpServletResponseWrapperCSVJournalEditorService.this.makeCookiesFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("STATUS", new ElementEditor(){
            private static final long serialVersionUID = -885021148293565032L;

            public StringBuffer toString(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
                return HttpServletResponseWrapperCSVJournalEditorService.this.makeStatusFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("STATUS_MESSAGE", new ElementEditor(){
            private static final long serialVersionUID = 5610060572986483219L;

            public StringBuffer toString(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
                return HttpServletResponseWrapperCSVJournalEditorService.this.makeStatusMessageFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("IS_SENT_ERROR", new ElementEditor(){
            private static final long serialVersionUID = 4044332448492874611L;

            public StringBuffer toString(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
                return HttpServletResponseWrapperCSVJournalEditorService.this.makeIsSentErrorFormat(finder, key, response, buf);
            }
        });
        this.defineElementEditor("REDIRECT_LOCATION", new ElementEditor(){
            private static final long serialVersionUID = -3779649928946386170L;

            public StringBuffer toString(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
                return HttpServletResponseWrapperCSVJournalEditorService.this.makeRedirectLocationFormat(finder, key, response, buf);
            }
        });
    }

    public void setSecretString(String str) {
        this.secretString = str;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public void setSecretHeaders(String[] names) {
        this.secretHeaders = names;
    }

    public String[] getSecretHeaders() {
        return this.secretHeaders;
    }

    public void setEnabledHeaders(String[] names) {
        this.enabledHeaders = names;
    }

    public String[] getEnabledHeaders() {
        return this.enabledHeaders;
    }

    public void setSecretCookies(String[] names) {
        this.secretCookies = names;
    }

    public String[] getSecretCookies() {
        return this.secretCookies;
    }

    public void setEnabledCookies(String[] names) {
        this.enabledCookies = names;
    }

    public String[] getEnabledCookies() {
        return this.enabledCookies;
    }

    public void createService() throws Exception {
        super.createService();
        this.secretHeaderSet = new HashSet();
        this.enabledHeaderSet = new HashSet();
        this.secretCookieSet = new HashSet();
        this.enabledCookieSet = new HashSet();
    }

    public void startService() throws Exception {
        int i;
        super.startService();
        if (this.secretHeaders != null) {
            for (i = 0; i < this.secretHeaders.length; ++i) {
                this.secretHeaderSet.add(this.secretHeaders[i]);
            }
        }
        if (this.enabledHeaders != null) {
            for (i = 0; i < this.enabledHeaders.length; ++i) {
                this.enabledHeaderSet.add(this.enabledHeaders[i]);
            }
        }
        if (this.secretCookies != null) {
            for (i = 0; i < this.secretCookies.length; ++i) {
                this.secretCookieSet.add(this.secretCookies[i]);
            }
        }
        if (this.enabledCookies != null) {
            for (i = 0; i < this.enabledCookies.length; ++i) {
                this.enabledCookieSet.add(this.enabledCookies[i]);
            }
        }
    }

    public void stopService() throws Exception {
        super.stopService();
        this.secretHeaderSet.clear();
        this.enabledHeaderSet.clear();
        this.secretCookieSet.clear();
        this.enabledCookieSet.clear();
    }

    public void destroyService() throws Exception {
        super.destroyService();
        this.secretHeaderSet = null;
        this.enabledHeaderSet = null;
        this.secretCookieSet = null;
        this.enabledCookieSet = null;
    }

    protected StringBuffer makeContentLengthFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        return buf.append(response.getContentLength());
    }

    protected StringBuffer makeContentFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        String content = response.getContent();
        if (content == null) {
            buf.append("null");
        } else {
            buf.append(content);
        }
        return buf;
    }

    protected StringBuffer makeHeadersFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        Iterator headerNames = response.getHeaderNames();
        if (!headerNames.hasNext()) {
            buf.append("null");
            return buf;
        }
        while (headerNames.hasNext()) {
            String name = (String)headerNames.next();
            if (!this.enabledHeaderSet.isEmpty() && !this.enabledHeaderSet.contains(name)) continue;
            buf.append(name);
            buf.append("=");
            if (this.secretHeaderSet.contains(name)) {
                buf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, response.getHeaders(name), buf);
            }
            if (!headerNames.hasNext()) continue;
            buf.append(",");
        }
        return buf;
    }

    protected StringBuffer makeCookiesFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        Cookie[] cookies = response.getCookies();
        if (cookies == null || cookies.length == 0) {
            buf.append("null");
            return buf;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!this.enabledCookieSet.isEmpty() && !this.enabledCookieSet.contains(this.name)) continue;
            buf.append(cookies[i].getName());
            buf.append("=");
            if (this.secretCookieSet.contains(cookies[i].getName())) {
                buf.append(this.getSecretString());
            } else {
                buf.append(cookies[i].getValue());
            }
            if (i == cookies.length - 1) continue;
            buf.append(",");
        }
        return buf;
    }

    protected StringBuffer makeStatusFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        return buf.append(response.getStatus());
    }

    protected StringBuffer makeStatusMessageFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        return buf.append(response.getStatusMessage());
    }

    protected StringBuffer makeIsSentErrorFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        return buf.append(response.isSentError());
    }

    protected StringBuffer makeRedirectLocationFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        return buf.append(response.getRedirectLocation());
    }

    protected abstract class ElementEditor
    extends ServletResponseCSVJournalEditorService.ElementEditor
    implements Serializable {
        protected ElementEditor() {
            super(HttpServletResponseWrapperCSVJournalEditorService.this);
        }

        protected StringBuffer toString(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
            return this.toString(finder, key, (JournalHttpServletResponseWrapper)response, buf);
        }

        protected abstract StringBuffer toString(EditorFinder var1, Object var2, JournalHttpServletResponseWrapper var3, StringBuffer var4);
    }
}

