/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy.invoker;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.proxy.invoker.LocalClientMethodCallInvokerServiceMBean;

public class LocalClientMethodCallInvokerService
extends ServiceBase
implements LocalClientMethodCallInvokerServiceMBean,
Invoker,
Serializable {
    private static final long serialVersionUID = -1650041776482188614L;
    private ServiceName localServiceName;
    private Object localService;

    public void setLocalServiceName(ServiceName name) {
        this.localServiceName = name;
    }

    public ServiceName getLocalServiceName() {
        return this.localServiceName;
    }

    public void setLocalService(Object localService) {
        this.localService = localService;
    }

    public void startService() throws Exception {
        if (this.localServiceName == null && this.localService == null) {
            throw new IllegalArgumentException("localServiceName must be specified.");
        }
    }

    public Object invoke(InvocationContext context) throws Throwable {
        MethodInvocationContext methodContext = (MethodInvocationContext)context;
        ServiceName targetName = this.localServiceName;
        if (targetName == null) {
            targetName = (ServiceName)context.getTargetObject();
        }
        if (targetName != null) {
            this.localService = ServiceManagerFactory.getServiceObject(targetName);
        }
        if (this.localService == null) {
            throw new IllegalArgumentException("LocalServiceName or LocalService must be specified.");
        }
        try {
            return methodContext.getTargetMethod().invoke(this.localService, methodContext.getParameters());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

