/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ObjectMetaData;
import jp.ossc.nimbus.core.ServiceRefMetaData;
import jp.ossc.nimbus.core.StaticFieldRefMetaData;
import jp.ossc.nimbus.core.StaticInvokeMetaData;
import org.w3c.dom.Element;

public class AttributeMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 1989664413173523795L;
    public static final String ATTRIBUTE_TAG_NAME = "attribute";
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    protected static final String TYPE_ATTRIBUTE_NAME = "type";
    protected String name;
    protected String type;
    protected Object value;

    public AttributeMetaData(ObjectMetaData parent) {
        super(parent);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(ATTRIBUTE_TAG_NAME)) {
            throw new DeploymentException("Tag must be attribute : " + element.getTagName());
        }
        this.name = AttributeMetaData.getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        this.type = AttributeMetaData.getOptionalAttribute(element, TYPE_ATTRIBUTE_NAME);
        Element serviceRefElement = AttributeMetaData.getOptionalChild(element, "service-ref");
        if (serviceRefElement != null) {
            ServiceRefMetaData serviceRefData = new ServiceRefMetaData(this, ((ObjectMetaData)this.getParent()).getManagerName());
            serviceRefData.importXML(serviceRefElement);
            this.value = serviceRefData;
            return;
        }
        Element objectElement = AttributeMetaData.getOptionalChild(element, "object");
        if (objectElement != null) {
            ObjectMetaData objectData = new ObjectMetaData(((ObjectMetaData)this.getParent()).getServiceLoader(), this, ((ObjectMetaData)this.getParent()).getManagerName());
            objectData.importXML(objectElement);
            this.value = objectData;
            return;
        }
        Element staticInvokeElement = AttributeMetaData.getOptionalChild(element, "static-invoke");
        if (staticInvokeElement != null) {
            StaticInvokeMetaData staticInvokeData = new StaticInvokeMetaData(this);
            staticInvokeData.importXML(staticInvokeElement);
            this.value = staticInvokeData;
            return;
        }
        Element staticFieldElement = AttributeMetaData.getOptionalChild(element, "static-field-ref");
        if (staticFieldElement != null) {
            StaticFieldRefMetaData staticFieldData = new StaticFieldRefMetaData(this);
            staticFieldData.importXML(staticFieldElement);
            this.value = staticFieldData;
            return;
        }
        this.value = AttributeMetaData.getElementContent(element);
    }

    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(ATTRIBUTE_TAG_NAME);
        if (this.name != null) {
            buf.append(' ').append(NAME_ATTRIBUTE_NAME).append("=\"").append(this.name).append("\"");
        }
        if (this.type != null) {
            buf.append(' ').append(TYPE_ATTRIBUTE_NAME).append("=\"").append(this.type).append("\"");
        }
        buf.append('>');
        if (this.value != null) {
            if (this.value instanceof MetaData) {
                buf.append(LINE_SEPARATOR);
                buf.append(this.addIndent(((MetaData)this.value).toXML(new StringBuffer())));
                buf.append(LINE_SEPARATOR);
            } else {
                String str = this.value.toString();
                if (str.indexOf(13) != -1 || str.indexOf(10) != -1) {
                    buf.append(LINE_SEPARATOR);
                    buf.append(this.addIndent(str));
                    buf.append(LINE_SEPARATOR);
                } else {
                    buf.append(str);
                }
            }
        }
        buf.append("</").append(ATTRIBUTE_TAG_NAME).append('>');
        return buf;
    }
}

