/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.Method;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.MethodJournalInterceptorServiceMBean;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editor.MethodCallJournalData;
import jp.ossc.nimbus.service.journal.editor.MethodReturnJournalData;
import jp.ossc.nimbus.service.journal.editor.MethodThrowJournalData;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class MethodJournalInterceptorService
extends ServiceBase
implements Interceptor,
MethodJournalInterceptorServiceMBean {
    private static final long serialVersionUID = 6121765320688713719L;
    private ServiceName threadContextName;
    private Context threadContext;
    private ServiceName journalName;
    private Journal journal;
    private ServiceName requestEditorFinderName;
    private ServiceName methodCallEditorFinderName;
    private ServiceName methodReturnEditorFinderName;
    private EditorFinder requestEditorFinder;
    private EditorFinder methodCallEditorFinder;
    private EditorFinder methodReturnEditorFinder;
    private String requestJournalKey = "Request";
    private String methodCallJournalKey = "MethodCall";
    private String methodReturnJournalKey = "MethodReturn";
    private String requestIdKey;
    private boolean isEnabled = true;
    private boolean isBushingCallBlock = false;
    protected ThreadLocal callStack;

    public void setRequestIdKey(String key) {
        this.requestIdKey = key;
    }

    public String getRequestIdKey() {
        return this.requestIdKey;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextName;
    }

    public void setJournalServiceName(ServiceName name) {
        this.journalName = name;
    }

    public ServiceName getJournalServiceName() {
        return this.journalName;
    }

    public void setRequestEditorFinderServiceName(ServiceName name) {
        this.requestEditorFinderName = name;
    }

    public ServiceName getRequestEditorFinderServiceName() {
        return this.requestEditorFinderName;
    }

    public void setMethodCallEditorFinderServiceName(ServiceName name) {
        this.methodCallEditorFinderName = name;
    }

    public ServiceName getMethodCallEditorFinderServiceName() {
        return this.methodCallEditorFinderName;
    }

    public void setMethodReturnEditorFinderServiceName(ServiceName name) {
        this.methodReturnEditorFinderName = name;
    }

    public ServiceName getMethodReturnEditorFinderServiceName() {
        return this.methodReturnEditorFinderName;
    }

    public void setRequestJournalKey(String key) {
        this.requestJournalKey = key;
    }

    public String getRequestJournalKey() {
        return this.requestJournalKey;
    }

    public void setMethodCallJournalKey(String key) {
        this.methodCallJournalKey = key;
    }

    public String getMethodCallJournalKey() {
        return this.methodCallJournalKey;
    }

    public void setMethodReturnJournalKey(String key) {
        this.methodReturnJournalKey = key;
    }

    public String getMethodReturnJournalKey() {
        return this.methodReturnJournalKey;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setBushingCallBlock(boolean isBlock) {
        this.isBushingCallBlock = isBlock;
    }

    public boolean isBushingCallBlock() {
        return this.isBushingCallBlock;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public void setMethodCallEditorFinder(EditorFinder methodCallEditorFinder) {
        this.methodCallEditorFinder = methodCallEditorFinder;
    }

    public void setMethodReturnEditorFinder(EditorFinder methodReturnEditorFinder) {
        this.methodReturnEditorFinder = methodReturnEditorFinder;
    }

    public void setRequestEditorFinder(EditorFinder requestEditorFinder) {
        this.requestEditorFinder = requestEditorFinder;
    }

    public void setThreadContext(Context threadContext) {
        this.threadContext = threadContext;
    }

    public void startService() throws Exception {
        if (this.journalName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalName);
        }
        if (this.requestEditorFinderName != null) {
            this.requestEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.requestEditorFinderName);
        }
        if (this.methodCallEditorFinderName != null) {
            this.methodCallEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.methodCallEditorFinderName);
        }
        if (this.methodReturnEditorFinderName != null) {
            this.methodReturnEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.methodReturnEditorFinderName);
        }
        if (this.threadContextName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextName);
        }
        if (this.isBushingCallBlock) {
            this.callStack = new ThreadLocal(){

                protected Object initialValue() {
                    return new CallStack();
                }
            };
        }
    }

    public void stopService() throws Exception {
        this.callStack = null;
    }

    public void destroyService() {
        this.journal = null;
        this.requestEditorFinder = null;
        this.methodCallEditorFinder = null;
        this.methodReturnEditorFinder = null;
    }

    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        MethodInvocationContext ctx = (MethodInvocationContext)context;
        if (this.getState() == 3 && this.isEnabled() && (this.callStack == null || ((CallStack)this.callStack.get()).stackIndex == 0)) {
            Object ret = null;
            try {
                try {
                    this.preNext(ctx);
                    if (this.callStack != null) {
                        ++((CallStack)this.callStack.get()).stackIndex;
                    }
                    ret = chain.invokeNext(ctx);
                    this.postNext(ctx, ret);
                }
                catch (RuntimeException e) {
                    throw this.throwRuntimeException(ctx, e);
                }
                catch (Exception e) {
                    throw this.throwException(ctx, e);
                }
                catch (Error e) {
                    throw this.throwError(ctx, e);
                }
                Object var7_5 = null;
                if (this.callStack != null) {
                    --((CallStack)this.callStack.get()).stackIndex;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (this.callStack != null) {
                    --((CallStack)this.callStack.get()).stackIndex;
                }
                this.finallyNext(ctx, ret);
                throw throwable;
            }
            this.finallyNext(ctx, ret);
            return ret;
        }
        return chain.invokeNext(ctx);
    }

    protected void preNext(MethodInvocationContext context) throws Throwable {
        if (this.journal == null) {
            return;
        }
        this.journal.startJournal(this.requestJournalKey, this.requestEditorFinder);
        if (this.threadContext != null && this.requestIdKey != null) {
            this.journal.setRequestId((String)this.threadContext.get(this.requestIdKey));
        }
        Method method = context.getTargetMethod();
        MethodCallJournalData data = new MethodCallJournalData(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), context.getParameters());
        this.journal.addInfo(this.methodCallJournalKey, (Object)data, this.methodCallEditorFinder);
    }

    protected void postNext(MethodInvocationContext context, Object ret) throws Throwable {
        if (this.journal == null) {
            return;
        }
        Method method = context.getTargetMethod();
        MethodReturnJournalData data = new MethodReturnJournalData(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), ret);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.methodReturnEditorFinder);
    }

    protected RuntimeException throwRuntimeException(MethodInvocationContext context, RuntimeException e) throws Throwable {
        if (this.journal == null) {
            return e;
        }
        Method method = context.getTargetMethod();
        MethodThrowJournalData data = new MethodThrowJournalData(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), e);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.methodReturnEditorFinder);
        return e;
    }

    protected Exception throwException(MethodInvocationContext context, Exception e) throws Throwable {
        if (this.journal == null) {
            return e;
        }
        Method method = context.getTargetMethod();
        MethodThrowJournalData data = new MethodThrowJournalData(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), e);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.methodReturnEditorFinder);
        return e;
    }

    protected Error throwError(MethodInvocationContext context, Error error) throws Throwable {
        if (this.journal == null) {
            return error;
        }
        Method method = context.getTargetMethod();
        MethodThrowJournalData data = new MethodThrowJournalData(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), error);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.methodReturnEditorFinder);
        return error;
    }

    protected void finallyNext(MethodInvocationContext context, Object ret) throws Throwable {
        if (this.journal == null) {
            return;
        }
        this.journal.endJournal();
    }

    protected static class CallStack {
        public int stackIndex;

        protected CallStack() {
        }
    }
}

