/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpServletResponseDeflateInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;

public class HttpServletResponseDeflateInterceptorService
extends ServletFilterInterceptorService
implements HttpServletResponseDeflateInterceptorServiceMBean {
    private static final long serialVersionUID = -8811812672782874906L;
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_ENCODING_DEFLATE = "deflate";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    private static final String DEFAULT_ENC = "ISO_8859-1";
    private String[] enabledContentTypes;
    private String[] disabledContentTypes;
    private int deflateLength = -1;

    public void setEnabledContentTypes(String[] contentTypes) {
        this.enabledContentTypes = contentTypes;
    }

    public String[] getEnabledContentTypes() {
        return this.enabledContentTypes;
    }

    public void setDisabledContentTypes(String[] contentTypes) {
        this.disabledContentTypes = contentTypes;
    }

    public String[] getDisabledContentTypes() {
        return this.disabledContentTypes;
    }

    public void setDeflateLength(int length) {
        this.deflateLength = length;
    }

    public int getDeflateLength() {
        return this.deflateLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            Object object;
            block13: {
                String acceptEncoding;
                ServletRequest request = context.getServletRequest();
                boolean isWrap = false;
                if (request instanceof HttpServletRequest && (acceptEncoding = ((HttpServletRequest)request).getHeader(HEADER_ACCEPT_ENCODING)) != null) {
                    context.setServletResponse((ServletResponse)new DeflateHttpServletResponseWrapper((HttpServletResponse)context.getServletResponse(), acceptEncoding, this.enabledContentTypes, this.disabledContentTypes, this.deflateLength));
                    isWrap = true;
                }
                try {
                    object = chain.invokeNext(context);
                    Object var7_6 = null;
                    if (!isWrap) break block13;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (isWrap) {
                        ServletResponse response = context.getServletResponse();
                        if (response instanceof DeflateHttpServletResponseWrapper) {
                            ((DeflateHttpServletResponseWrapper)response).flushBuffer();
                            context.setServletResponse(((DeflateHttpServletResponseWrapper)response).getResponse());
                        } else {
                            while (response instanceof ServletResponseWrapper && !(response instanceof DeflateHttpServletResponseWrapper)) {
                                response = ((ServletResponseWrapper)response).getResponse();
                            }
                            if (response instanceof DeflateHttpServletResponseWrapper) {
                                ((DeflateHttpServletResponseWrapper)response).flushBuffer();
                            }
                        }
                    }
                    throw throwable;
                }
                ServletResponse response = context.getServletResponse();
                if (response instanceof DeflateHttpServletResponseWrapper) {
                    ((DeflateHttpServletResponseWrapper)response).flushBuffer();
                    context.setServletResponse(((DeflateHttpServletResponseWrapper)response).getResponse());
                } else {
                    while (response instanceof ServletResponseWrapper && !(response instanceof DeflateHttpServletResponseWrapper)) {
                        response = ((ServletResponseWrapper)response).getResponse();
                    }
                    if (response instanceof DeflateHttpServletResponseWrapper) {
                        ((DeflateHttpServletResponseWrapper)response).flushBuffer();
                    }
                }
            }
            return object;
        }
        return chain.invokeNext(context);
    }

    private static class DeflateServletOutputStreamWrapper
    extends ServletOutputStream {
        private ByteArrayOutputStream baos;
        private PrintStream ps;
        private ServletOutputStream sos;
        private boolean gzip;
        private int deflateLength = -1;
        private int writeLength;

        public DeflateServletOutputStreamWrapper(ServletOutputStream sos, boolean gzip, String charEncoding, int deflateLength) throws IOException {
            this.sos = sos;
            this.baos = new ByteArrayOutputStream();
            this.gzip = gzip;
            this.ps = new PrintStream((OutputStream)this.baos, true, charEncoding == null ? HttpServletResponseDeflateInterceptorService.DEFAULT_ENC : charEncoding);
        }

        public void write(int b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.baos.write(b, off, len);
        }

        public void print(String s) throws IOException {
            this.ps.print(s);
        }

        public void print(boolean b) throws IOException {
            this.ps.print(b);
        }

        public void print(char c) throws IOException {
            this.ps.print(c);
        }

        public void print(int i) throws IOException {
            this.ps.print(i);
        }

        public void print(long l) throws IOException {
            this.ps.print(l);
        }

        public void print(float f) throws IOException {
            this.ps.print(f);
        }

        public void print(double d) throws IOException {
            this.ps.print(d);
        }

        public void println() throws IOException {
            this.ps.println();
        }

        public void println(String s) throws IOException {
            this.ps.println(s);
        }

        public void println(boolean b) throws IOException {
            this.ps.println(b);
        }

        public void println(char c) throws IOException {
            this.ps.println(c);
        }

        public void println(int i) throws IOException {
            this.ps.println(i);
        }

        public void println(long l) throws IOException {
            this.ps.println(l);
        }

        public void println(float f) throws IOException {
            this.ps.println(f);
        }

        public void println(double d) throws IOException {
            this.ps.println(d);
        }

        public void flush() throws IOException {
            this.ps.flush();
            byte[] bytes = this.baos.toByteArray();
            if (bytes != null && bytes.length != 0) {
                if (bytes.length >= this.deflateLength) {
                    this.baos.reset();
                    DeflaterOutputStream dos = null;
                    dos = this.gzip ? new GZIPOutputStream(this.baos) : new DeflaterOutputStream(this.baos);
                    dos.write(bytes);
                    dos.flush();
                    dos.finish();
                    dos.close();
                    bytes = this.baos.toByteArray();
                    this.baos.reset();
                }
                this.sos.write(bytes);
                this.sos.flush();
                this.writeLength += bytes.length;
            }
            super.flush();
        }

        public int getWriteLength() {
            return this.writeLength;
        }

        public void close() throws IOException {
            this.flush();
            this.ps.close();
            this.baos.close();
            this.sos.close();
            super.close();
        }
    }

    private static class DeflateHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private String acceptEncoding;
        private String[] enabledContentTypes;
        private String[] disabledContentTypes;
        private ServletOutputStream sos;
        private PrintWriter pw;
        private int deflateLength = -1;

        public DeflateHttpServletResponseWrapper(HttpServletResponse response, String acceptEncoding, String[] enabledContentTypes, String[] disabledContentTypes, int deflateLength) {
            super(response);
            this.acceptEncoding = acceptEncoding;
            this.enabledContentTypes = enabledContentTypes;
            this.disabledContentTypes = disabledContentTypes;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            int i;
            String contentType;
            if (this.sos != null) {
                return this.sos;
            }
            if (this.disabledContentTypes != null && this.disabledContentTypes.length != 0) {
                contentType = this.getContentType();
                boolean disable = false;
                for (i = 0; i < this.disabledContentTypes.length; ++i) {
                    if (!this.disabledContentTypes[i].equalsIgnoreCase(contentType)) continue;
                    disable = true;
                    break;
                }
                if (disable) {
                    this.sos = super.getOutputStream();
                    return this.sos;
                }
            }
            if (this.enabledContentTypes != null && this.enabledContentTypes.length != 0) {
                contentType = this.getContentType();
                boolean enable = false;
                for (i = 0; i < this.enabledContentTypes.length; ++i) {
                    if (!this.enabledContentTypes[i].equalsIgnoreCase(contentType)) continue;
                    enable = true;
                    break;
                }
                if (!enable) {
                    this.sos = super.getOutputStream();
                    return this.sos;
                }
            }
            if (this.acceptEncoding.indexOf(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_GZIP) != -1 || this.acceptEncoding.indexOf(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_X_GZIP) != -1) {
                this.setHeader(HttpServletResponseDeflateInterceptorService.HEADER_CONTENT_ENCODING, HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_GZIP);
                this.sos = new DeflateServletOutputStreamWrapper(super.getOutputStream(), true, this.getCharacterEncoding(), this.deflateLength);
                return this.sos;
            }
            if (this.acceptEncoding.indexOf(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_DEFLATE) != -1) {
                this.setHeader(HttpServletResponseDeflateInterceptorService.HEADER_CONTENT_ENCODING, HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_DEFLATE);
                this.sos = new DeflateServletOutputStreamWrapper(super.getOutputStream(), false, this.getCharacterEncoding(), this.deflateLength);
                return this.sos;
            }
            this.sos = super.getOutputStream();
            return this.sos;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.pw == null) {
                String charEncoding = this.getCharacterEncoding();
                this.pw = new PrintWriter(new PrintStream((OutputStream)this.getOutputStream(), true, charEncoding == null ? HttpServletResponseDeflateInterceptorService.DEFAULT_ENC : charEncoding));
            }
            return this.pw;
        }

        public void flushBuffer() throws IOException {
            super.flushBuffer();
            if (this.sos instanceof DeflateServletOutputStreamWrapper) {
                ((DeflateServletOutputStreamWrapper)this.sos).flush();
                this.setContentLength(((DeflateServletOutputStreamWrapper)this.sos).getWriteLength());
            }
        }
    }
}

