/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.graph.DatabaseDatasetFactoryService;
import jp.ossc.nimbus.service.graph.DatabaseTimeSeriesCollectionFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

public class DatabaseTimeSeriesCollectionFactoryService
extends DatabaseDatasetFactoryService
implements DatabaseTimeSeriesCollectionFactoryServiceMBean {
    private static final long serialVersionUID = 62063250205247679L;
    private static final int PERIOD_MILLISECOND = 1;
    private static final int PERIOD_FIXEDMILLISECOND = 2;
    private static final int PERIOD_SECOND = 3;
    private static final int PERIOD_MINUTE = 4;
    private static final int PERIOD_HOUR = 5;
    private static final int PERIOD_DAY = 6;
    private static final int PERIOD_WEEK = 7;
    private static final int PERIOD_MONTH = 8;
    private static final int PERIOD_QUARTER = 9;
    private static final int PERIOD_YEAR = 10;
    private String dateColumnName;
    private String timeColumnName;
    private String valueColumnName;
    private int dateColumnIndex = -1;
    private int timeColumnIndex = -1;
    private int valueColumnIndex = -1;
    private String dateFormatPattern;
    private ServiceName dateFormatServiceName;
    private Map timePeriodClassMap;
    private int collateDataType;
    private boolean isIgnoreSameValue;
    private int collateDataField = 14;
    private int collateDataPeriod = 1;
    private int inputDataField = 14;
    private int inputDataPeriod = 1;
    private boolean isAutoTimesharing;

    public void setDateFormatPattern(String pattern) {
        this.dateFormatPattern = pattern;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateColumnName(String columnName) {
        this.dateColumnName = columnName;
    }

    public String getDateColumnName() {
        return this.dateColumnName;
    }

    public void setTimeColumnName(String columnName) {
        this.timeColumnName = columnName;
    }

    public String getTimeColumnName() {
        return this.timeColumnName;
    }

    public void setValueColumnName(String columnName) {
        this.valueColumnName = columnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setTimePeriodClass(String seriesName, Class clazz) {
        this.timePeriodClassMap.put(seriesName, clazz);
    }

    public Class getTimePeriodClass(String seriesName) {
        return (Class)this.timePeriodClassMap.get(seriesName);
    }

    public void setDateFormatServiceName(ServiceName serviceName) {
        this.dateFormatServiceName = serviceName;
    }

    public ServiceName getDateFormatServiceName() {
        return this.dateFormatServiceName;
    }

    public void setCollateDataType(int type) {
        this.collateDataType = type;
    }

    public int getCollateDataType() {
        return this.collateDataType;
    }

    public void setDateColumnIndex(int index) {
        this.dateColumnIndex = index;
    }

    public int getDateColumnIndex() {
        return this.dateColumnIndex;
    }

    public void setTimeColumnIndex(int index) {
        this.timeColumnIndex = index;
    }

    public int getTimeColumnIndex() {
        return this.timeColumnIndex;
    }

    public void setValueColumnIndex(int index) {
        this.valueColumnIndex = index;
    }

    public int getValueColumnIndex() {
        return this.valueColumnIndex;
    }

    public boolean isIgnoreSameValue() {
        return this.isIgnoreSameValue;
    }

    public void setIgnoreSameValue(boolean isIgnore) {
        this.isIgnoreSameValue = isIgnore;
    }

    public void setCollateDataPeriod(int field, int period) {
        this.collateDataField = field;
        this.collateDataPeriod = period;
    }

    public void setInputDataPeriod(int field, int period) {
        this.inputDataField = field;
        this.inputDataPeriod = period;
    }

    public void setAutoTimesharing(boolean isAuto) {
        this.isAutoTimesharing = isAuto;
    }

    public boolean isAutoTimesharing() {
        return this.isAutoTimesharing;
    }

    public void createService() throws Exception {
        super.createService();
        this.timePeriodClassMap = new HashMap();
    }

    public void startService() throws Exception {
        super.startService();
        if (this.dateFormatPattern != null) {
            new SimpleDateFormat(this.dateFormatPattern);
        }
        if (this.dateColumnName == null && this.dateColumnIndex <= 0 && this.timeColumnName == null && this.timeColumnIndex <= 0) {
            throw new IllegalArgumentException("dateColumnName or dateColumnIndex or timeColumnName or timeColumnIndex must be specified.");
        }
        if (this.valueColumnName == null && this.valueColumnIndex <= 0) {
            throw new IllegalArgumentException("valueColumnName or valueColumnIndex must be specified.");
        }
    }

    public void destroyService() throws Exception {
        this.timePeriodClassMap = null;
    }

    private long getStartMillis(Calendar cal, Date date) {
        cal.setTime(date);
        int currVal = cal.get(this.collateDataField);
        switch (this.collateDataField) {
            case 13: {
                cal.set(14, 0);
                break;
            }
            case 12: {
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 10: 
            case 11: {
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 2: 
            case 5: {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 1: {
                cal.set(2, 0);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
        }
        cal.set(this.collateDataField, currVal - currVal % this.collateDataPeriod);
        return cal.getTimeInMillis();
    }

    protected Dataset createDataset(DatasetCondition[] dsConditions, String[] seriesArray, ResultSet[] rSets) throws DatasetCreateException {
        if (seriesArray == null || seriesArray.length == 0 || rSets == null || rSets.length == 0) {
            return null;
        }
        DateFormat dateFormat = null;
        if (this.dateFormatServiceName != null) {
            dateFormat = (DateFormat)ServiceManagerFactory.getServiceObject(this.dateFormatServiceName);
        } else if (this.dateFormatPattern != null) {
            dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        Calendar workCal = Calendar.getInstance();
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        Holder inOut = new Holder();
        Record record = new Record();
        DoubleList sameDateValues = null;
        OHLCList ohlcList = null;
        try {
            for (int i = 0; i < seriesArray.length; ++i) {
                String series = seriesArray[i];
                ResultSet rs = rSets[i];
                Class timePeriodClass = (Class)this.timePeriodClassMap.get(series);
                int periodType = 0;
                TimeSeries timeSeries = null;
                if (this.collateDataType != 0) {
                    if (timePeriodClass == null) {
                        timePeriodClass = new TimeSeries(series).getTimePeriodClass();
                    }
                    timePeriodClass = class$org$jfree$data$time$Millisecond == null ? DatabaseTimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Millisecond") : class$org$jfree$data$time$Millisecond;
                    timeSeries = new TimeSeries(series, timePeriodClass);
                } else if (timePeriodClass != null) {
                    timeSeries = new TimeSeries(series, timePeriodClass);
                } else {
                    timeSeries = new TimeSeries(series);
                    timePeriodClass = timeSeries.getTimePeriodClass();
                }
                periodType = this.convertPeriodType(timePeriodClass);
                double value = 0.0;
                if (sameDateValues != null) {
                    sameDateValues.clear();
                }
                if (ohlcList != null) {
                    ohlcList.clear();
                }
                inOut.clear();
                record.clear();
                Date date = null;
                while (rs.next()) {
                    if (inOut.date == null || inOut.preDate == null) {
                        inOut.preDate = inOut.date;
                    } else {
                        inOut.preDate.setTime(inOut.date.getTime());
                    }
                    date = null;
                    if (dateFormat != null) {
                        String dateStr = null;
                        String dateVal = null;
                        String timeVal = null;
                        if (this.dateColumnIndex > 0) {
                            dateVal = rs.getString(this.dateColumnIndex);
                        } else if (this.dateColumnName != null) {
                            dateVal = rs.getString(this.dateColumnName);
                        }
                        if (this.timeColumnIndex > 0) {
                            timeVal = rs.getString(this.timeColumnIndex);
                        } else if (this.timeColumnName != null) {
                            timeVal = rs.getString(this.timeColumnName);
                        }
                        boolean isTimeOnly = false;
                        if (dateVal != null && timeVal != null) {
                            dateStr = dateVal + timeVal;
                        } else if (dateVal != null) {
                            dateStr = dateVal;
                        } else {
                            dateStr = timeVal;
                            isTimeOnly = true;
                        }
                        date = dateFormat.parse(dateStr);
                        if (isTimeOnly) {
                            Calendar cal = Calendar.getInstance();
                            int year = cal.get(1);
                            int month = cal.get(2);
                            int day = cal.get(5);
                            cal.clear();
                            cal.setTime(date);
                            cal.set(1, year);
                            cal.set(2, month);
                            cal.set(5, day);
                            date = cal.getTime();
                        }
                    } else if (this.dateColumnIndex > 0) {
                        date = rs.getDate(this.dateColumnIndex);
                    } else if (this.dateColumnName != null) {
                        date = rs.getDate(this.dateColumnName);
                    }
                    if (date == null) {
                        throw new DatasetCreateException("date is null.");
                    }
                    value = this.valueColumnIndex > 0 ? rs.getDouble(this.valueColumnIndex) : rs.getDouble(this.valueColumnName);
                    if (rs.wasNull()) continue;
                    inOut.date = date;
                    if (this.isAutoTimesharing) {
                        if (inOut.preDate != null && inOut.preDate.equals(date)) {
                            record.setDate(date);
                            record.add(value);
                            continue;
                        }
                        record.setPeriodMillis(this.getPeriodMillis(workCal, inOut.lastDate, this.inputDataField, this.inputDataPeriod));
                        inOut.date = inOut.preDate;
                        double tmpValue = Double.NaN;
                        while (record.hasNext()) {
                            if (inOut.date == null || inOut.preDate == null) {
                                inOut.preDate = (Date)inOut.date.clone();
                            } else {
                                inOut.preDate.setTime(inOut.date.getTime());
                            }
                            inOut.date = record.nextDate();
                            tmpValue = record.nextValue();
                            this.addTimeSeries(date, tmpValue, workCal, timeSeries, periodType, false, inOut);
                        }
                        record.clear();
                        inOut.date = date;
                    }
                    this.addTimeSeries(date, value, workCal, timeSeries, periodType, false, inOut);
                }
                if (inOut.lastDate != null && this.collateDataType != 0) {
                    if (this.isAutoTimesharing && record.size() != 0) {
                        record.setPeriodMillis(this.getPeriodMillis(workCal, inOut.lastDate, this.inputDataField, this.inputDataPeriod));
                        inOut.date = inOut.preDate;
                        double tmpValue = Double.NaN;
                        while (record.hasNext()) {
                            if (inOut.date == null || inOut.preDate == null) {
                                inOut.preDate = (Date)inOut.date.clone();
                            } else {
                                inOut.preDate.setTime(inOut.date.getTime());
                            }
                            inOut.date = record.nextDate();
                            tmpValue = record.nextValue();
                            this.addTimeSeries(date, tmpValue, workCal, timeSeries, periodType, false, inOut);
                        }
                        record.clear();
                        inOut.date = date;
                    }
                    this.addTimeSeries(date, value, workCal, timeSeries, periodType, true, inOut);
                }
                dataset.addSeries(timeSeries);
                timePeriodClass = null;
            }
        }
        catch (SQLException e) {
            throw new DatasetCreateException(e);
        }
        catch (ParseException e) {
            throw new DatasetCreateException(e);
        }
        return dataset;
    }

    private void addTimeSeries(Date realDate, double value, Calendar workCal, TimeSeries timeSeries, int periodType, boolean isFinish, Holder inOut) {
        if (this.collateDataType != 0) {
            long period = this.getPeriodMillis(workCal, inOut.date, this.collateDataField, this.collateDataPeriod);
            long startMillis = this.getStartMillis(workCal, inOut.date);
            switch (this.collateDataType) {
                case 1: {
                    if (inOut.lastStartMillis != -1L && inOut.lastStartMillis == startMillis && !isFinish) {
                        if (Double.isNaN(inOut.validValue)) {
                            inOut.validValue = value;
                        }
                        return;
                    }
                    inOut.validValue = Double.NaN;
                    break;
                }
                case 2: {
                    if (inOut.lastStartMillis != -1L && inOut.lastStartMillis == startMillis && !isFinish) {
                        inOut.validValue = value;
                        return;
                    }
                    if (timeSeries.getItemCount() == 0 || Double.isNaN(inOut.validValue)) break;
                    if (!this.isIgnoreSameValue || !inOut.existSameValue) {
                        int lastIndex = timeSeries.getItemCount() - 1;
                        timeSeries.update(lastIndex, (Number)new Double(inOut.validValue));
                    } else if (inOut.lastValue != inOut.validValue) {
                        this.addTimeSeries(timeSeries, inOut.preDate, inOut.validValue, periodType, inOut);
                        inOut.existSameValue = false;
                    }
                    inOut.validValue = Double.NaN;
                    break;
                }
                case 3: {
                    if (inOut.lastStartMillis != -1L && inOut.lastStartMillis == startMillis && !isFinish) {
                        if (inOut.sameDateValues == null) {
                            inOut.sameDateValues = new DoubleList();
                        }
                        if (this.isIgnoreSameValue) {
                            if (!Double.isNaN(inOut.lastValueForAll) && inOut.lastValueForAll == value) {
                                inOut.existSameValueForAll = true;
                            } else {
                                if (inOut.existSameValue) {
                                    this.addTimeSeries(timeSeries, inOut.preDate, inOut.lastValue, periodType, inOut);
                                    inOut.existSameValue = false;
                                }
                                if (inOut.existSameValueForAll) {
                                    inOut.sameDateValues.add(inOut.lastValueForAll);
                                    inOut.existSameValueForAll = false;
                                }
                                inOut.sameDateValues.add(value);
                            }
                        } else {
                            inOut.sameDateValues.add(value);
                        }
                        inOut.lastValueForAll = value;
                        return;
                    }
                    if (inOut.sameDateValues != null && inOut.sameDateValues.size() > 0) {
                        long interval = (isFinish ? inOut.date.getTime() - startMillis : period) / (long)(isFinish ? inOut.sameDateValues.size() : inOut.sameDateValues.size() + 1);
                        long additionalTime = inOut.lastStartMillis;
                        DoubleList.DoubleIterator vals = inOut.sameDateValues.iterator();
                        int count = 0;
                        while (vals.hasNext() && (long)count < period) {
                            additionalTime += interval;
                            if (inOut.preDate == null) {
                                inOut.preDate = new Date(additionalTime);
                            } else {
                                inOut.preDate.setTime(additionalTime);
                            }
                            if (interval == 0L) {
                                this.addOrUpdateTimeSeries(timeSeries, inOut.preDate, vals.next(), periodType, inOut);
                            } else {
                                this.addTimeSeries(timeSeries, inOut.preDate, vals.next(), periodType, inOut);
                            }
                            ++count;
                        }
                        inOut.sameDateValues.clear();
                    } else if (isFinish && this.isIgnoreSameValue && inOut.existSameValue) {
                        this.addTimeSeries(timeSeries, inOut.date, value, periodType, inOut);
                    }
                    inOut.date = new Date(startMillis);
                    inOut.lastValueForAll = value;
                    break;
                }
                case 4: {
                    if (inOut.lastStartMillis != -1L && inOut.lastStartMillis == startMillis && !isFinish) {
                        if (inOut.sameDateValues == null) {
                            inOut.sameDateValues = new DoubleList();
                        }
                        inOut.sameDateValues.add(value);
                        return;
                    }
                    if (inOut.sameDateValues != null && inOut.sameDateValues.size() > 0 || isFinish) {
                        if (isFinish) {
                            if (inOut.sameDateValues != null && inOut.sameDateValues.size() != 0) {
                                long interval;
                                if (this.isIgnoreSameValue) {
                                    DoubleList.DoubleIterator vals = inOut.sameDateValues.iterator();
                                    double tmpLastValue = inOut.lastValue;
                                    while (vals.hasNext()) {
                                        double val = vals.next();
                                        if (!Double.isNaN(tmpLastValue) && tmpLastValue == val) {
                                            if (vals.hasNext()) {
                                                vals.remove();
                                            }
                                        } else if (inOut.existSameValue) {
                                            this.addTimeSeries(timeSeries, inOut.preDate, inOut.lastValue, periodType, inOut);
                                            inOut.existSameValue = false;
                                        }
                                        tmpLastValue = val;
                                    }
                                    vals.reset();
                                }
                                if ((interval = (inOut.date.getTime() - startMillis) / (long)inOut.sameDateValues.size()) == 0L) {
                                    DoubleList.DoubleIterator vals = inOut.sameDateValues.iterator();
                                    int lastIndex = timeSeries.getItemCount() - 1;
                                    double sum = inOut.lastValue;
                                    while (vals.hasNext()) {
                                        sum += vals.next();
                                    }
                                    double average = sum / (double)(inOut.sameDateValues.size() + 1);
                                    if (!this.isIgnoreSameValue || !inOut.existSameValue) {
                                        timeSeries.update(lastIndex, (Number)new Double(average));
                                        inOut.lastValue = average;
                                    } else {
                                        this.addTimeSeries(timeSeries, inOut.preDate, average, periodType, inOut);
                                        inOut.existSameValue = false;
                                    }
                                } else {
                                    long additionalTime = inOut.lastStartMillis;
                                    int count = 0;
                                    DoubleList.DoubleIterator vals = inOut.sameDateValues.iterator();
                                    while (vals.hasNext() && (long)count < inOut.date.getTime() - startMillis) {
                                        additionalTime += interval;
                                        if (inOut.preDate == null) {
                                            inOut.preDate = new Date(additionalTime);
                                        } else {
                                            inOut.preDate.setTime(additionalTime);
                                        }
                                        this.addTimeSeries(timeSeries, inOut.preDate, vals.next(), periodType, inOut);
                                        ++count;
                                    }
                                }
                            } else if (this.isIgnoreSameValue && inOut.existSameValue) {
                                this.addTimeSeries(timeSeries, inOut.preDate, inOut.lastValue, periodType, inOut);
                                inOut.existSameValue = false;
                            } else {
                                this.deleteTimeSeries(timeSeries, inOut.lastDate, periodType);
                                this.addTimeSeries(timeSeries, realDate, value, periodType, inOut);
                            }
                        } else {
                            DoubleList.DoubleIterator vals = inOut.sameDateValues.iterator();
                            int lastIndex = timeSeries.getItemCount() - 1;
                            double sum = inOut.lastValue;
                            while (vals.hasNext()) {
                                sum += vals.next();
                            }
                            double average = sum / (double)(inOut.sameDateValues.size() + 1);
                            if (!this.isIgnoreSameValue || !inOut.existSameValue) {
                                timeSeries.update(lastIndex, (Number)new Double(average));
                                inOut.lastValue = average;
                            } else if (inOut.lastValue != average) {
                                this.addTimeSeries(timeSeries, inOut.preDate, average, periodType, inOut);
                                inOut.existSameValue = false;
                            }
                        }
                        if (inOut.sameDateValues != null) {
                            inOut.sameDateValues.clear();
                        }
                    }
                    inOut.date = new Date(startMillis);
                    break;
                }
                case 5: {
                    if (inOut.lastStartMillis != -1L && inOut.lastStartMillis == startMillis && !isFinish) {
                        if (inOut.ohlcList == null) {
                            inOut.ohlcList = new OHLCList();
                        }
                        if (inOut.ohlcList.size() == 0) {
                            inOut.ohlcList.add(inOut.lastValue);
                        }
                        inOut.ohlcList.add(value);
                        return;
                    }
                    if (inOut.ohlcList != null && inOut.ohlcList.size() > 0 || isFinish) {
                        if (inOut.ohlcList != null && inOut.ohlcList.size() > 0) {
                            long interval = (isFinish ? inOut.date.getTime() - startMillis : period) / (long)(isFinish ? inOut.ohlcList.size() - 1 : inOut.ohlcList.size());
                            long additionalTime = inOut.lastStartMillis;
                            OHLCList.OHLCIterator vals = inOut.ohlcList.iterator();
                            int count = 0;
                            while (vals.hasNext() && (long)count < period) {
                                double tmpValue = vals.next();
                                if (inOut.preDate == null) {
                                    inOut.preDate = new Date(additionalTime);
                                } else {
                                    inOut.preDate.setTime(additionalTime);
                                }
                                if (count == 0) {
                                    if (this.isIgnoreSameValue && inOut.existSameValue && (inOut.ohlcList.size() != 2 || inOut.ohlcList.open != inOut.ohlcList.close)) {
                                        this.addTimeSeries(timeSeries, inOut.preDate, tmpValue, periodType, inOut);
                                        inOut.existSameValue = false;
                                    }
                                } else if (this.isIgnoreSameValue && inOut.lastValue == tmpValue && (vals.hasNext() || !isFinish)) {
                                    inOut.existSameValue = true;
                                    if (inOut.lastDate == null) {
                                        inOut.lastDate = (Date)inOut.preDate.clone();
                                    } else {
                                        inOut.lastDate.setTime(inOut.preDate.getTime());
                                    }
                                } else if (interval == 0L) {
                                    this.addOrUpdateTimeSeries(timeSeries, inOut.preDate, tmpValue, periodType, inOut);
                                } else {
                                    this.addTimeSeries(timeSeries, inOut.preDate, tmpValue, periodType, inOut);
                                }
                                additionalTime += interval;
                                ++count;
                            }
                        } else if (isFinish) {
                            if (this.isIgnoreSameValue && inOut.existSameValue) {
                                this.addTimeSeries(timeSeries, inOut.date, value, periodType, inOut);
                            } else {
                                this.deleteTimeSeries(timeSeries, inOut.lastDate, periodType);
                                this.addTimeSeries(timeSeries, realDate, value, periodType, inOut);
                            }
                        }
                        if (inOut.ohlcList != null) {
                            inOut.ohlcList.clear();
                        }
                    }
                    inOut.date = new Date(startMillis);
                    break;
                }
            }
            inOut.lastStartMillis = startMillis;
        }
        if (!isFinish) {
            if (this.isIgnoreSameValue) {
                if (!Double.isNaN(inOut.lastValue) && inOut.lastValue == value) {
                    inOut.existSameValue = true;
                } else {
                    if (inOut.existSameValue) {
                        this.addTimeSeries(timeSeries, inOut.preDate, inOut.lastValue, periodType, inOut);
                        inOut.existSameValue = false;
                    }
                    this.addTimeSeries(timeSeries, inOut.date, value, periodType, inOut);
                }
            } else {
                this.addTimeSeries(timeSeries, inOut.date, value, periodType, inOut);
            }
            if (inOut.preDate == null) {
                inOut.preDate = (Date)inOut.date.clone();
            } else {
                inOut.preDate.setTime(inOut.date.getTime());
            }
        }
    }

    private long getPeriodMillis(Calendar cal, Date date, int field, int period) {
        switch (field) {
            case 13: {
                return 1000 * period;
            }
            case 12: {
                return 60000 * period;
            }
            case 10: {
                return 3600000 * period;
            }
            case 5: {
                return 86400000 * period;
            }
            case 2: {
                cal.setTime(date);
                int dayOfMonth = cal.getActualMaximum(5);
                return dayOfMonth * 24 * 60 * 60 * 1000 * period;
            }
            case 1: {
                cal.setTime(date);
                int dayOfYear = cal.getActualMaximum(6);
                return dayOfYear * 24 * 60 * 60 * 1000 * period;
            }
        }
        return 1 * period;
    }

    private int convertPeriodType(Class timePeriodClass) {
        if (timePeriodClass.equals(Millisecond.class)) {
            return 1;
        }
        if (timePeriodClass.equals(FixedMillisecond.class)) {
            return 2;
        }
        if (timePeriodClass.equals(Second.class)) {
            return 3;
        }
        if (timePeriodClass.equals(Minute.class)) {
            return 4;
        }
        if (timePeriodClass.equals(Hour.class)) {
            return 5;
        }
        if (timePeriodClass.equals(Day.class)) {
            return 6;
        }
        if (timePeriodClass.equals(Week.class)) {
            return 7;
        }
        if (timePeriodClass.equals(Month.class)) {
            return 8;
        }
        if (timePeriodClass.equals(Quarter.class)) {
            return 9;
        }
        if (timePeriodClass.equals(Year.class)) {
            return 10;
        }
        return 0;
    }

    private TimeSeries addTimeSeries(TimeSeries series, Date date, double value, int periodType, Holder inOut) {
        switch (periodType) {
            case 1: {
                series.add((RegularTimePeriod)new Millisecond(date), value);
                break;
            }
            case 2: {
                series.add((RegularTimePeriod)new FixedMillisecond(date), value);
                break;
            }
            case 3: {
                series.add((RegularTimePeriod)new Second(date), value);
                break;
            }
            case 4: {
                series.add((RegularTimePeriod)new Minute(date), value);
                break;
            }
            case 5: {
                series.add((RegularTimePeriod)new Hour(date), value);
                break;
            }
            case 6: {
                series.add((RegularTimePeriod)new Day(date), value);
                break;
            }
            case 7: {
                series.add((RegularTimePeriod)new Week(date), value);
                break;
            }
            case 8: {
                series.add((RegularTimePeriod)new Month(date), value);
                break;
            }
            case 9: {
                series.add((RegularTimePeriod)new Quarter(date), value);
                break;
            }
            case 10: {
                series.add((RegularTimePeriod)new Year(date), value);
                break;
            }
        }
        if (inOut.lastDate == null) {
            inOut.lastDate = (Date)date.clone();
        } else {
            inOut.lastDate.setTime(date.getTime());
        }
        inOut.lastValue = value;
        return series;
    }

    private TimeSeries addOrUpdateTimeSeries(TimeSeries series, Date date, double value, int periodType, Holder inOut) {
        switch (periodType) {
            case 1: {
                series.addOrUpdate((RegularTimePeriod)new Millisecond(date), value);
                break;
            }
            case 2: {
                series.addOrUpdate((RegularTimePeriod)new FixedMillisecond(date), value);
                break;
            }
            case 3: {
                series.addOrUpdate((RegularTimePeriod)new Second(date), value);
                break;
            }
            case 4: {
                series.addOrUpdate((RegularTimePeriod)new Minute(date), value);
                break;
            }
            case 5: {
                series.addOrUpdate((RegularTimePeriod)new Hour(date), value);
                break;
            }
            case 6: {
                series.addOrUpdate((RegularTimePeriod)new Day(date), value);
                break;
            }
            case 7: {
                series.addOrUpdate((RegularTimePeriod)new Week(date), value);
                break;
            }
            case 8: {
                series.addOrUpdate((RegularTimePeriod)new Month(date), value);
                break;
            }
            case 9: {
                series.addOrUpdate((RegularTimePeriod)new Quarter(date), value);
                break;
            }
            case 10: {
                series.addOrUpdate((RegularTimePeriod)new Year(date), value);
                break;
            }
        }
        if (inOut.lastDate == null) {
            inOut.lastDate = (Date)date.clone();
        } else {
            inOut.lastDate.setTime(date.getTime());
        }
        inOut.lastValue = value;
        return series;
    }

    private TimeSeries deleteTimeSeries(TimeSeries series, Date date, int periodType) {
        switch (periodType) {
            case 1: {
                series.delete((RegularTimePeriod)new Millisecond(date));
                break;
            }
            case 2: {
                series.delete((RegularTimePeriod)new FixedMillisecond(date));
                break;
            }
            case 3: {
                series.delete((RegularTimePeriod)new Second(date));
                break;
            }
            case 4: {
                series.delete((RegularTimePeriod)new Minute(date));
                break;
            }
            case 5: {
                series.delete((RegularTimePeriod)new Hour(date));
                break;
            }
            case 6: {
                series.delete((RegularTimePeriod)new Day(date));
                break;
            }
            case 7: {
                series.delete((RegularTimePeriod)new Week(date));
                break;
            }
            case 8: {
                series.delete((RegularTimePeriod)new Month(date));
                break;
            }
            case 9: {
                series.delete((RegularTimePeriod)new Quarter(date));
                break;
            }
            case 10: {
                series.delete((RegularTimePeriod)new Year(date));
                break;
            }
        }
        return series;
    }

    private static class OHLCList {
        private double open = Double.NaN;
        private double high = Double.NaN;
        private double low = Double.NaN;
        private double close = Double.NaN;
        private boolean isHighLow = true;
        private OHLCIterator ohlcIterator = new OHLCIterator();

        private OHLCList() {
        }

        public void add(double val) {
            if (Double.isNaN(this.open)) {
                this.open = val;
                this.high = val;
                this.low = val;
            }
            if (val > this.high) {
                this.high = val;
                this.isHighLow = false;
            }
            if (val < this.low) {
                this.low = val;
                this.isHighLow = true;
            }
            this.close = val;
        }

        public int size() {
            if (Double.isNaN(this.open)) {
                return 0;
            }
            int size = 2;
            if (this.high != this.open && this.high != this.close || this.high == this.open && this.high != this.close && !this.isHighLow || this.high != this.open && this.high == this.close && this.isHighLow) {
                ++size;
            }
            if (this.low != this.open && this.low != this.close || this.low == this.open && this.low != this.close && this.isHighLow || this.low != this.open && this.low == this.close && !this.isHighLow) {
                ++size;
            }
            return size;
        }

        public OHLCIterator iterator() {
            return this.ohlcIterator;
        }

        public void clear() {
            this.open = Double.NaN;
            this.close = Double.NaN;
            this.high = Double.NaN;
            this.low = Double.NaN;
            this.ohlcIterator.reset();
        }

        private class OHLCIterator {
            private int index = 0;
            private int maxSize;

            private OHLCIterator() {
            }

            public boolean hasNext() {
                if (this.index == 0) {
                    this.maxSize = OHLCList.this.size();
                }
                return this.maxSize > this.index;
            }

            public double next() {
                switch (this.index++) {
                    case 0: {
                        return OHLCList.this.open;
                    }
                    case 1: {
                        if (OHLCList.this.high == OHLCList.this.low) {
                            return OHLCList.this.close;
                        }
                        if (OHLCList.this.isHighLow) {
                            if (OHLCList.this.open == OHLCList.this.high) {
                                return OHLCList.this.low;
                            }
                            return OHLCList.this.high;
                        }
                        if (OHLCList.this.open == OHLCList.this.low) {
                            return OHLCList.this.high;
                        }
                        return OHLCList.this.low;
                    }
                    case 2: {
                        if (OHLCList.this.isHighLow) {
                            if (OHLCList.this.open == OHLCList.this.high) {
                                return OHLCList.this.close;
                            }
                            return OHLCList.this.low;
                        }
                        if (OHLCList.this.open == OHLCList.this.low) {
                            return OHLCList.this.close;
                        }
                        return OHLCList.this.high;
                    }
                }
                return OHLCList.this.close;
            }

            public void reset() {
                this.index = 0;
                this.maxSize = 0;
            }
        }
    }

    private static class DoubleList {
        private static final int INIT_SIZE = 10;
        private static final int CAPACITY_INCREMENT_SIZE = 10;
        private double[] vals = new double[10];
        private int index;
        private DoubleIterator doubleIterator = new DoubleIterator();

        private DoubleList() {
        }

        public void add(double val) {
            if (this.vals.length <= this.index) {
                double[] tmpVals = new double[this.vals.length + 10];
                System.arraycopy(this.vals, 0, tmpVals, 0, this.vals.length);
                this.vals = tmpVals;
            }
            this.vals[this.index++] = val;
        }

        public int size() {
            return this.index;
        }

        public DoubleIterator iterator() {
            return this.doubleIterator;
        }

        public void clear() {
            this.index = 0;
            this.doubleIterator.reset();
        }

        private class DoubleIterator {
            private int iteratorIndex = 0;

            private DoubleIterator() {
            }

            public boolean hasNext() {
                return DoubleList.this.index > this.iteratorIndex;
            }

            public double next() {
                return DoubleList.this.vals[this.iteratorIndex++];
            }

            public void remove() {
                System.arraycopy(DoubleList.this.vals, this.iteratorIndex, DoubleList.this.vals, this.iteratorIndex - 1, DoubleList.this.index - this.iteratorIndex);
                --this.iteratorIndex;
                DoubleList.this.index--;
            }

            public void reset() {
                this.iteratorIndex = 0;
            }
        }
    }

    private static class Holder {
        public boolean existSameValue;
        public double validValue = Double.NaN;
        public DoubleList sameDateValues;
        public OHLCList ohlcList;
        public double lastValueForAll = Double.NaN;
        public boolean existSameValueForAll;
        public long lastStartMillis = -1L;
        public Date date;
        public Date preDate;
        public Date lastDate;
        public double lastValue = Double.NaN;

        private Holder() {
        }

        public void clear() {
            this.existSameValue = false;
            this.validValue = Double.NaN;
            this.sameDateValues = null;
            this.ohlcList = null;
            this.lastValueForAll = Double.NaN;
            this.existSameValueForAll = false;
            this.lastStartMillis = -1L;
            this.date = null;
            this.preDate = null;
            this.lastDate = null;
            this.lastValue = Double.NaN;
        }
    }

    private static class Record {
        private Date date;
        private DoubleList doubleList = new DoubleList();
        private long periodMillis = -1L;

        private Record() {
        }

        public void add(double val) {
            this.doubleList.add(val);
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public void setPeriodMillis(long millis) {
            this.periodMillis = millis;
        }

        public Date nextDate() {
            long millis = this.date.getTime();
            long interval = this.periodMillis / (long)(this.size() + 1);
            this.date.setTime(millis + interval);
            return this.date;
        }

        public double nextValue() {
            return this.doubleList.iterator().next();
        }

        public boolean hasNext() {
            return this.doubleList.iterator().hasNext();
        }

        public int size() {
            return this.doubleList.size();
        }

        public void clear() {
            this.date = null;
            this.doubleList.clear();
            this.periodMillis = -1L;
        }
    }
}

