/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.RecordList;

public class DataSet
implements Serializable {
    private static final long serialVersionUID = 452460154073106633L;
    protected String name;
    protected Map headerMap;
    protected Map recordListMap;

    public DataSet() {
    }

    public DataSet(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHeaderSchema(String schema) throws PropertySchemaDefineException {
        this.setHeaderSchema(null, schema);
    }

    public void setHeaderSchema(String name, String schema) throws PropertySchemaDefineException {
        if (this.headerMap == null) {
            this.headerMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.headerMap.put(name, new Header(name, schema));
    }

    public void setRecordListSchema(String schema) throws PropertySchemaDefineException {
        this.setRecordListSchema(null, schema);
    }

    public void setRecordListSchema(String name, String schema) throws PropertySchemaDefineException {
        if (this.recordListMap == null) {
            this.recordListMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.recordListMap.put(name, new RecordList(name, schema));
    }

    public void setSchema(String headerSchema, String recordListSchema) throws PropertySchemaDefineException {
        this.setSchema(null, headerSchema, recordListSchema);
    }

    public void setSchema(String name, String headerSchema, String recordListSchema) throws PropertySchemaDefineException {
        if (headerSchema != null) {
            this.setHeaderSchema(name, headerSchema);
        }
        if (recordListSchema != null) {
            this.setRecordListSchema(name, recordListSchema);
        }
    }

    public Header getHeader() {
        return this.getHeader(null);
    }

    public Header getHeader(String name) {
        return this.headerMap == null ? null : (Header)this.headerMap.get(name);
    }

    public String[] getHeaderNames() {
        return this.headerMap == null ? new String[]{} : this.headerMap.keySet().toArray(new String[this.headerMap.size()]);
    }

    public int getHeaderSize() {
        return this.headerMap == null ? 0 : this.headerMap.size();
    }

    public Map getHeaderMap() {
        return this.headerMap;
    }

    public void addHeader(Header header) {
        this.headerMap.put(header.getName(), header);
    }

    public RecordList getRecordList() {
        return this.getRecordList(null);
    }

    public RecordList getRecordList(String name) {
        return this.recordListMap == null ? null : (RecordList)this.recordListMap.get(name);
    }

    public String[] getRecordListNames() {
        return this.recordListMap == null ? new String[]{} : this.recordListMap.keySet().toArray(new String[this.recordListMap.size()]);
    }

    public int getRecordListSize() {
        return this.recordListMap == null ? 0 : this.recordListMap.size();
    }

    public Map getRecordListMap() {
        return this.recordListMap;
    }

    public void addRecordList(RecordList recList) {
        this.recordListMap.put(recList.getName(), recList);
    }

    public void clear() {
        int i;
        if (this.headerMap != null && this.headerMap.size() != 0) {
            String[] headerNames = this.headerMap.keySet().toArray(new String[this.headerMap.size()]);
            for (i = 0; i < headerNames.length; ++i) {
                Header header = this.getHeader(headerNames[i]);
                if (header == null) continue;
                header.clear();
            }
        }
        if (this.recordListMap != null && this.recordListMap.size() != 0) {
            String[] recListNames = this.recordListMap.keySet().toArray(new String[this.recordListMap.size()]);
            for (i = 0; i < recListNames.length; ++i) {
                RecordList recList = this.getRecordList(recListNames[i]);
                if (recList == null) continue;
                recList.clear();
            }
        }
    }

    public DataSet cloneSchema() {
        return this.cloneDataSet(false);
    }

    public DataSet cloneDataSet() {
        return this.cloneDataSet(true);
    }

    protected DataSet cloneDataSet(boolean hasData) {
        int i;
        DataSet dataSet = new DataSet(this.name);
        if (this.headerMap != null && this.headerMap.size() != 0) {
            String[] headerNames = this.headerMap.keySet().toArray(new String[this.headerMap.size()]);
            dataSet.headerMap = Collections.synchronizedMap(new LinkedHashMap());
            for (i = 0; i < headerNames.length; ++i) {
                Header header = this.getHeader(headerNames[i]);
                if (header == null) continue;
                dataSet.headerMap.put(headerNames[i], hasData ? header.cloneRecord() : header.cloneSchema());
            }
        }
        if (this.recordListMap != null && this.recordListMap.size() != 0) {
            String[] recListNames = this.recordListMap.keySet().toArray(new String[this.recordListMap.size()]);
            dataSet.recordListMap = Collections.synchronizedMap(new LinkedHashMap());
            for (i = 0; i < recListNames.length; ++i) {
                RecordList recList = this.getRecordList(recListNames[i]);
                if (recList == null) continue;
                dataSet.recordListMap.put(recListNames[i], hasData ? recList.cloneRecordList() : recList.cloneSchema());
            }
        }
        return dataSet;
    }
}

