/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.RecordSchema;

public class Record
implements Serializable {
    private static final long serialVersionUID = -6640296864936227160L;
    protected String schema;
    protected transient RecordSchema recordSchema;
    protected Map values;

    public Record(String schema) throws PropertySchemaDefineException {
        this(schema, RecordSchema.getInstance(schema));
    }

    public Record(String schema, RecordSchema recordSchema) {
        this.schema = schema;
        this.recordSchema = recordSchema;
    }

    public String getSchema() {
        return this.schema;
    }

    public RecordSchema getRecordSchema() {
        return this.recordSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, Object val) throws PropertySetException {
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + name);
        }
        if (this.values == null) {
            Record record = this;
            synchronized (record) {
                if (this.values == null) {
                    this.values = Collections.synchronizedMap(new HashMap());
                }
            }
        }
        this.values.put(name, propertySchema.set(val));
    }

    public void setProperty(int index, Object val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, boolean val) throws PropertySetException {
        this.setProperty(name, (Object)(val ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setProperty(int index, boolean val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, byte val) throws PropertySetException {
        this.setProperty(name, (Object)new Byte(val));
    }

    public void setProperty(int index, byte val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, char val) throws PropertySetException {
        this.setProperty(name, (Object)new Character(val));
    }

    public void setProperty(int index, char val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, short val) throws PropertySetException {
        this.setProperty(name, (Object)new Short(val));
    }

    public void setProperty(int index, short val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, int val) throws PropertySetException {
        this.setProperty(name, (Object)new Integer(val));
    }

    public void setProperty(int index, int val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, long val) throws PropertySetException {
        this.setProperty(name, (Object)new Long(val));
    }

    public void setProperty(int index, long val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, float val) throws PropertySetException {
        this.setProperty(name, (Object)new Float(val));
    }

    public void setProperty(int index, float val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void setProperty(String name, double val) throws PropertySetException {
        this.setProperty(name, (Object)new Double(val));
    }

    public void setProperty(int index, double val) throws PropertySetException {
        this.setProperty(this.recordSchema.getPropertyName(index), val);
    }

    public Object getProperty(String name) throws PropertyGetException {
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertyGetException(null, "No such property : " + name);
        }
        return propertySchema.get(this.values == null ? null : this.values.get(name));
    }

    public Object getProperty(int index) throws PropertyGetException {
        return this.getProperty(this.recordSchema.getPropertyName(index));
    }

    public boolean getBooleanProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return false;
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        if (ret instanceof String) {
            try {
                return Integer.parseInt((String)ret) != 0;
            }
            catch (NumberFormatException e) {
                return Boolean.valueOf((String)ret);
            }
        }
        if (ret instanceof Number) {
            return ((Number)ret).intValue() != 0;
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public boolean getBooleanProperty(int index) throws PropertyGetException {
        return this.getBooleanProperty(this.recordSchema.getPropertyName(index));
    }

    public byte getByteProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).byteValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? (byte)1 : 0;
        }
        if (ret instanceof String) {
            try {
                return Byte.parseByte((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public byte getByteProperty(int index) throws PropertyGetException {
        return this.getByteProperty(this.recordSchema.getPropertyName(index));
    }

    public short getShortProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).shortValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? (short)1 : 0;
        }
        if (ret instanceof String) {
            try {
                return Short.parseShort((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public short getShortProperty(int index) throws PropertyGetException {
        return this.getShortProperty(this.recordSchema.getPropertyName(index));
    }

    public int getIntProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).intValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1 : 0;
        }
        if (ret instanceof String) {
            try {
                return Integer.parseInt((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public int getIntProperty(int index) throws PropertyGetException {
        return this.getIntProperty(this.recordSchema.getPropertyName(index));
    }

    public long getLongProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0L;
        }
        if (ret instanceof Number) {
            return ((Number)ret).longValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1L : 0L;
        }
        if (ret instanceof String) {
            try {
                return Long.parseLong((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public long getLongProperty(int index) throws PropertyGetException {
        return this.getLongProperty(this.recordSchema.getPropertyName(index));
    }

    public float getFloatProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0.0f;
        }
        if (ret instanceof Number) {
            return ((Number)ret).floatValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1.0f : 0.0f;
        }
        if (ret instanceof String) {
            try {
                return Float.parseFloat((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public float getFloatProperty(int index) throws PropertyGetException {
        return this.getFloatProperty(this.recordSchema.getPropertyName(index));
    }

    public double getDoubleProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return 0.0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).doubleValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1.0 : 0.0;
        }
        if (ret instanceof String) {
            try {
                return Double.parseDouble((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(name), "The type is unmatch. value=" + ret);
    }

    public double getDoubleProperty(int index) throws PropertyGetException {
        return this.getDoubleProperty(this.recordSchema.getPropertyName(index));
    }

    public String getStringProperty(String name) throws PropertyGetException {
        Object ret = this.getProperty(name);
        if (ret == null) {
            return null;
        }
        if (ret instanceof String) {
            return (String)ret;
        }
        return ret.toString();
    }

    public String getStringProperty(int index) throws PropertyGetException {
        return this.getStringProperty(this.recordSchema.getPropertyName(index));
    }

    public Object getFormatProperty(String name) throws PropertyGetException {
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertyGetException(null, "No such property : " + name);
        }
        return propertySchema.format(this.getProperty(name));
    }

    public Object getFormatProperty(int index) throws PropertyGetException {
        return this.getFormatProperty(this.recordSchema.getPropertyName(index));
    }

    public void setParseProperty(String name, Object val) throws PropertySetException {
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + name);
        }
        this.setProperty(name, propertySchema.parse(val));
    }

    public void setParseProperty(int index, Object val) throws PropertySetException {
        this.setParseProperty(this.recordSchema.getPropertyName(index), val);
    }

    public void clear() {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public Record cloneSchema() {
        return new Record(this.schema);
    }

    public Record cloneRecord() {
        Record record = this.cloneSchema();
        if (this.values != null) {
            record.values = Collections.synchronizedMap(new HashMap());
            record.values.putAll(this.values);
        }
        return record;
    }

    public String toString() {
        return this.values == null ? "{}" : this.values.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.schema != null) {
            this.recordSchema = RecordSchema.getInstance(this.schema);
        }
    }
}

