/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.ioc.ejb.command;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.IOCException;
import jp.ossc.nimbus.ioc.ejb.BeanFlowClient;
import jp.ossc.nimbus.ioc.ejb.UtilTool;
import jp.ossc.nimbus.service.aop.DefaultMethodInvocationContext;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvoker;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvokerFactory;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetCheckedException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetUncheckedException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.log.Logger;

public class SLSBCommandBean
extends BeanFlowClient
implements SessionBean {
    private static final long serialVersionUID = 3745197383168852889L;
    private static final String C_INTERCEPTOR_SERVICE_NAME_JNDI_KEY = "java:comp/env/interceptorChainInvokerFactoryServiceNameJNDIKey";
    private static final String C_BEAN_FLOW_SERVICE_NAME_JNDI_KEY = "java:comp/env/beanFlowFactoryServiceNameJNDIKey";
    private static final String C_LOGGER_JNDI_KEY = "java:comp/env/logger";
    private static Method CALLBACK_METHOD;

    public void ejbCreate() throws CreateException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            String value = (String)ctx.lookup(C_LOGGER_JNDI_KEY);
            ServiceName serviceName = null;
            Logger logger = null;
            if (value != null && value.length() > 0) {
                serviceName = UtilTool.convertServiceName(value);
                logger = (Logger)((Object)ServiceManagerFactory.getService(serviceName));
            } else {
                logger = (Logger)((Object)ServiceManagerFactory.getService(serviceName));
            }
            InterceptorChainInvokerFactory iciFactory = null;
            InterceptorChainFactory icFactory = null;
            value = (String)ctx.lookup(C_INTERCEPTOR_SERVICE_NAME_JNDI_KEY);
            if (value != null && value.length() > 0) {
                serviceName = UtilTool.convertServiceName(value);
                Service factory = ServiceManagerFactory.getService(serviceName);
                if (factory instanceof InterceptorChainInvokerFactory) {
                    iciFactory = (InterceptorChainInvokerFactory)((Object)factory);
                } else {
                    icFactory = (InterceptorChainFactory)((Object)factory);
                }
            }
            value = (String)ctx.lookup(C_BEAN_FLOW_SERVICE_NAME_JNDI_KEY);
            serviceName = UtilTool.convertServiceName(value);
            BeanFlowInvokerFactory bfFactory = (BeanFlowInvokerFactory)((Object)ServiceManagerFactory.getService(serviceName));
            super.init(logger, iciFactory, icFactory, bfFactory);
        }
        catch (NamingException e) {
            CreateException ce = new CreateException("InitialContext Error");
            ce.initCause((Throwable)e);
            throw ce;
        }
    }

    public Command invokeCommand(Command cmd) {
        if (this.getLogger() != null) {
            this.getLogger().write("IOC__00006");
        }
        String key = cmd.getFlowKey();
        InterceptorChainInvoker ici = null;
        InterceptorChain ic = null;
        if (this.getIciFactory() != null) {
            ici = this.getIciFactory().createInterceptorInvoker(key);
        } else if (this.getIcFactory() != null) {
            ic = this.getIcFactory().getInterceptorChain(key);
        }
        Object ret = null;
        if (ici == null && ic == null) {
            if (this.getLogger() != null) {
                this.getLogger().write("IOC__00007");
            }
            try {
                ret = this.invokeBeanFlow(cmd);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                cmd.setException(e);
            }
            catch (Throwable e) {
                throw new IOCException("SLSBCommandBean invokeCommand Unrecognize Exception", e);
            }
        } else {
            try {
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00008");
                }
                if (ici != null) {
                    ret = ici.invokeChain(this, cmd);
                } else if (ic != null) {
                    ret = ic.invokeNext(this.createInvocationContext(cmd));
                }
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00012");
                }
            }
            catch (InterceptorException e) {
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00009", e);
                }
                throw new IOCException("SLSBCommandBean invokeCommand InterceptorException", e);
            }
            catch (TargetCheckedException e) {
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00010", e);
                }
                cmd.setException(e.getCause());
                return cmd;
            }
            catch (TargetUncheckedException e) {
                if (this.getLogger() != null) {
                    this.getLogger().write("IOC__00011", e.getCause());
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new IOCException("SLSBCommandBean invokeCommand TargetUncheckedException", e.getCause());
            }
            catch (Throwable e) {
                throw new IOCException("SLSBCommandBean invokeCommand Unrecognize Exception", e);
            }
        }
        cmd.setOutObject(ret);
        return cmd;
    }

    protected InvocationContext createInvocationContext(Object input) {
        return new DefaultMethodInvocationContext(this, CALLBACK_METHOD, new Object[]{input});
    }

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    static {
        try {
            CALLBACK_METHOD = SLSBCommandBean.class.getMethod("invokeBeanFlow", Command.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

