/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.service.codemaster.CodeMasterUpdateKey;

public class PartUpdateRecords
implements Serializable {
    private static final long serialVersionUID = -4013884085932487925L;
    protected List keys;
    protected Map records = new LinkedHashMap();
    protected boolean containsAdd;
    protected boolean containsUpdate;
    protected boolean containsRemove;
    protected boolean isFilledRecord = true;

    public void addRecord(CodeMasterUpdateKey key) {
        this.addRecord(key, null);
    }

    public void addRecord(CodeMasterUpdateKey key, Object record) {
        switch (key.getUpdateType()) {
            case 1: {
                this.containsAdd = true;
                if (record != null) break;
                this.isFilledRecord = false;
                break;
            }
            case 2: {
                this.containsUpdate = true;
                if (record != null) break;
                this.isFilledRecord = false;
                break;
            }
            case 3: {
                this.containsRemove = true;
                break;
            }
        }
        this.records.put(key, record);
        if (this.keys != null && !this.keys.contains(key)) {
            this.keys.add(key);
        }
    }

    public Map getRecords() {
        return this.records;
    }

    public Object removeRecord(CodeMasterUpdateKey key) {
        Object record = this.records.remove(key);
        if (this.keys != null) {
            this.keys.remove(key);
        }
        return record;
    }

    public Iterator getKeys() {
        return new KeyIterator();
    }

    public CodeMasterUpdateKey[] getKeyArray() {
        return this.records.keySet().toArray(new CodeMasterUpdateKey[this.records.size()]);
    }

    public Object getRecord(CodeMasterUpdateKey key) {
        return this.records.get(key);
    }

    public CodeMasterUpdateKey getKey(CodeMasterUpdateKey key) {
        int index;
        if (this.keys == null) {
            this.keys = new ArrayList();
            this.keys.addAll(this.records.keySet());
        }
        return (index = this.keys.indexOf(key)) == -1 ? null : (CodeMasterUpdateKey)this.keys.get(index);
    }

    public boolean containsAdd() {
        return this.containsAdd;
    }

    public boolean containsUpdate() {
        return this.containsUpdate;
    }

    public boolean containsRemove() {
        return this.containsRemove;
    }

    public boolean isFilledRecord() {
        return this.size() != 0 && this.isFilledRecord;
    }

    public int size() {
        return this.records.size();
    }

    public void clear() {
        this.records.clear();
        if (this.keys != null) {
            this.keys.clear();
        }
    }

    private class KeyIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = -4013884085802487925L;
        private Iterator itr;
        private CodeMasterUpdateKey current;

        private KeyIterator() {
            this.itr = PartUpdateRecords.this.records.keySet().iterator();
        }

        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            this.current = (CodeMasterUpdateKey)this.itr.next();
            return this.current;
        }

        public void remove() {
            this.itr.remove();
            if (PartUpdateRecords.this.keys != null && this.current != null) {
                PartUpdateRecords.this.keys.remove(this.current);
            }
        }
    }
}

