/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editorfinder;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.journal.editorfinder.ObjectMappedEditorFinderServiceMBean;
import jp.ossc.nimbus.util.ClassMappingTree;

public class ObjectMappedEditorFinderService
extends ServiceBase
implements EditorFinder,
ObjectMappedEditorFinderServiceMBean,
Serializable {
    private static final long serialVersionUID = 1524875427185813794L;
    private static final String CLASS_NAME_BYTE = "byte";
    private static final String CLASS_NAME_BYTE_ARRAY = "byte[]";
    private static final String CLASS_NAME_CHAR = "char";
    private static final String CLASS_NAME_CHAR_ARRAY = "char[]";
    private static final String CLASS_NAME_SHORT = "short";
    private static final String CLASS_NAME_SHORT_ARRAY = "short[]";
    private static final String CLASS_NAME_INT = "int";
    private static final String CLASS_NAME_INT_ARRAY = "int[]";
    private static final String CLASS_NAME_LONG = "long";
    private static final String CLASS_NAME_LONG_ARRAY = "long[]";
    private static final String CLASS_NAME_FLOAT = "float";
    private static final String CLASS_NAME_FLOAT_ARRAY = "float[]";
    private static final String CLASS_NAME_DOUBLE = "double";
    private static final String CLASS_NAME_DOUBLE_ARRAY = "double[]";
    private EditorFinder mParentFinder = null;
    private ServiceName mFinderServiceName = null;
    private Map mEditorMap;
    private ClassMappingTree mEditorRepository = new ClassMappingTree();
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;

    /*
     * WARNING - void declaration
     */
    public void startService() throws Exception {
        if (this.mFinderServiceName != null) {
            this.mParentFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.mFinderServiceName);
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        Iterator iterator = this.mEditorMap.keySet().iterator();
        while (iterator.hasNext()) {
            void var7_7;
            Class<?> cls;
            String classAndKey = (String)iterator.next();
            String key = null;
            String clsName = null;
            int index = classAndKey.indexOf(44);
            if (index == -1) {
                clsName = classAndKey;
            } else {
                clsName = classAndKey.substring(0, index);
                if (index != classAndKey.length() - 1) {
                    key = classAndKey.substring(index + 1);
                }
            }
            if (clsName.equals(CLASS_NAME_BYTE)) {
                cls = Byte.TYPE;
            } else if (clsName.equals(CLASS_NAME_BYTE_ARRAY)) {
                cls = array$B == null ? ObjectMappedEditorFinderService.class$("[B") : array$B;
            } else if (clsName.equals(CLASS_NAME_CHAR)) {
                cls = Character.TYPE;
            } else if (clsName.equals(CLASS_NAME_CHAR_ARRAY)) {
                cls = array$C == null ? ObjectMappedEditorFinderService.class$("[C") : array$C;
            } else if (clsName.equals(CLASS_NAME_SHORT)) {
                cls = Short.TYPE;
            } else if (clsName.equals(CLASS_NAME_SHORT_ARRAY)) {
                cls = array$S == null ? ObjectMappedEditorFinderService.class$("[S") : array$S;
            } else if (clsName.equals(CLASS_NAME_INT)) {
                cls = Integer.TYPE;
            } else if (clsName.equals(CLASS_NAME_INT_ARRAY)) {
                cls = array$I == null ? ObjectMappedEditorFinderService.class$("[I") : array$I;
            } else if (clsName.equals(CLASS_NAME_LONG)) {
                cls = Long.TYPE;
            } else if (clsName.equals(CLASS_NAME_LONG_ARRAY)) {
                cls = array$J == null ? ObjectMappedEditorFinderService.class$("[J") : array$J;
            } else if (clsName.equals(CLASS_NAME_FLOAT)) {
                cls = Float.TYPE;
            } else if (clsName.equals(CLASS_NAME_FLOAT_ARRAY)) {
                cls = array$F == null ? ObjectMappedEditorFinderService.class$("[F") : array$F;
            } else if (clsName.equals(CLASS_NAME_DOUBLE)) {
                cls = Double.TYPE;
            } else if (clsName.equals(CLASS_NAME_DOUBLE_ARRAY)) {
                cls = array$D == null ? ObjectMappedEditorFinderService.class$("[D") : array$D;
            } else {
                try {
                    cls = Class.forName(clsName, true, NimbusClassLoader.getInstance());
                }
                catch (ClassNotFoundException e) {
                    throw new ServiceException("EditorFinderErr001", "ClassNotFoundException class name is " + clsName, e);
                }
            }
            JournalEditor journalEditor = null;
            Object value = this.mEditorMap.get(classAndKey);
            if (value instanceof String) {
                String serviceName = (String)value;
                editor.setAsText(serviceName);
                ServiceName name = (ServiceName)editor.getValue();
                journalEditor = (JournalEditor)ServiceManagerFactory.getServiceObject(name);
            } else if (value instanceof JournalEditor) {
                journalEditor = (JournalEditor)value;
            }
            HashMap<String, JournalEditor> keyEditorMap = (HashMap<String, JournalEditor>)this.mEditorRepository.getValueOf((Class)var7_7);
            if (keyEditorMap == null) {
                keyEditorMap = new HashMap<String, JournalEditor>();
                this.mEditorRepository.add((Class)var7_7, keyEditorMap);
            }
            keyEditorMap.put(key, journalEditor);
        }
    }

    public void stopService() throws Exception {
        this.mEditorRepository.clear();
    }

    public void destroyService() throws Exception {
        this.mParentFinder = null;
        this.mFinderServiceName = null;
        this.mParentFinder = null;
        this.mEditorRepository = null;
    }

    public JournalEditor findEditor(Class paramClass) {
        return this.findEditor(null, paramClass);
    }

    public JournalEditor findEditor(Object paramObj) {
        return this.findEditor(null, paramObj);
    }

    public JournalEditor findEditor(Object key, Class paramClass) {
        Map keyEditorMap = (Map)this.mEditorRepository.getValue(paramClass);
        if (keyEditorMap == null || this.mParentFinder != null) {
            return this.mParentFinder.findEditor(key, paramClass);
        }
        JournalEditor ret = (JournalEditor)keyEditorMap.get(key);
        if (ret == null && key != null) {
            ret = (JournalEditor)keyEditorMap.get(null);
        }
        if (ret == null && this.mParentFinder != null) {
            ret = this.mParentFinder.findEditor(key, paramClass);
        }
        return ret;
    }

    public JournalEditor findEditor(Object key, Object paramObj) {
        Class<?> cls = paramObj != null ? paramObj.getClass() : null;
        return this.findEditor(key, cls);
    }

    public void setEditorProperties(Properties prop) {
        this.mEditorMap = prop;
    }

    public void setParentEditorfinderServiceName(ServiceName name) {
        this.mFinderServiceName = name;
    }

    public void setEditorFinder(EditorFinder parentFinder) {
        this.mParentFinder = parentFinder;
    }

    public void setEditorMap(Map prop) {
        this.mEditorMap = prop;
    }
}

