/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy.invoker;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.proxy.RemoteServerInvoker;
import jp.ossc.nimbus.service.proxy.RemoteServiceCallException;
import jp.ossc.nimbus.service.proxy.invoker.RemoteClientMethodCallInvokerServiceMBean;

public class RemoteClientMethodCallInvokerService
extends ServiceBase
implements Invoker,
Serializable,
RemoteClientMethodCallInvokerServiceMBean {
    private static final long serialVersionUID = -4617039048036524665L;
    private ServiceName jndiFinderServiceName;
    private JndiFinder jndiFinder;
    private String jndiName;
    private ServiceName remoteServiceName;

    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    public void setRemoteServerJndiName(String name) {
        this.jndiName = name;
    }

    public String getRemoteServerJndiName() {
        return this.jndiName;
    }

    public void setRemoteServiceName(ServiceName name) {
        this.remoteServiceName = name;
    }

    public ServiceName getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }

    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
        if (this.jndiFinder == null) {
            throw new IllegalArgumentException("JndiFinderServiceName or JndiFinder must be specified.");
        }
    }

    public Object invoke(InvocationContext context) throws Throwable {
        MethodInvocationContext methodContext = (MethodInvocationContext)context;
        try {
            String name;
            Object target;
            ServiceName serviceName = this.remoteServiceName;
            if (serviceName == null && (target = methodContext.getTargetObject()) != null && target instanceof ServiceName) {
                serviceName = (ServiceName)target;
            }
            if ((name = this.jndiName) == null && serviceName != null) {
                name = serviceName.getServiceManagerName() + '/' + serviceName.getServiceName();
            }
            if (name == null) {
                throw new IllegalArgumentException("RemoteServerJndiName and RemoteServiceName is null.");
            }
            RemoteServerInvoker serverInvoker = (RemoteServerInvoker)this.jndiFinder.lookup(name);
            if (serviceName != null) {
                methodContext.setTargetObject(serviceName);
            }
            return serverInvoker.invoke(context);
        }
        catch (NamingException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (RemoteException e) {
            throw new RemoteServiceCallException(e);
        }
    }
}

