/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer.mail;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.keepalive.KeepAliveCheckerSelector;
import jp.ossc.nimbus.service.keepalive.smtp.SmtpKeepAliveChecker;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.MessageWriter;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.service.writer.WritableRecord;
import jp.ossc.nimbus.service.writer.mail.MailWriterServiceMBean;
import jp.ossc.nimbus.util.CsvArrayList;

public class MailWriterService
extends ServiceBase
implements MessageWriter,
MailWriterServiceMBean {
    private static final long serialVersionUID = 8479884337523286206L;
    private static final String SESSION_PROPERTY_NAME_HOST = "mail.smtp.host";
    private static final String SESSION_PROPERTY_NAME_PORT = "mail.smtp.port";
    private static final String SESSION_PROPERTY_NAME_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    private static final String SESSION_PROPERTY_VALUE_TRANSPORT_PROTOCOL = "smtp";
    private static final String SESSION_PROPERTY_NAME_FROM = "mail.smtp.from";
    private Properties sessionProperties;
    private ServiceName authenticatorServiceName;
    private Authenticator authenticator;
    private Properties headers;
    private String[] headerKeys;
    private String envelopeFromAddressKey;
    private String envelopeFromAddress;
    private boolean isEnvelopeFromAddressValidate;
    private String fromAddressKey;
    private String fromAddress;
    private String fromPersonalKey;
    private String fromPersonal;
    private String fromPersonalEncodingKey;
    private String fromPersonalEncoding;
    private boolean isFromAddressValidate;
    private String senderAddressKey;
    private String senderAddress;
    private String senderPersonalKey;
    private String senderPersonal;
    private String senderPersonalEncodingKey;
    private String senderPersonalEncoding;
    private boolean isSenderAddressValidate;
    private String toAddressKey;
    private String[] toAddress;
    private String toPersonalKey;
    private String[] toPersonals;
    private String toPersonalEncodingKey;
    private String[] toPersonalEncodings;
    private String toPersonalEncoding;
    private boolean isToAddressValidate;
    private String ccAddressKey;
    private String[] ccAddress;
    private String ccPersonalKey;
    private String[] ccPersonals;
    private String ccPersonalEncodingKey;
    private String[] ccPersonalEncodings;
    private String ccPersonalEncoding;
    private boolean isCcAddressValidate;
    private String bccAddressKey;
    private String[] bccAddress;
    private String bccPersonalKey;
    private String[] bccPersonals;
    private String bccPersonalEncodingKey;
    private String[] bccPersonalEncodings;
    private String bccPersonalEncoding;
    private boolean isBccAddressValidate;
    private String replyToAddressKey;
    private String[] replyToAddress;
    private String replyToPersonalKey;
    private String[] replyToPersonals;
    private String replyToPersonalEncodingKey;
    private String[] replyToPersonalEncodings;
    private String replyToPersonalEncoding;
    private boolean isReplyToAddressValidate;
    private String subjectKey;
    private String subject;
    private String subjectEncodingKey;
    private String subjectEncoding;
    private String contentIDKey;
    private String contentID;
    private String contentLanguageKey;
    private String[] contentLanguage;
    private String contentMD5Key;
    private String contentMD5;
    private String descriptionKey;
    private String description;
    private String descriptionEncodingKey;
    private String descriptionEncoding;
    private String dispositionKey;
    private String disposition;
    private String bodyText;
    private String bodyIndexKey;
    private int bodyIndex = -1;
    private String bodyEncoding;
    private String smtpHostName;
    private int smtpPort = 25;
    private ServiceName smtpKeepAliveCheckerSelectorServiceName;
    private KeepAliveCheckerSelector smtpKeepAliveCheckerSelector;
    private int retryCount = -1;
    private long retryInterval = -1L;
    private ServiceName jndiFinderServiceName;
    private JndiFinder jndiFinder;
    private String mailSessionJndiName = "java:/Mail";

    public void setSessionProperties(Properties prop) {
        this.sessionProperties = prop;
    }

    public Properties getSessionProperties() {
        return this.sessionProperties;
    }

    public void setAuthenticatorServiceName(ServiceName name) {
        this.authenticatorServiceName = name;
    }

    public ServiceName getAuthenticatorServiceName() {
        return this.authenticatorServiceName;
    }

    public void setHeaders(Properties prop) {
        this.headers = prop;
    }

    public Properties getHeaders() {
        return this.headers;
    }

    public void setHeaderKeys(String[] keys) {
        this.headerKeys = keys;
    }

    public String[] getHeaderKeys() {
        return this.headerKeys;
    }

    public void setEnvelopeFromAddressKey(String key) {
        this.envelopeFromAddressKey = key;
    }

    public String getEnvelopeFromAddressKey() {
        return this.envelopeFromAddressKey;
    }

    public void setEnvelopeFromAddress(String address) {
        this.envelopeFromAddress = address;
    }

    public String getEnvelopeFromAddress() {
        return this.envelopeFromAddress;
    }

    public void setEnvelopeFromAddressValidate(boolean isValidate) {
        this.isEnvelopeFromAddressValidate = isValidate;
    }

    public boolean isEnvelopeFromAddressValidate() {
        return this.isEnvelopeFromAddressValidate;
    }

    public void setFromAddressKey(String key) {
        this.fromAddressKey = key;
    }

    public String getFromAddressKey() {
        return this.fromAddressKey;
    }

    public void setFromAddress(String address) {
        this.fromAddress = address;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromPersonalKey(String key) {
        this.fromPersonalKey = key;
    }

    public String getFromPersonalKey() {
        return this.fromPersonalKey;
    }

    public void setFromPersonal(String personal) {
        this.fromPersonal = personal;
    }

    public String getFromPersonal() {
        return this.fromPersonal;
    }

    public void setFromPersonalEncodingKey(String key) {
        this.fromPersonalEncodingKey = key;
    }

    public String getFromPersonalEncodingKey() {
        return this.fromPersonalEncodingKey;
    }

    public void setFromPersonalEncoding(String encoding) {
        this.fromPersonalEncoding = encoding;
    }

    public String getFromPersonalEncoding() {
        return this.fromPersonalEncoding;
    }

    public void setFromAddressValidate(boolean isValidate) {
        this.isFromAddressValidate = isValidate;
    }

    public boolean isFromAddressValidate() {
        return this.isFromAddressValidate;
    }

    public void setSenderAddressKey(String key) {
        this.senderAddressKey = key;
    }

    public String getSenderAddressKey() {
        return this.senderAddressKey;
    }

    public void setSenderAddress(String address) {
        this.senderAddress = address;
    }

    public String getSenderAddress() {
        return this.senderAddress;
    }

    public void setSenderPersonalKey(String key) {
        this.senderPersonalKey = key;
    }

    public String getSenderPersonalKey() {
        return this.senderPersonalKey;
    }

    public void setSenderPersonal(String personal) {
        this.senderPersonal = personal;
    }

    public String getSenderPersonal() {
        return this.senderPersonal;
    }

    public void setSenderPersonalEncodingKey(String key) {
        this.senderPersonalEncodingKey = key;
    }

    public String getSenderPersonalEncodingKey() {
        return this.senderPersonalEncodingKey;
    }

    public void setSenderPersonalEncoding(String encoding) {
        this.senderPersonalEncoding = encoding;
    }

    public String getSenderPersonalEncoding() {
        return this.senderPersonalEncoding;
    }

    public void setSenderAddressValidate(boolean isValidate) {
        this.isSenderAddressValidate = isValidate;
    }

    public boolean isSenderAddressValidate() {
        return this.isSenderAddressValidate;
    }

    public void setToAddressKey(String key) {
        this.toAddressKey = key;
    }

    public String getToAddressKey() {
        return this.toAddressKey;
    }

    public void setToAddress(String[] address) {
        this.toAddress = address;
    }

    public String[] getToAddress() {
        return this.toAddress;
    }

    public void setToPersonalKey(String key) {
        this.toPersonalKey = key;
    }

    public String getToPersonalKey() {
        return this.toPersonalKey;
    }

    public void setToPersonals(String[] personal) {
        this.toPersonals = personal;
    }

    public String[] getToPersonals() {
        return this.toPersonals;
    }

    public void setToPersonalEncodingKey(String key) {
        this.toPersonalEncodingKey = key;
    }

    public String getToPersonalEncodingKey() {
        return this.toPersonalEncodingKey;
    }

    public void setToPersonalEncodings(String[] encoding) {
        this.toPersonalEncodings = encoding;
    }

    public String[] getToPersonalEncodings() {
        return this.toPersonalEncodings;
    }

    public void setToPersonalEncoding(String encoding) {
        this.toPersonalEncoding = encoding;
    }

    public String getToPersonalEncoding() {
        return this.toPersonalEncoding;
    }

    public void setToAddressValidate(boolean isValidate) {
        this.isToAddressValidate = isValidate;
    }

    public boolean isToAddressValidate() {
        return this.isToAddressValidate;
    }

    public void setCcAddressKey(String key) {
        this.ccAddressKey = key;
    }

    public String getCcAddressKey() {
        return this.ccAddressKey;
    }

    public void setCcAddress(String[] address) {
        this.ccAddress = address;
    }

    public String[] getCcAddress() {
        return this.ccAddress;
    }

    public void setCcPersonalKey(String key) {
        this.ccPersonalKey = key;
    }

    public String getCcPersonalKey() {
        return this.ccPersonalKey;
    }

    public void setCcPersonals(String[] personal) {
        this.ccPersonals = personal;
    }

    public String[] getCcPersonals() {
        return this.ccPersonals;
    }

    public void setCcPersonalEncodingKey(String key) {
        this.ccPersonalEncodingKey = key;
    }

    public String getCcPersonalEncodingKey() {
        return this.ccPersonalEncodingKey;
    }

    public void setCcPersonalEncodings(String[] encoding) {
        this.ccPersonalEncodings = encoding;
    }

    public String[] getCcPersonalEncodings() {
        return this.ccPersonalEncodings;
    }

    public void setCcPersonalEncoding(String encoding) {
        this.ccPersonalEncoding = encoding;
    }

    public String getCcPersonalEncoding() {
        return this.ccPersonalEncoding;
    }

    public void setCcAddressValidate(boolean isValidate) {
        this.isCcAddressValidate = isValidate;
    }

    public boolean isCcAddressValidate() {
        return this.isCcAddressValidate;
    }

    public void setBccAddressKey(String key) {
        this.bccAddressKey = key;
    }

    public String getBccAddressKey() {
        return this.bccAddressKey;
    }

    public void setBccAddress(String[] address) {
        this.bccAddress = address;
    }

    public String[] getBccAddress() {
        return this.bccAddress;
    }

    public void setBccPersonalKey(String key) {
        this.bccPersonalKey = key;
    }

    public String getBccPersonalKey() {
        return this.bccPersonalKey;
    }

    public void setBccPersonals(String[] personal) {
        this.bccPersonals = personal;
    }

    public String[] getBccPersonals() {
        return this.bccPersonals;
    }

    public void setBccPersonalEncodingKey(String key) {
        this.bccPersonalEncodingKey = key;
    }

    public String getBccPersonalEncodingKey() {
        return this.bccPersonalEncodingKey;
    }

    public void setBccPersonalEncodings(String[] encoding) {
        this.bccPersonalEncodings = encoding;
    }

    public String[] getBccPersonalEncodings() {
        return this.bccPersonalEncodings;
    }

    public void setBccPersonalEncoding(String encoding) {
        this.bccPersonalEncoding = encoding;
    }

    public String getBccPersonalEncoding() {
        return this.bccPersonalEncoding;
    }

    public void setBccAddressValidate(boolean isValidate) {
        this.isBccAddressValidate = isValidate;
    }

    public boolean isBccAddressValidate() {
        return this.isBccAddressValidate;
    }

    public void setReplyToAddressKey(String key) {
        this.replyToAddressKey = key;
    }

    public String getReplyToAddressKey() {
        return this.replyToAddressKey;
    }

    public void setReplyToAddress(String[] address) {
        this.replyToAddress = address;
    }

    public String[] getReplyToAddress() {
        return this.replyToAddress;
    }

    public void setReplyToPersonalKey(String key) {
        this.replyToPersonalKey = key;
    }

    public String getReplyToPersonalKey() {
        return this.replyToPersonalKey;
    }

    public void setReplyToPersonals(String[] personal) {
        this.replyToPersonals = personal;
    }

    public String[] getReplyToPersonals() {
        return this.replyToPersonals;
    }

    public void setReplyToPersonalEncodingKey(String key) {
        this.replyToPersonalEncodingKey = key;
    }

    public String getReplyToPersonalEncodingKey() {
        return this.replyToPersonalEncodingKey;
    }

    public void setReplyToPersonalEncodings(String[] encoding) {
        this.replyToPersonalEncodings = encoding;
    }

    public String[] getReplyToPersonalEncodings() {
        return this.replyToPersonalEncodings;
    }

    public void setReplyToPersonalEncoding(String encoding) {
        this.replyToPersonalEncoding = encoding;
    }

    public String getReplyToPersonalEncoding() {
        return this.replyToPersonalEncoding;
    }

    public void setReplyToAddressValidate(boolean isValidate) {
        this.isReplyToAddressValidate = isValidate;
    }

    public boolean isReplyToAddressValidate() {
        return this.isReplyToAddressValidate;
    }

    public void setSubjectKey(String key) {
        this.subjectKey = key;
    }

    public String getSubjectKey() {
        return this.subjectKey;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubjectEncodingKey(String key) {
        this.subjectEncodingKey = key;
    }

    public String getSubjectEncodingKey() {
        return this.subjectEncodingKey;
    }

    public void setSubjectEncoding(String encoding) {
        this.subjectEncoding = encoding;
    }

    public String getSubjectEncoding() {
        return this.subjectEncoding;
    }

    public void setContentIDKey(String key) {
        this.contentIDKey = key;
    }

    public String getContentIDKey() {
        return this.contentIDKey;
    }

    public void setContentID(String id) {
        this.contentID = id;
    }

    public String getContentID() {
        return this.contentID;
    }

    public void setContentLanguageKey(String key) {
        this.contentLanguageKey = key;
    }

    public String getContentLanguageKey() {
        return this.contentLanguageKey;
    }

    public void setContentLanguage(String[] lang) {
        this.contentLanguage = lang;
    }

    public String[] getContentLanguage() {
        return this.contentLanguage;
    }

    public void setContentMD5Key(String key) {
        this.contentMD5Key = key;
    }

    public String getContentMD5Key() {
        return this.contentMD5Key;
    }

    public void setContentMD5(String val) {
        this.contentMD5 = val;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public void setDescriptionKey(String key) {
        this.descriptionKey = key;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public void setDescription(String val) {
        this.description = val;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescriptionEncodingKey(String key) {
        this.descriptionEncodingKey = key;
    }

    public String getDescriptionEncodingKey() {
        return this.descriptionEncodingKey;
    }

    public void setDescriptionEncoding(String encoding) {
        this.descriptionEncoding = encoding;
    }

    public String getDescriptionEncoding() {
        return this.descriptionEncoding;
    }

    public void setDispositionKey(String key) {
        this.dispositionKey = key;
    }

    public String getDispositionKey() {
        return this.dispositionKey;
    }

    public void setDisposition(String val) {
        this.disposition = val;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setBodyIndex(int index) {
        this.bodyIndex = index;
    }

    public int getBodyIndex() {
        return this.bodyIndex;
    }

    public void setBodyIndexKey(String key) {
        this.bodyIndexKey = key;
    }

    public String getBodyIndexKey() {
        return this.bodyIndexKey;
    }

    public void setBodyText(String text) {
        this.bodyText = text;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public void setBodyEncoding(String encoding) {
        this.bodyEncoding = encoding;
    }

    public String getBodyEncoding() {
        return this.bodyEncoding;
    }

    public void setSmtpHostName(String name) {
        this.smtpHostName = name;
    }

    public String getSmtpHostName() {
        return this.smtpHostName;
    }

    public void setSmtpPort(int port) {
        this.smtpPort = port;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setRetryCount(int count) {
        this.retryCount = count;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryInterval(long millis) {
        this.retryInterval = millis;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setSmtpKeepAliveCheckerSelectorServiceName(ServiceName name) {
        this.smtpKeepAliveCheckerSelectorServiceName = name;
    }

    public ServiceName getSmtpKeepAliveCheckerSelectorServiceName() {
        return this.smtpKeepAliveCheckerSelectorServiceName;
    }

    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    public void setMailSessionJndiName(String name) {
        this.mailSessionJndiName = name;
    }

    public String getMailSessionJndiName() {
        return this.mailSessionJndiName;
    }

    public void startService() throws Exception {
        if (this.authenticatorServiceName != null) {
            this.authenticator = (Authenticator)ServiceManagerFactory.getServiceObject(this.authenticatorServiceName);
        }
        if (this.fromAddressKey == null && this.fromAddress == null) {
            throw new IllegalArgumentException("It is necessary to set any of FromAddressKey and FromAddress.");
        }
        if (this.toAddressKey == null && (this.toAddress == null || this.toAddress.length == 0)) {
            throw new IllegalArgumentException("It is necessary to set any of ToAddressKey and ToAddress.");
        }
        if (this.toAddress != null && this.toAddress.length != 0) {
            if (this.toPersonals != null && this.toPersonals.length != this.toAddress.length) {
                throw new IllegalArgumentException("It is necessary to set toAddress and toPersonals to the same length.");
            }
            if (this.toPersonalEncodings != null && this.toPersonalEncodings.length != this.toAddress.length) {
                throw new IllegalArgumentException("It is necessary to set toAddress and toPersonalEncodings to the same length.");
            }
        }
        if (this.ccAddress != null && this.ccAddress.length != 0) {
            if (this.ccPersonals != null && this.ccPersonals.length != this.ccAddress.length) {
                throw new IllegalArgumentException("It is necessary to set ccAddress and ccPersonals to the same length.");
            }
            if (this.ccPersonalEncodings != null && this.ccPersonalEncodings.length != this.ccAddress.length) {
                throw new IllegalArgumentException("It is necessary to set ccAddress and ccPersonalEncodings to the same length.");
            }
        }
        if (this.bccAddress != null && this.bccAddress.length != 0) {
            if (this.bccPersonals != null && this.bccPersonals.length != this.bccAddress.length) {
                throw new IllegalArgumentException("It is necessary to set bccAddress and bccPersonals to the same length.");
            }
            if (this.bccPersonalEncodings != null && this.bccPersonalEncodings.length != this.bccAddress.length) {
                throw new IllegalArgumentException("It is necessary to set bccAddress and bccPersonalEncodings to the same length.");
            }
        }
        if (this.smtpKeepAliveCheckerSelectorServiceName != null) {
            this.smtpKeepAliveCheckerSelector = (KeepAliveCheckerSelector)ServiceManagerFactory.getServiceObject(this.smtpKeepAliveCheckerSelectorServiceName);
        }
        if (this.smtpHostName == null && this.smtpKeepAliveCheckerSelector == null) {
            throw new IllegalArgumentException("It is necessary to set any of SmtpHostName and SmtpKeepAliveCheckerSelectorServiceName.");
        }
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
    }

    public void write(WritableRecord rec) throws MessageWriteException {
        int maxCount = this.retryCount > 0 ? this.retryCount : 0;
        Throwable exception = null;
        for (int count = 0; count <= maxCount; ++count) {
            try {
                this.sendMail(rec);
                return;
            }
            catch (NamingException e) {
                exception = e;
            }
            catch (IllegalWriteException e) {
                exception = e;
            }
            catch (MessagingException e) {
                exception = e;
            }
            if (this.retryInterval <= 0L) continue;
            try {
                Thread.sleep(this.retryInterval);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        throw new MessageWriteException(exception);
    }

    public void sendMail(WritableRecord rec) throws MessageWriteException, IllegalWriteException, MessagingException, NamingException {
        String enc;
        int i;
        String[] vals;
        List elements;
        Map elementMap = rec.getElementMap();
        InternetAddress fromInternetAddress = this.createAddress(elementMap, this.fromAddress, this.fromPersonal, this.fromPersonalEncoding, this.fromAddressKey, this.fromPersonalKey, this.fromPersonalEncodingKey, this.isFromAddressValidate);
        if (fromInternetAddress == null) {
            throw new MessageWriteException("The From address is null.");
        }
        InternetAddress senderInternetAddress = this.createAddress(elementMap, this.senderAddress, this.senderPersonal, this.senderPersonalEncoding, this.senderAddressKey, this.senderPersonalKey, this.senderPersonalEncodingKey, this.isSenderAddressValidate);
        InternetAddress[] toInternetAddress = this.createAddressArray(elementMap, this.toAddress, this.toPersonals, this.toPersonalEncodings, this.toPersonalEncoding, this.toAddressKey, this.toPersonalKey, this.toPersonalEncodingKey, this.isToAddressValidate);
        if (toInternetAddress == null || toInternetAddress.length == 0) {
            throw new MessageWriteException("The To address is null.");
        }
        InternetAddress[] ccInternetAddress = this.createAddressArray(elementMap, this.ccAddress, this.ccPersonals, this.ccPersonalEncodings, this.ccPersonalEncoding, this.ccAddressKey, this.ccPersonalKey, this.ccPersonalEncodingKey, this.isCcAddressValidate);
        InternetAddress[] bccInternetAddress = this.createAddressArray(elementMap, this.bccAddress, this.bccPersonals, this.bccPersonalEncodings, this.bccPersonalEncoding, this.bccAddressKey, this.bccPersonalKey, this.bccPersonalEncodingKey, this.isBccAddressValidate);
        InternetAddress[] replyToInternetAddress = this.createAddressArray(elementMap, this.replyToAddress, this.replyToPersonals, this.replyToPersonalEncodings, this.replyToPersonalEncoding, this.replyToAddressKey, this.replyToPersonalKey, this.replyToPersonalEncodingKey, this.isReplyToAddressValidate);
        String body = this.bodyText;
        int bIndex = this.getIntValue(elementMap, this.bodyIndex, this.bodyIndexKey);
        if (bIndex > 0 && (elements = rec.getElements()).size() > bIndex) {
            StringBuffer buf = new StringBuffer();
            int imax = elements.size();
            for (int i2 = bIndex; i2 < imax; ++i2) {
                WritableElement element = (WritableElement)elements.get(i2);
                if (element == null) continue;
                buf.append(element);
            }
            body = buf.toString();
        }
        Session session = null;
        if (this.jndiFinder != null) {
            session = (Session)this.jndiFinder.lookup(this.mailSessionJndiName);
        } else {
            Properties props = System.getProperties();
            if (this.smtpKeepAliveCheckerSelector != null) {
                SmtpKeepAliveChecker checker = (SmtpKeepAliveChecker)this.smtpKeepAliveCheckerSelector.selectChecker();
                if (checker == null) {
                    throw new MessageWriteException("All smtp server is dead.");
                }
                props.setProperty(SESSION_PROPERTY_NAME_HOST, checker.getHostIp());
                props.setProperty(SESSION_PROPERTY_NAME_PORT, String.valueOf(checker.getHostPort()));
            } else {
                props.setProperty(SESSION_PROPERTY_NAME_HOST, this.smtpHostName);
                props.setProperty(SESSION_PROPERTY_NAME_PORT, String.valueOf(this.smtpPort));
            }
            props.setProperty(SESSION_PROPERTY_NAME_TRANSPORT_PROTOCOL, SESSION_PROPERTY_VALUE_TRANSPORT_PROTOCOL);
            InternetAddress envelopeFromInternetAddress = this.createAddress(elementMap, this.envelopeFromAddress, null, null, this.envelopeFromAddressKey, null, null, this.isEnvelopeFromAddressValidate);
            if (envelopeFromInternetAddress != null) {
                props.setProperty(SESSION_PROPERTY_NAME_FROM, envelopeFromInternetAddress.getAddress());
            }
            if (this.sessionProperties != null) {
                props.putAll((Map<?, ?>)this.sessionProperties);
            }
            session = Session.getInstance((Properties)props, (Authenticator)this.authenticator);
        }
        MimeMessage message = new MimeMessage(session);
        String val = this.getStringValue(elementMap, this.contentID, this.contentIDKey);
        if (val != null) {
            message.setContentID(val);
        }
        if ((vals = this.getStringArrayValue(elementMap, this.contentLanguage, this.contentLanguageKey)) != null) {
            message.setContentLanguage(vals);
        }
        if ((val = this.getStringValue(elementMap, this.contentMD5, this.contentMD5Key)) != null) {
            message.setContentMD5(val);
        }
        if ((val = this.getStringValue(elementMap, this.description, this.descriptionKey)) != null) {
            String enc2 = this.getStringValue(elementMap, this.descriptionEncoding, this.descriptionEncodingKey);
            if (enc2 == null) {
                message.setDescription(val);
            } else {
                message.setDescription(val, enc2);
            }
        }
        if ((val = this.getStringValue(elementMap, this.disposition, this.dispositionKey)) != null) {
            message.setDisposition(val);
        }
        message.setFrom((Address)fromInternetAddress);
        if (senderInternetAddress != null) {
            message.setSender((Address)senderInternetAddress);
        }
        for (i = 0; i < toInternetAddress.length; ++i) {
            message.addRecipient(Message.RecipientType.TO, (Address)toInternetAddress[i]);
        }
        if (ccInternetAddress != null) {
            for (i = 0; i < ccInternetAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.CC, (Address)ccInternetAddress[i]);
            }
        }
        if (bccInternetAddress != null) {
            for (i = 0; i < bccInternetAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.BCC, (Address)bccInternetAddress[i]);
            }
        }
        if (replyToInternetAddress != null) {
            message.setReplyTo((Address[])replyToInternetAddress);
        }
        if ((enc = this.getStringValue(elementMap, this.subjectEncoding, this.subjectEncodingKey)) != null) {
            message.setSubject(this.getStringValue(elementMap, this.subject, this.subjectKey), enc);
        } else {
            message.setSubject(this.getStringValue(elementMap, this.subject, this.subjectKey));
        }
        if (this.bodyEncoding == null) {
            message.setText(body);
        } else {
            message.setText(body, this.bodyEncoding);
        }
        if (this.headers != null) {
            Iterator<Object> names = this.headers.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                message.setHeader(name, this.headers.getProperty(name));
            }
        }
        if (this.headerKeys != null) {
            for (int i3 = 0; i3 < this.headerKeys.length; ++i3) {
                String header = this.getStringValue(elementMap, null, this.headerKeys[i3]);
                if (header == null) continue;
                message.setHeader(this.headerKeys[i3], header);
            }
        }
        message.setSentDate(new Date());
        message.saveChanges();
        Transport.send((Message)message);
    }

    private String[] toStringArray(Object obj) {
        if (obj == null) {
            return null;
        }
        String[] result = null;
        if (obj instanceof String[]) {
            result = (String[])obj;
        } else if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            if (col.size() != 0) {
                result = new String[col.size()];
                int index = 0;
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    result[index++] = itr.next().toString();
                }
            }
        } else {
            CsvArrayList list = new CsvArrayList();
            list.split(obj.toString());
            result = list.toStringAry();
        }
        return result;
    }

    private InternetAddress[] createAddressArray(Map elementMap, String[] defaultAddress, String[] defaultPersonals, String[] defaultPersonalEncodings, String defaultPersonalEncoding, String addressKey, String personalKey, String personalEncodingKey, boolean isAddressValidate) throws MessageWriteException {
        String[] address = this.getStringArrayValue(elementMap, defaultAddress, addressKey);
        if (address == null || address.length == 0) {
            return null;
        }
        String[] personals = null;
        String[] personalEncodings = null;
        if (address == defaultAddress) {
            personals = defaultPersonals;
            personalEncodings = defaultPersonalEncodings;
        } else {
            personals = this.getStringArrayValue(elementMap, null, personalKey);
            if (personals != null && personals.length != address.length) {
                throw new IllegalArgumentException("It is necessary to set address and personals to the same length.");
            }
            personalEncodings = this.getStringArrayValue(elementMap, null, personalEncodingKey);
            if (personalEncodings != null && personalEncodings.length != address.length) {
                throw new IllegalArgumentException("It is necessary to set address and personalEncodings to the same length.");
            }
        }
        InternetAddress[] internetAddress = new InternetAddress[address.length];
        for (int i = 0; i < address.length; ++i) {
            internetAddress[i] = this.createAddress(address[i], personals == null ? null : personals[i], personalEncodings == null ? defaultPersonalEncoding : personalEncodings[i], isAddressValidate);
        }
        return internetAddress;
    }

    private InternetAddress createAddress(Map elementMap, String defaultAddress, String defaultPersonal, String defaultPersonalEncoding, String addressKey, String personalKey, String personalEncodingKey, boolean isAddressValidate) throws MessageWriteException {
        String address = this.getStringValue(elementMap, defaultAddress, addressKey);
        if (address == null) {
            return null;
        }
        String personal = this.getStringValue(elementMap, defaultPersonal, personalKey);
        String personalEncoding = this.getStringValue(elementMap, defaultPersonalEncoding, personalEncodingKey);
        return this.createAddress(address, personal, personalEncoding, isAddressValidate);
    }

    private InternetAddress createAddress(String address, String personal, String personalEncoding, boolean isAddressValidate) throws MessageWriteException {
        InternetAddress internetAddress = null;
        try {
            internetAddress = personal != null && personalEncoding != null ? new InternetAddress(address, personal, personalEncoding) : (personal != null ? new InternetAddress(address, personal) : new InternetAddress(address));
            if (isAddressValidate) {
                internetAddress.validate();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageWriteException(e);
        }
        catch (AddressException e) {
            throw new MessageWriteException(e);
        }
        return internetAddress;
    }

    private String[] getStringArrayValue(Map elementMap, String[] defaultVal, String key) {
        String[] tmpVal;
        String[] val = defaultVal;
        if (key != null && (tmpVal = this.toStringArray(elementMap.get(key))) != null && tmpVal.length != 0) {
            val = tmpVal;
        }
        return val;
    }

    private String getStringValue(Map elementMap, String defaultVal, String key) {
        Object val = this.getValue(elementMap, defaultVal, key);
        return val == null ? null : val.toString();
    }

    private int getIntValue(Map elementMap, int defaultVal, String key) {
        Integer val = (Integer)this.getValue(elementMap, null, key);
        return val == null ? defaultVal : val;
    }

    private Object getValue(Map elementMap, Object defaultVal, String key) {
        Object tmpVal;
        WritableElement tmpElement;
        Object val = defaultVal;
        if (key != null && (tmpElement = (WritableElement)elementMap.get(key)) != null && (tmpVal = tmpElement.toObject()) != null) {
            val = tmpVal;
        }
        return val;
    }
}

