/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.sql;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.util.sql.ResultSetWrapper;

public class StatementWrapper
implements Statement,
Serializable {
    private static final long serialVersionUID = -3678006522511003450L;
    protected Connection connection;
    protected Statement statement;
    protected Class resultSetWrapperClass;
    protected Map resultSetProperties;

    public StatementWrapper(Statement st) {
        this(null, st);
    }

    public StatementWrapper(Connection con, Statement st) {
        this.connection = con;
        this.statement = st;
    }

    public void setStatement(Statement st) {
        this.statement = st;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setResultSetWrapperClass(Class clazz) throws IllegalArgumentException {
        if (clazz != null && !ResultSetWrapper.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Illegal class : " + clazz.getName());
        }
        this.resultSetWrapperClass = clazz;
    }

    public Class getResultSetWrapperClass() {
        return this.resultSetWrapperClass;
    }

    public void setResultSetProperty(String name, Object value) {
        if (this.resultSetProperties == null) {
            this.resultSetProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.resultSetProperties.put(prop, value);
    }

    public Object getResultSetProperty(String name) {
        if (this.resultSetProperties == null) {
            return null;
        }
        Iterator props = this.resultSetProperties.keySet().iterator();
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            if (!prop.getPropertyName().equals(name)) continue;
            return this.resultSetProperties.get(prop);
        }
        return null;
    }

    protected ResultSet createResultSetWrapper(ResultSet rs) throws SQLException {
        if (this.resultSetWrapperClass == null) {
            return rs;
        }
        ResultSetWrapper result = null;
        try {
            Constructor constructor = this.resultSetWrapperClass.getConstructor(ResultSet.class);
            result = (ResultSetWrapper)constructor.newInstance(rs);
            this.applyResultSetProperties(result);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return result;
    }

    protected void applyResultSetProperties(ResultSetWrapper rsw) throws Exception {
        if (this.resultSetProperties == null || this.resultSetProperties.size() == 0) {
            return;
        }
        Iterator props = this.resultSetProperties.keySet().iterator();
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            prop.setProperty(rsw, this.resultSetProperties.get(prop));
        }
    }

    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    public void close() throws SQLException {
        this.statement.close();
    }

    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    public void setFetchDirection(int arg0) throws SQLException {
        this.statement.setFetchDirection(arg0);
    }

    public void setFetchSize(int arg0) throws SQLException {
        this.statement.setFetchSize(arg0);
    }

    public void setMaxFieldSize(int arg0) throws SQLException {
        this.statement.setMaxFieldSize(arg0);
    }

    public void setMaxRows(int arg0) throws SQLException {
        this.statement.setMaxRows(arg0);
    }

    public void setQueryTimeout(int arg0) throws SQLException {
        this.statement.setQueryTimeout(arg0);
    }

    public boolean getMoreResults(int arg0) throws SQLException {
        return this.statement.getMoreResults(arg0);
    }

    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.statement.setEscapeProcessing(arg0);
    }

    public int executeUpdate(String arg0) throws SQLException {
        return this.statement.executeUpdate(arg0);
    }

    public void addBatch(String arg0) throws SQLException {
        this.statement.addBatch(arg0);
    }

    public void setCursorName(String arg0) throws SQLException {
        this.statement.setCursorName(arg0);
    }

    public boolean execute(String arg0) throws SQLException {
        return this.statement.execute(arg0);
    }

    public int executeUpdate(String arg0, int arg1) throws SQLException {
        return this.statement.executeUpdate(arg0, arg1);
    }

    public boolean execute(String arg0, int arg1) throws SQLException {
        return this.statement.execute(arg0, arg1);
    }

    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return this.statement.executeUpdate(arg0, arg1);
    }

    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return this.statement.execute(arg0, arg1);
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            return this.statement.getConnection();
        }
        return this.connection;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.createResultSetWrapper(this.statement.getGeneratedKeys());
    }

    public ResultSet getResultSet() throws SQLException {
        return this.createResultSetWrapper(this.statement.getResultSet());
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return this.statement.executeUpdate(arg0, arg1);
    }

    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return this.statement.execute(arg0, arg1);
    }

    public ResultSet executeQuery(String arg0) throws SQLException {
        return this.createResultSetWrapper(this.statement.executeQuery(arg0));
    }
}

