/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NoSuchReadablePropertyException;
import jp.ossc.nimbus.beans.NoSuchWritablePropertyException;
import jp.ossc.nimbus.beans.Property;

public class SimpleProperty
implements Property,
Serializable {
    private static final long serialVersionUID = 5346194284290420718L;
    private static final String MSG_00001 = "Length of property literal must be more than 1.";
    protected static final Object[] NULL_ARGS = new Object[0];
    protected static final Class[] NULL_METHOD_PARAMS = new Class[0];
    protected static final String GET_METHOD_PREFIX = "get";
    protected static final String SET_METHOD_PREFIX = "set";
    protected static final String MAP_GET_METHOD_NAME = "get";
    protected static final Class[] MAP_GET_METHOD_ARGS = new Class[]{Object.class};
    protected static final String MAP_SET_METHOD_NAME = "put";
    protected static final Class[] MAP_SET_METHOD_ARGS = new Class[]{Object.class, Object.class};
    protected static final String ARRAY_LENGTH_METHOD_NAME = "length";
    protected String property;
    protected transient Map getMethodCache = new HashMap();
    protected transient Map setMethodCache = new HashMap();

    public SimpleProperty() {
    }

    public SimpleProperty(String prop) throws IllegalArgumentException {
        this.setPropertyName(prop);
    }

    public void parse(String prop) throws IllegalArgumentException {
        this.setPropertyName(prop);
    }

    public String getPropertyName() {
        return this.property;
    }

    protected void setPropertyName(String prop) throws IllegalArgumentException {
        if (prop == null || prop.length() == 0) {
            throw new IllegalArgumentException(MSG_00001);
        }
        this.property = prop;
    }

    public Class getPropertyType(Object obj) throws NoSuchPropertyException {
        return this.getPropertyType(obj.getClass());
    }

    public Class getPropertyType(Class clazz) throws NoSuchPropertyException {
        if (this.property == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        try {
            Method readMethod = this.getReadMethod(clazz);
            return readMethod.getReturnType();
        }
        catch (InvocationTargetException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (NoSuchPropertyException e) {
            try {
                Method writeMethod = this.getWriteMethod(clazz);
                return writeMethod.getParameterTypes()[0];
            }
            catch (InvocationTargetException e2) {
                throw e;
            }
            catch (NoSuchPropertyException e2) {
                throw e2;
            }
        }
    }

    private String createGetterName() {
        StringBuffer result = new StringBuffer(this.property);
        int len = result.length();
        if (len != 0 && !Character.isUpperCase(result.charAt(0))) {
            char capital = Character.toUpperCase(result.charAt(0));
            result.deleteCharAt(0).insert(0, capital);
        }
        return result.insert(0, "get").toString();
    }

    private String createSetterName() {
        StringBuffer result = new StringBuffer(this.property);
        int len = result.length();
        if (len != 0 && !Character.isUpperCase(result.charAt(0))) {
            char capital = Character.toUpperCase(result.charAt(0));
            result.deleteCharAt(0).insert(0, capital);
        }
        return result.insert(0, SET_METHOD_PREFIX).toString();
    }

    public boolean isReadable(Object obj) {
        return this.isReadable(obj.getClass());
    }

    public boolean isReadable(Class clazz) {
        if (this.property == null) {
            return false;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        try {
            this.getReadMethod(clazz);
            return true;
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    public boolean isWritable(Object obj, Class clazz) {
        return this.isWritable(obj.getClass());
    }

    public boolean isWritable(Object obj, Object value) {
        return this.isWritable(obj.getClass());
    }

    public boolean isWritable(Class clazz) {
        if (this.property == null) {
            return false;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        try {
            this.getWriteMethod(clazz);
            return true;
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(obj.getClass(), this.property);
        }
        try {
            Class<?> clazz = obj.getClass();
            if (clazz.isArray() && ARRAY_LENGTH_METHOD_NAME.equals(this.property)) {
                return new Integer(Array.getLength(obj));
            }
            Method readMethod = this.getReadMethod(clazz);
            try {
                if (readMethod.getParameterTypes().length == 0) {
                    return readMethod.invoke(obj, NULL_ARGS);
                }
                return readMethod.invoke(obj, this.property);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
        }
        catch (NoSuchPropertyException e) {
            if (obj instanceof Map) {
                return ((Map)obj).get(this.property);
            }
            throw e;
        }
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(obj.getClass(), this.property);
        }
        Class<?> clazz = obj.getClass();
        Method writeMethod = null;
        writeMethod = value == null ? this.getWriteMethod(clazz) : this.getWriteMethod(clazz, value.getClass());
        try {
            if (writeMethod.getParameterTypes().length == 1) {
                writeMethod.invoke(obj, value);
            } else {
                writeMethod.invoke(obj, this.property, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
    }

    public Method getReadMethod(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        return this.getReadMethod(obj.getClass());
    }

    public Method getReadMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.getMethodCache.get(clazz);
        } else {
            PropertyDescriptor descriptor = null;
            try {
                descriptor = this.getPropertyDescriptor(clazz);
                readMethod = descriptor.getReadMethod();
                if (readMethod != null && readMethod.getParameterTypes().length != 0) {
                    readMethod = null;
                }
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
            if (readMethod == null) {
                try {
                    readMethod = clazz.getMethod(this.createGetterName(), NULL_METHOD_PARAMS);
                    if (Void.TYPE.equals(readMethod.getReturnType())) {
                        readMethod = null;
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (readMethod == null) {
                block20: {
                    try {
                        readMethod = clazz.getMethod(this.property, NULL_METHOD_PARAMS);
                    }
                    catch (NoSuchMethodException e) {
                        if (this.property == null || this.property.length() == 0 || !Character.isUpperCase(this.property.charAt(0))) break block20;
                        StringBuffer methodName = new StringBuffer(this.property);
                        char capital = Character.toLowerCase(methodName.charAt(0));
                        methodName.deleteCharAt(0).insert(0, capital);
                        try {
                            readMethod = clazz.getMethod(methodName.toString(), NULL_METHOD_PARAMS);
                        }
                        catch (NoSuchMethodException e2) {
                            // empty catch block
                        }
                    }
                }
                if (readMethod != null && Void.TYPE.equals(readMethod.getReturnType())) {
                    readMethod = null;
                }
            }
            if (readMethod == null && Map.class.isAssignableFrom(clazz)) {
                try {
                    return Map.class.getMethod("get", MAP_GET_METHOD_ARGS);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (readMethod == null) {
                throw new NoSuchReadablePropertyException(clazz, this.property);
            }
            this.getMethodCache.put(clazz, readMethod);
        }
        return readMethod;
    }

    public Method getWriteMethod(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        return this.getWriteMethod(obj.getClass());
    }

    public Method getWriteMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
        return this.getWriteMethod(clazz, null);
    }

    public Method getWriteMethod(Class clazz, Class valClazz) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchWritablePropertyException(clazz, this.property);
        }
        if (this.setMethodCache.containsKey(clazz)) {
            Object methodObj = this.setMethodCache.get(clazz);
            if (methodObj instanceof Method) {
                return (Method)methodObj;
            }
            if (valClazz == null) {
                throw new NoSuchWritablePropertyException(clazz, this.property, "The method cannot be specified, because the method of the overload exists.");
            }
            Map overloadMap = (Map)methodObj;
            if (overloadMap.containsKey(valClazz)) {
                return (Method)overloadMap.get(valClazz);
            }
        }
        if (!SimpleProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                try {
                    return this.getWriteMethod(interfaces[i], valClazz);
                }
                catch (NoSuchPropertyException e) {
                    continue;
                }
            }
            throw new NoSuchWritablePropertyException(clazz, this.property);
        }
        Method writeMethod = null;
        String setterName = this.createSetterName();
        Class primitiveClazz = this.toPrimitive(valClazz);
        String lowerCaseProperty = null;
        if (this.property != null && this.property.length() != 0 && Character.isUpperCase(this.property.charAt(0))) {
            StringBuffer methodName = new StringBuffer(this.property);
            char capital = Character.toLowerCase(methodName.charAt(0));
            methodName.deleteCharAt(0).insert(0, capital);
            lowerCaseProperty = methodName.toString();
        }
        Method[] methods = clazz.getMethods();
        HashMap overloadMap = new HashMap();
        boolean isMatch = false;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != 1 || !setterName.equals(methods[i].getName()) && !this.property.equals(methods[i].getName()) && !methods[i].getName().equals(lowerCaseProperty) || overloadMap.containsKey(paramTypes[0]) && setterName.equals(((Method)overloadMap.get(paramTypes[0])).getName())) continue;
            overloadMap.put(paramTypes[0], methods[i]);
            if (isMatch) continue;
            if (writeMethod == null) {
                if (valClazz == null) {
                    writeMethod = methods[i];
                    continue;
                }
                if (!this.isAssignableFrom(paramTypes[0], valClazz) && !paramTypes[0].equals(primitiveClazz)) continue;
                writeMethod = methods[i];
                if (!valClazz.equals(paramTypes[0]) && !paramTypes[0].equals(primitiveClazz)) continue;
                isMatch = true;
                continue;
            }
            if (valClazz == null || !this.isAssignableFrom(paramTypes[0], valClazz) && !paramTypes[0].equals(primitiveClazz)) continue;
            if (valClazz.equals(paramTypes[0]) || paramTypes[0].equals(primitiveClazz)) {
                writeMethod = methods[i];
                isMatch = true;
                continue;
            }
            if (!this.isAssignableFrom(writeMethod.getParameterTypes()[0], paramTypes[0])) continue;
            writeMethod = methods[i];
        }
        if (writeMethod != null) {
            if (overloadMap.size() > 1) {
                if (valClazz == null) {
                    throw new NoSuchWritablePropertyException(clazz, this.property, "The method cannot be specified, because the method of the overload exists.");
                }
                this.setMethodCache.put(clazz, overloadMap);
            } else {
                this.setMethodCache.put(clazz, writeMethod);
            }
            return writeMethod;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            try {
                writeMethod = Map.class.getMethod(MAP_SET_METHOD_NAME, MAP_SET_METHOD_ARGS);
                this.setMethodCache.put(clazz, writeMethod);
                return writeMethod;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        throw new NoSuchWritablePropertyException(clazz, this.property);
    }

    protected boolean isAssignableFrom(Class thisClass, Class thatClass) {
        if (this.isNumber(thisClass) && this.isNumber(thatClass)) {
            if (Byte.TYPE.equals(thisClass) || Byte.class.equals(thisClass)) {
                return Byte.TYPE.equals(thatClass) || Byte.class.equals(thatClass);
            }
            if (Short.TYPE.equals(thisClass) || Short.class.equals(thisClass)) {
                return Short.TYPE.equals(thatClass) || Short.class.equals(thatClass) || Byte.TYPE.equals(thisClass) || Byte.class.equals(thisClass);
            }
            if (Integer.TYPE.equals(thisClass) || Integer.class.equals(thisClass)) {
                return Integer.TYPE.equals(thatClass) || Integer.class.equals(thatClass) || Short.TYPE.equals(thisClass) || Short.class.equals(thisClass) || Byte.TYPE.equals(thisClass) || Byte.class.equals(thisClass);
            }
            if (Long.TYPE.equals(thisClass) || Long.class.equals(thisClass)) {
                return Long.TYPE.equals(thisClass) || Long.class.equals(thisClass) || !Float.TYPE.equals(thatClass) && !Float.class.equals(thatClass) && !Double.TYPE.equals(thisClass) && !Double.class.equals(thisClass);
            }
            if (Float.TYPE.equals(thisClass) || Float.class.equals(thisClass)) {
                return Float.TYPE.equals(thisClass) || Float.class.equals(thisClass) || !Double.TYPE.equals(thisClass) && !Double.class.equals(thisClass);
            }
            if (Double.TYPE.equals(thisClass) || Double.class.equals(thisClass)) {
                return Double.TYPE.equals(thisClass) || Double.class.equals(thisClass);
            }
            return true;
        }
        return thisClass.isAssignableFrom(thatClass);
    }

    protected boolean isNumber(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return Byte.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Character.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz);
        }
        return Number.class.isAssignableFrom(clazz);
    }

    protected Class toPrimitive(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (Boolean.class.equals(clazz)) {
            return Boolean.TYPE;
        }
        if (Byte.class.equals(clazz)) {
            return Byte.TYPE;
        }
        if (Short.class.equals(clazz)) {
            return Short.TYPE;
        }
        if (Character.class.equals(clazz)) {
            return Character.TYPE;
        }
        if (Integer.class.equals(clazz)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(clazz)) {
            return Long.TYPE;
        }
        if (Float.class.equals(clazz)) {
            return Float.TYPE;
        }
        if (Double.class.equals(clazz)) {
            return Double.TYPE;
        }
        return null;
    }

    public static SimpleProperty[] getProperties(Object bean) {
        return SimpleProperty.getProperties(bean.getClass());
    }

    public static SimpleProperty[] getProperties(Class clazz) {
        Set props = new HashSet();
        if (SimpleProperty.isAccessableClass(clazz)) {
            props = SimpleProperty.getProperties(clazz, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
                props = SimpleProperty.getProperties(interfaces[i], props);
                break;
            }
        }
        return props.toArray(new SimpleProperty[props.size()]);
    }

    public static Set getPropertyNames(Object bean) {
        return SimpleProperty.getPropertyNames(bean.getClass());
    }

    public static Set getPropertyNames(Class clazz) {
        Set props = new HashSet();
        if (SimpleProperty.isAccessableClass(clazz)) {
            props = SimpleProperty.getPropertyNames(clazz, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
                props = SimpleProperty.getPropertyNames(interfaces[i], props);
                break;
            }
        }
        return props;
    }

    private static Set getPropertyNames(Class clazz, Set props) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return props;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            return props;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            props.add(descriptors[i].getName());
        }
        return props;
    }

    private static Set getProperties(Class clazz, Set props) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return props;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            return props;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            props.add(new SimpleProperty(descriptors[i].getName()));
        }
        return props;
    }

    protected PropertyDescriptor getPropertyDescriptor(Object obj) throws NoSuchPropertyException {
        return this.getPropertyDescriptor(obj.getClass());
    }

    protected static boolean isAccessableClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isPublic(modifier) || (Modifier.isProtected(modifier) || !Modifier.isPublic(modifier) && !Modifier.isProtected(modifier) && !Modifier.isPrivate(modifier)) && SimpleProperty.class.getPackage().equals(clazz.getPackage());
    }

    protected PropertyDescriptor getPropertyDescriptor(Class clazz) throws NoSuchPropertyException {
        if (!SimpleProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
                try {
                    return this.getPropertyDescriptor(interfaces[i]);
                }
                catch (NoSuchPropertyException e) {
                    // empty catch block
                }
            }
            throw new NoSuchPropertyException(clazz, this.property);
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        String prop = this.property;
        int len = prop.length();
        if (len != 0 && Character.isUpperCase(prop.charAt(0))) {
            prop = len > 1 ? Character.toLowerCase(prop.charAt(0)) + prop.substring(1) : prop.toLowerCase();
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (!prop.equals(descriptors[i].getName()) && !this.property.equals(descriptors[i].getName())) continue;
            return descriptors[i];
        }
        throw new NoSuchPropertyException(clazz, this.property);
    }

    public String toString() {
        return "SimpleProperty{" + this.property + "}";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = new HashMap();
        this.setMethodCache = new HashMap();
    }
}

