/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.httpclient;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.http.HttpClient;
import jp.ossc.nimbus.service.http.HttpClientFactory;
import jp.ossc.nimbus.service.http.HttpException;
import jp.ossc.nimbus.service.http.HttpRequest;
import jp.ossc.nimbus.service.http.HttpRequestCreateException;
import jp.ossc.nimbus.service.http.HttpResponse;
import jp.ossc.nimbus.service.http.httpclient.HttpClientCreateTimeoutException;
import jp.ossc.nimbus.service.http.httpclient.HttpClientFactoryServiceMBean;
import jp.ossc.nimbus.service.http.httpclient.HttpRequestImpl;
import jp.ossc.nimbus.service.http.httpclient.HttpResponseImpl;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.semaphore.Semaphore;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.util.converter.StreamConverter;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public class HttpClientFactoryService
extends ServiceBase
implements HttpClientFactory,
HttpClientFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = 4729444860053132964L;
    protected int connectionTimeout = -1;
    protected int linger = -1;
    protected int receiveBufferSize = -1;
    protected int sendBufferSize = -1;
    protected int soTimeout = -1;
    protected Map actionRequestMap = new HashMap();
    protected Map actionResponseMap = new HashMap();
    protected Map credentialsMap = new HashMap();
    protected Map requestHeaders = new HashMap();
    protected ServiceName requestStreamConverterServiceName;
    protected StreamConverter requestStreamConverter;
    protected ServiceName responseStreamConverterServiceName;
    protected StreamConverter responseStreamConverter;
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected String requestContentType;
    protected String requestCharacterEncoding;
    protected int requestDeflateLength = -1;
    protected ServiceName semaphoreServiceName;
    protected Semaphore semaphore;

    public void setConnectionTimeout(int millis) {
        this.connectionTimeout = millis;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setLinger(int millis) {
        this.linger = millis;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSoTimeout(int millis) {
        this.soTimeout = millis;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    public void setRequestContentType(String type) {
        this.requestContentType = type;
    }

    public String getRequestCharacterEncoding() {
        return this.requestCharacterEncoding;
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.requestCharacterEncoding = encoding;
    }

    public void setRequestHeaders(String name, String[] values) {
        this.requestHeaders.put(name, values);
    }

    public String[] getRequestHeaders(String name) {
        return (String[])this.requestHeaders.get(name);
    }

    public void setRequestDeflateLength(int length) {
        this.requestDeflateLength = length;
    }

    public int getRequestDeflateLength() {
        return this.requestDeflateLength;
    }

    public void setRequestStreamConverterServiceName(ServiceName name) {
        this.requestStreamConverterServiceName = name;
    }

    public ServiceName getRequestStreamConverterServiceName() {
        return this.requestStreamConverterServiceName;
    }

    public void setResponseStreamConverterServiceName(ServiceName name) {
        this.responseStreamConverterServiceName = name;
    }

    public ServiceName getResponseStreamConverterServiceName() {
        return this.responseStreamConverterServiceName;
    }

    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setSemaphoreServiceName(ServiceName name) {
        this.semaphoreServiceName = name;
    }

    public ServiceName getSemaphoreServiceName() {
        return this.semaphoreServiceName;
    }

    public void setRequestStreamConverter(StreamConverter converter) {
        this.requestStreamConverter = converter;
    }

    public StreamConverter getRequestStreamConverter() {
        return this.requestStreamConverter;
    }

    public void setResponseStreamConverter(StreamConverter converter) {
        this.responseStreamConverter = converter;
    }

    public StreamConverter getResponseStreamConverter() {
        return this.responseStreamConverter;
    }

    public void setRequest(String action, HttpRequestImpl request) {
        if (this.actionRequestMap == null) {
            this.actionRequestMap = new HashMap();
        }
        request.setActionName(action);
        this.actionRequestMap.put(action, request);
    }

    public void setResponse(String action, HttpResponseImpl response) {
        if (this.actionResponseMap == null) {
            this.actionResponseMap = new HashMap();
        }
        this.actionResponseMap.put(action, response);
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.credentialsMap.put(authscope, credentials);
    }

    public void startService() throws Exception {
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.semaphoreServiceName != null) {
            this.semaphore = (Semaphore)ServiceManagerFactory.getServiceObject(this.semaphoreServiceName);
            this.semaphore.accept();
        }
    }

    public void stopService() throws Exception {
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }

    public HttpRequest createRequest(String action) throws HttpRequestCreateException {
        HttpRequestImpl request = (HttpRequestImpl)this.actionRequestMap.get(action);
        if (request == null) {
            throw new HttpRequestCreateException("No action.");
        }
        try {
            request = (HttpRequestImpl)request.clone();
            if (request.getContentType() == null && this.requestContentType != null) {
                request.setContentType(this.requestContentType);
            }
            if (request.getCharacterEncoding() == null && this.requestCharacterEncoding != null) {
                request.setCharacterEncoding(this.requestCharacterEncoding);
            }
            if (request.getStreamConverter() == null && request.getStreamConverterServiceName() == null) {
                if (this.requestStreamConverter != null) {
                    request.setStreamConverter(this.requestStreamConverter);
                } else if (this.requestStreamConverterServiceName != null) {
                    request.setStreamConverterServiceName(this.requestStreamConverterServiceName);
                }
            }
            if (this.requestHeaders.size() != 0) {
                Set headerNameSet = request.getHeaderNameSet();
                Iterator names = this.requestHeaders.keySet().iterator();
                while (names.hasNext()) {
                    String headerName = (String)names.next();
                    if (headerNameSet.contains(headerName)) continue;
                    request.setHeaders(headerName, (String[])this.requestHeaders.get(headerName));
                }
            }
            if (request.getDeflateLength() <= 0 && this.requestDeflateLength != -1) {
                request.setDeflateLength(this.requestDeflateLength);
            }
            return request;
        }
        catch (CloneNotSupportedException e) {
            throw new HttpRequestCreateException(e);
        }
    }

    public HttpClient createHttpClient() throws HttpException {
        if (this.semaphore == null || this.semaphore.getResource()) {
            return new HttpClientImpl();
        }
        throw new HttpClientCreateTimeoutException();
    }

    protected class HttpClientImpl
    implements HttpClient {
        protected org.apache.commons.httpclient.HttpClient client = new org.apache.commons.httpclient.HttpClient();

        public HttpClientImpl() {
            HttpConnectionManagerParams params = this.client.getHttpConnectionManager().getParams();
            if (HttpClientFactoryService.this.connectionTimeout != -1) {
                params.setConnectionTimeout(HttpClientFactoryService.this.connectionTimeout);
            }
            if (HttpClientFactoryService.this.linger != -1) {
                params.setLinger(HttpClientFactoryService.this.linger);
            }
            if (HttpClientFactoryService.this.receiveBufferSize != -1) {
                params.setReceiveBufferSize(HttpClientFactoryService.this.receiveBufferSize);
            }
            if (HttpClientFactoryService.this.sendBufferSize != -1) {
                params.setSendBufferSize(HttpClientFactoryService.this.sendBufferSize);
            }
            if (HttpClientFactoryService.this.soTimeout != -1) {
                params.setSoTimeout(HttpClientFactoryService.this.soTimeout);
            }
            Iterator entries = HttpClientFactoryService.this.credentialsMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                this.client.getState().setCredentials((AuthScope)entry.getKey(), (Credentials)entry.getValue());
            }
        }

        public void addCookie(javax.servlet.http.Cookie cookie) {
            if (this.client == null) {
                return;
            }
            Cookie result = new Cookie(cookie.getDomain(), cookie.getName(), cookie.getValue());
            result.setComment(cookie.getComment());
            if (cookie.getMaxAge() > 0) {
                result.setExpiryDate(new Date(System.currentTimeMillis() + (long)cookie.getMaxAge()));
            }
            result.setPath(cookie.getPath());
            result.setSecure(cookie.getSecure());
            result.setVersion(cookie.getVersion());
            this.client.getState().addCookie(result);
        }

        public javax.servlet.http.Cookie[] getCookies() {
            if (this.client == null) {
                return new javax.servlet.http.Cookie[0];
            }
            Cookie[] cookies = this.client.getState().getCookies();
            if (cookies == null || cookies.length == 0) {
                return new javax.servlet.http.Cookie[0];
            }
            javax.servlet.http.Cookie[] result = new javax.servlet.http.Cookie[cookies.length];
            long now = System.currentTimeMillis();
            for (int i = 0; i < cookies.length; ++i) {
                result[i] = new javax.servlet.http.Cookie(cookies[i].getName(), cookies[i].getValue());
                result[i].setComment(cookies[i].getComment());
                result[i].setDomain(cookies[i].getDomain());
                if (cookies[i].getExpiryDate() == null) {
                    result[i].setMaxAge(-1);
                } else {
                    long expiry = cookies[i].getExpiryDate().getTime();
                    result[i].setMaxAge((int)(expiry - now));
                }
                result[i].setPath(cookies[i].getPath());
                result[i].setSecure(cookies[i].getSecure());
                result[i].setVersion(cookies[i].getVersion());
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public HttpResponse executeRequest(HttpRequest request) throws HttpException {
            HttpResponseImpl httpResponseImpl;
            block38: {
                if (this.client == null) {
                    throw new HttpException("Closed.");
                }
                HttpMethodBase method = null;
                try {
                    try {
                        String body;
                        if (HttpClientFactoryService.this.journal != null) {
                            HttpClientFactoryService.this.journal.startJournal("Access");
                            String requestId = null;
                            if (HttpClientFactoryService.this.sequence != null) {
                                requestId = HttpClientFactoryService.this.sequence.increment();
                            } else if (HttpClientFactoryService.this.threadContext != null) {
                                requestId = (String)HttpClientFactoryService.this.threadContext.get("REQUEST_ID");
                            }
                            if (requestId != null) {
                                HttpClientFactoryService.this.journal.setRequestId(requestId);
                            }
                        }
                        int status = 0;
                        try {
                            if (HttpClientFactoryService.this.journal != null) {
                                HttpClientFactoryService.this.journal.addStartStep("Request");
                            }
                            HttpRequestImpl req = (HttpRequestImpl)request;
                            if (HttpClientFactoryService.this.journal != null) {
                                HttpClientFactoryService.this.journal.addInfo("Action", req.getActionName());
                                HttpClientFactoryService.this.journal.addInfo("URI", req.getURL());
                                HttpClientFactoryService.this.journal.addInfo("Cookies", this.getCookies());
                                if (req.getHeaderMap() != null) {
                                    HttpClientFactoryService.this.journal.addInfo("Headers", req.getHeaderMap());
                                }
                                if (req.getParameterMap() != null) {
                                    HttpClientFactoryService.this.journal.addInfo("Parameters", req.getParameterMap());
                                }
                                if (req.getObject() != null) {
                                    HttpClientFactoryService.this.journal.addInfo("InputObject", req.getObject());
                                }
                            }
                            method = req.createHttpMethod();
                            if (HttpClientFactoryService.this.journal != null && req.getInputBytes() != null) {
                                body = null;
                                body = req.getCharacterEncoding() == null ? new String(req.getInputBytes()) : new String(req.getInputBytes(), req.getCharacterEncoding());
                                HttpClientFactoryService.this.journal.addInfo("Body", body);
                            }
                            status = this.client.executeMethod((HttpMethod)method);
                            Object var7_12 = null;
                            if (HttpClientFactoryService.this.journal != null) {
                                HttpClientFactoryService.this.journal.addEndStep();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            if (HttpClientFactoryService.this.journal == null) throw throwable;
                            HttpClientFactoryService.this.journal.addEndStep();
                            throw throwable;
                        }
                        try {
                            HttpResponseImpl response;
                            if (HttpClientFactoryService.this.journal != null) {
                                HttpClientFactoryService.this.journal.addStartStep("Response");
                                HttpClientFactoryService.this.journal.addInfo("Status", new Integer(status));
                            }
                            if ((response = (response = (HttpResponseImpl)HttpClientFactoryService.this.actionResponseMap.get(request.getActionName())) == null ? new HttpResponseImpl() : (HttpResponseImpl)response.clone()).getStreamConverter() == null && response.getStreamConverterServiceName() == null) {
                                if (HttpClientFactoryService.this.responseStreamConverter != null) {
                                    response.setStreamConverter(HttpClientFactoryService.this.responseStreamConverter);
                                } else if (HttpClientFactoryService.this.responseStreamConverterServiceName != null) {
                                    response.setStreamConverterServiceName(HttpClientFactoryService.this.responseStreamConverterServiceName);
                                }
                            }
                            response.setStatusCode(status);
                            response.setHttpMethod(method);
                            if (HttpClientFactoryService.this.journal != null) {
                                if (response.getHeaderMap() != null) {
                                    HttpClientFactoryService.this.journal.addInfo("Headers", response.getHeaderMap());
                                }
                                if (response.getOutputBytes() != null) {
                                    body = null;
                                    String encoding = response.getCharacterEncoding();
                                    body = encoding == null ? new String(response.getOutputBytes()) : new String(response.getOutputBytes(), encoding);
                                    HttpClientFactoryService.this.journal.addInfo("Body", body);
                                }
                                try {
                                    if (response.getObject() != null) {
                                        HttpClientFactoryService.this.journal.addInfo("OutputObject", response.getObject());
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            httpResponseImpl = response;
                            Object var9_16 = null;
                            if (HttpClientFactoryService.this.journal != null) {
                                HttpClientFactoryService.this.journal.addEndStep();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_17 = null;
                            if (HttpClientFactoryService.this.journal == null) throw throwable;
                            HttpClientFactoryService.this.journal.addEndStep();
                            throw throwable;
                        }
                        Object var11_18 = null;
                        if (method == null) break block38;
                    }
                    catch (CloneNotSupportedException e) {
                        if (HttpClientFactoryService.this.journal == null) throw new HttpException(e);
                        HttpClientFactoryService.this.journal.addInfo("Exception", e);
                        throw new HttpException(e);
                    }
                    catch (IOException e) {
                        if (HttpClientFactoryService.this.journal == null) throw new HttpException(e);
                        HttpClientFactoryService.this.journal.addInfo("Exception", e);
                        throw new HttpException(e);
                    }
                    catch (RuntimeException e) {
                        if (HttpClientFactoryService.this.journal == null) throw e;
                        HttpClientFactoryService.this.journal.addInfo("Exception", e);
                        throw e;
                    }
                    catch (Error e) {
                        if (HttpClientFactoryService.this.journal == null) throw e;
                        HttpClientFactoryService.this.journal.addInfo("Exception", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    if (method != null) {
                        method.releaseConnection();
                    }
                    if (HttpClientFactoryService.this.journal == null) throw throwable;
                    HttpClientFactoryService.this.journal.endJournal();
                    throw throwable;
                }
                method.releaseConnection();
            }
            if (HttpClientFactoryService.this.journal == null) return httpResponseImpl;
            HttpClientFactoryService.this.journal.endJournal();
            return httpResponseImpl;
        }

        public void close() throws HttpException {
            if (HttpClientFactoryService.this.semaphore != null) {
                HttpClientFactoryService.this.semaphore.freeResource();
            }
            this.client = null;
        }
    }
}

