/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.http.HttpResponse;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamConverter;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;

public class HttpResponseImpl
implements HttpResponse,
Cloneable {
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HEADER_CHARSET = "charset";
    protected static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    protected static final String CONTENT_ENCODING_DEFLATE = "deflate";
    protected static final String CONTENT_ENCODING_GZIP = "gzip";
    protected static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    protected static final String DEFAULT_RESPONSE_CHARSET = "ISO8859-1";
    protected int statusCode;
    protected HttpMethodBase method;
    protected Map headerMap;
    protected InputStream inputStream;
    protected Object outputObject;
    protected ServiceName streamConverterServiceName;
    protected StreamConverter streamConverter;
    protected byte[] outputBytes;

    public void setHttpMethod(HttpMethodBase method) throws IOException {
        this.method = method;
        this.inputStream = this.decompress(method.getResponseBodyAsStream());
    }

    public void setStreamConverterServiceName(ServiceName name) {
        this.streamConverterServiceName = name;
    }

    public ServiceName getStreamConverterServiceName() {
        return this.streamConverterServiceName;
    }

    public void setStreamConverter(StreamConverter converter) {
        this.streamConverter = converter;
    }

    public StreamConverter getStreamConverter() {
        return this.streamConverter;
    }

    protected InputStream decompress(InputStream is) throws IOException {
        String[] encodes = this.getHeaders(HEADER_CONTENT_ENCODING);
        InputStream in = is;
        if (encodes != null && encodes.length != 0) {
            for (int i = encodes.length - 1; i >= 0; --i) {
                if (encodes[i] == null) continue;
                if (encodes[i].indexOf(CONTENT_ENCODING_DEFLATE) != -1) {
                    in = new InflaterInputStream(in);
                    continue;
                }
                if (encodes[i].indexOf(CONTENT_ENCODING_GZIP) != -1 || encodes[i].indexOf(CONTENT_ENCODING_X_GZIP) != -1) {
                    in = new GZIPInputStream(in);
                    continue;
                }
                throw new IOException("Can not decompress. [" + encodes[i] + "]");
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        int length = 0;
        while ((length = in.read(bytes)) != -1) {
            baos.write(bytes, 0, length);
        }
        this.outputBytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.outputBytes);
        return bais;
    }

    public Set getHeaderNameSet() {
        return this.getHeaderMap().keySet();
    }

    public String getHeader(String name) {
        if (this.headerMap != null) {
            String[] vals = (String[])this.headerMap.get(name);
            return vals == null || vals.length == 0 ? null : vals[0];
        }
        Header header = this.method.getResponseHeader(name);
        return header == null ? null : header.getValue();
    }

    public String[] getHeaders(String name) {
        if (this.headerMap != null) {
            return (String[])this.headerMap.get(name);
        }
        Header[] headers = this.method.getResponseHeaders(name);
        if (headers == null) {
            return null;
        }
        String[] vals = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            vals[i] = headers[i].getValue();
        }
        return vals;
    }

    public Map getHeaderMap() {
        if (this.headerMap == null) {
            this.headerMap = new HashMap();
            Header[] headers = this.method.getResponseHeaders();
            if (headers != null) {
                for (int i = 0; i < headers.length; ++i) {
                    String name = headers[i].getName();
                    String value = headers[i].getValue();
                    String[] vals = (String[])this.headerMap.get(name);
                    if (vals == null) {
                        vals = new String[]{value};
                        this.headerMap.put(name, vals);
                        continue;
                    }
                    String[] newVals = new String[vals.length + 1];
                    System.arraycopy(vals, 0, newVals, 0, vals.length);
                    newVals[newVals.length - 1] = value;
                    this.headerMap.put(name, newVals);
                }
            }
        }
        return this.headerMap;
    }

    public void setHeaderMap(Map map) {
        this.headerMap = map;
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public void setInputStream(InputStream in) {
        this.inputStream = in;
    }

    public Object getObject() throws ConvertException {
        if (this.outputObject == null && (this.streamConverter != null || this.streamConverterServiceName != null)) {
            StreamConverter converter = this.streamConverter;
            if (this.streamConverterServiceName != null) {
                converter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.streamConverterServiceName);
            }
            converter.setCharacterEncodingToObject(this.getCharacterEncoding());
            this.outputObject = converter.convertToObject(this.inputStream);
        }
        return this.outputObject;
    }

    public void setObject(Object object) {
        this.outputObject = object;
    }

    public String getCharacterEncoding() {
        String contentType = this.getHeader(HEADER_CONTENT_TYPE);
        if (contentType == null) {
            return DEFAULT_RESPONSE_CHARSET;
        }
        int index = contentType.indexOf(HEADER_CHARSET);
        if (index == -1) {
            return DEFAULT_RESPONSE_CHARSET;
        }
        return contentType.substring(index + HEADER_CHARSET.length() + 1);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    public byte[] getOutputBytes() {
        return this.outputBytes;
    }

    public Object clone() throws CloneNotSupportedException {
        return (HttpResponseImpl)super.clone();
    }
}

