/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.StringArrayEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.scheduler.BeanFlowCallScheduleTaskService;
import jp.ossc.nimbus.service.scheduler.DatabaseScheduleFactoryServiceMBean;
import jp.ossc.nimbus.service.scheduler.IOCCallScheduleTaskService;
import jp.ossc.nimbus.service.scheduler.Schedule;
import jp.ossc.nimbus.service.scheduler.ScheduleFactory;
import jp.ossc.nimbus.service.scheduler.ScheduleStateManager;
import jp.ossc.nimbus.service.scheduler.ScheduleTask;
import jp.ossc.nimbus.service.scheduler.TimerScheduleService;

public class DatabaseScheduleFactoryService
extends ServiceBase
implements DatabaseScheduleFactoryServiceMBean,
ScheduleFactory {
    private static final long serialVersionUID = 6855784208603292244L;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private String scheduleMasterQuery;
    private int scheduleKeyQueryIndex = -1;
    private int scheduleNameQueryIndex = -1;
    private int scheduleTaskServiceNameQueryIndex = -1;
    private int scheduleBeanFlowInvokerFactoryServiceNameQueryIndex = -1;
    private int scheduleBeanFlowNameQueryIndex = -1;
    private ServiceName scheduleBeanFlowInvokerFactoryServiceName;
    private BeanFlowInvokerFactory scheduleBeanFlowInvokerFactory;
    private int scheduleFacadeCallerServiceNameQueryIndex = -1;
    private int scheduleBeanFlowNamesQueryIndex = -1;
    private ServiceName scheduleFacadeCallerServiceName;
    private FacadeCaller scheduleFacadeCaller;
    private int scheduleIOCCallTypeQueryIndex = -1;
    private String scheduleIOCCallType;
    private int scheduleStartTimeQueryIndex = -1;
    private String scheduleStartTimeFormat;
    private DateFormat scheduleStartTimeDateFormat;
    private int scheduleExecuteWhenOverStartTimeQueryIndex = -1;
    private int scheduleEndTimeQueryIndex = -1;
    private String scheduleEndTimeFormat;
    private DateFormat scheduleEndTimeDateFormat;
    private int scheduleDelayQueryIndex = -1;
    private int schedulePeriodQueryIndex = -1;
    private int scheduleCountQueryIndex = -1;
    private int scheduleFixedRateQueryIndex = -1;
    private int scheduleDependsScheduleNamesQueryIndex = -1;
    private int scheduleDependencyTimeoutQueryIndex = -1;
    private int scheduleDependencyConfirmIntervalQueryIndex = -1;
    private int scheduleErrorLogMessageIdQueryIndex = -1;
    private String scheduleErrorLogMessageId;
    private int scheduleTimeoutLogMessageIdQueryIndex = -1;
    private String scheduleTimeoutLogMessageId;
    private int scheduleJournalServiceNameQueryIndex = -1;
    private ServiceName scheduleJournalServiceName;
    private Journal scheduleJournal;
    private int scheduleQueueServiceNameQueryIndex = -1;
    private ServiceName scheduleQueueServiceName;
    private Queue scheduleQueue;
    private int scheduleGarbageQueueQueryIndex = -1;
    private int scheduleStateManagerServiceNameQueryIndex = -1;
    private ServiceName scheduleStateManagerServiceName;
    private ScheduleStateManager scheduleStateManager;
    private Map scheduleMap;

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setScheduleMasterQuery(String query) {
        this.scheduleMasterQuery = query;
    }

    public String getScheduleMasterQuery() {
        return this.scheduleMasterQuery;
    }

    public void setScheduleKeyQueryIndex(int index) {
        this.scheduleKeyQueryIndex = index;
    }

    public int getScheduleKeyQueryIndex() {
        return this.scheduleKeyQueryIndex;
    }

    public void setScheduleNameQueryIndex(int index) {
        this.scheduleNameQueryIndex = index;
    }

    public int getScheduleNameQueryIndex() {
        return this.scheduleNameQueryIndex;
    }

    public void setScheduleTaskServiceNameQueryIndex(int index) {
        this.scheduleTaskServiceNameQueryIndex = index;
    }

    public int getScheduleTaskServiceNameQueryIndex() {
        return this.scheduleTaskServiceNameQueryIndex;
    }

    public void setScheduleBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.scheduleBeanFlowInvokerFactoryServiceName = name;
    }

    public ServiceName getScheduleBeanFlowInvokerFactoryServiceName() {
        return this.scheduleBeanFlowInvokerFactoryServiceName;
    }

    public void setScheduleBeanFlowInvokerFactoryServiceNameQueryIndex(int index) {
        this.scheduleBeanFlowInvokerFactoryServiceNameQueryIndex = index;
    }

    public int getScheduleBeanFlowInvokerFactoryServiceNameQueryIndex() {
        return this.scheduleBeanFlowInvokerFactoryServiceNameQueryIndex;
    }

    public void setScheduleBeanFlowNameQueryIndex(int index) {
        this.scheduleBeanFlowNameQueryIndex = index;
    }

    public int getScheduleBeanFlowNameQueryIndex() {
        return this.scheduleBeanFlowNameQueryIndex;
    }

    public void setScheduleFacadeCallerServiceNameQueryIndex(int index) {
        this.scheduleFacadeCallerServiceNameQueryIndex = index;
    }

    public int getScheduleFacadeCallerServiceNameQueryIndex() {
        return this.scheduleFacadeCallerServiceNameQueryIndex;
    }

    public void setScheduleBeanFlowNamesQueryIndex(int index) {
        this.scheduleBeanFlowNamesQueryIndex = index;
    }

    public int getScheduleBeanFlowNamesQueryIndex() {
        return this.scheduleBeanFlowNamesQueryIndex;
    }

    public void setScheduleFacadeCallerServiceName(ServiceName name) {
        this.scheduleFacadeCallerServiceName = name;
    }

    public ServiceName getScheduleFacadeCallerServiceName() {
        return this.scheduleFacadeCallerServiceName;
    }

    public void setScheduleIOCCallTypeQueryIndex(int index) {
        this.scheduleIOCCallTypeQueryIndex = index;
    }

    public int getScheduleIOCCallTypeQueryIndex() {
        return this.scheduleIOCCallTypeQueryIndex;
    }

    public void setScheduleIOCCallType(String type) {
        this.scheduleIOCCallType = type;
    }

    public String getScheduleIOCCallType() {
        return this.scheduleIOCCallType;
    }

    public void setScheduleStartTimeQueryIndex(int index) {
        this.scheduleStartTimeQueryIndex = index;
    }

    public int getScheduleStartTimeQueryIndex() {
        return this.scheduleStartTimeQueryIndex;
    }

    public void setScheduleStartTimeFormat(String format) {
        this.scheduleStartTimeFormat = format;
    }

    public String getScheduleStartTimeFormat() {
        return this.scheduleStartTimeFormat;
    }

    public void setScheduleExecuteWhenOverStartTimeQueryIndex(int index) {
        this.scheduleExecuteWhenOverStartTimeQueryIndex = index;
    }

    public int getScheduleExecuteWhenOverStartTimeQueryIndex() {
        return this.scheduleExecuteWhenOverStartTimeQueryIndex;
    }

    public void setScheduleEndTimeQueryIndex(int index) {
        this.scheduleEndTimeQueryIndex = index;
    }

    public int getScheduleEndTimeQueryIndex() {
        return this.scheduleEndTimeQueryIndex;
    }

    public void setScheduleEndTimeFormat(String format) {
        this.scheduleEndTimeFormat = format;
    }

    public String getScheduleEndTimeFormat() {
        return this.scheduleEndTimeFormat;
    }

    public void setScheduleDelayQueryIndex(int index) {
        this.scheduleDelayQueryIndex = index;
    }

    public int getScheduleDelayQueryIndex() {
        return this.scheduleDelayQueryIndex;
    }

    public void setSchedulePeriodQueryIndex(int index) {
        this.schedulePeriodQueryIndex = index;
    }

    public int getSchedulePeriodQueryIndex() {
        return this.schedulePeriodQueryIndex;
    }

    public void setScheduleCountQueryIndex(int index) {
        this.scheduleCountQueryIndex = index;
    }

    public int getScheduleCountQueryIndex() {
        return this.scheduleCountQueryIndex;
    }

    public void setScheduleFixedRateQueryIndex(int index) {
        this.scheduleFixedRateQueryIndex = index;
    }

    public int getScheduleFixedRateQueryIndex() {
        return this.scheduleFixedRateQueryIndex;
    }

    public void setScheduleDependsScheduleNamesQueryIndex(int index) {
        this.scheduleDependsScheduleNamesQueryIndex = index;
    }

    public int getScheduleDependsScheduleNamesQueryIndex() {
        return this.scheduleDependsScheduleNamesQueryIndex;
    }

    public void setScheduleDependencyTimeoutQueryIndex(int index) {
        this.scheduleDependencyTimeoutQueryIndex = index;
    }

    public int getScheduleDependencyTimeoutQueryIndex() {
        return this.scheduleDependencyTimeoutQueryIndex;
    }

    public void setScheduleDependencyConfirmIntervalQueryIndex(int index) {
        this.scheduleDependencyConfirmIntervalQueryIndex = index;
    }

    public int getScheduleDependencyConfirmIntervalQueryIndex() {
        return this.scheduleDependencyConfirmIntervalQueryIndex;
    }

    public void setScheduleErrorLogMessageIdQueryIndex(int index) {
        this.scheduleErrorLogMessageIdQueryIndex = index;
    }

    public int getScheduleErrorLogMessageIdQueryIndex() {
        return this.scheduleErrorLogMessageIdQueryIndex;
    }

    public void setScheduleErrorLogMessageId(String id) {
        this.scheduleErrorLogMessageId = id;
    }

    public String getScheduleErrorLogMessageId() {
        return this.scheduleErrorLogMessageId;
    }

    public void setScheduleTimeoutLogMessageIdQueryIndex(int index) {
        this.scheduleTimeoutLogMessageIdQueryIndex = index;
    }

    public int getScheduleTimeoutLogMessageIdQueryIndex() {
        return this.scheduleTimeoutLogMessageIdQueryIndex;
    }

    public void setScheduleTimeoutLogMessageId(String id) {
        this.scheduleTimeoutLogMessageId = id;
    }

    public String getScheduleTimeoutLogMessageId() {
        return this.scheduleTimeoutLogMessageId;
    }

    public void setScheduleJournalServiceName(ServiceName name) {
        this.scheduleJournalServiceName = name;
    }

    public ServiceName getScheduleJournalServiceName() {
        return this.scheduleJournalServiceName;
    }

    public void setScheduleJournalServiceNameQueryIndex(int index) {
        this.scheduleJournalServiceNameQueryIndex = index;
    }

    public int getScheduleJournalServiceNameQueryIndex() {
        return this.scheduleJournalServiceNameQueryIndex;
    }

    public void setScheduleQueueServiceName(ServiceName name) {
        this.scheduleQueueServiceName = name;
    }

    public ServiceName getScheduleQueueServiceName() {
        return this.scheduleQueueServiceName;
    }

    public void setScheduleQueueServiceNameQueryIndex(int index) {
        this.scheduleQueueServiceNameQueryIndex = index;
    }

    public int getScheduleQueueServiceNameQueryIndex() {
        return this.scheduleQueueServiceNameQueryIndex;
    }

    public void setScheduleGarbageQueueQueryIndex(int index) {
        this.scheduleGarbageQueueQueryIndex = index;
    }

    public int getScheduleGarbageQueueQueryIndex() {
        return this.scheduleGarbageQueueQueryIndex;
    }

    public void setScheduleStateManagerServiceName(ServiceName name) {
        this.scheduleStateManagerServiceName = name;
    }

    public ServiceName getScheduleStateManagerServiceName() {
        return this.scheduleStateManagerServiceName;
    }

    public void setScheduleStateManagerServiceNameQueryIndex(int index) {
        this.scheduleStateManagerServiceNameQueryIndex = index;
    }

    public int getScheduleStateManagerServiceNameQueryIndex() {
        return this.scheduleStateManagerServiceNameQueryIndex;
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setScheduleBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.scheduleBeanFlowInvokerFactory = factory;
    }

    public void setScheduleFacadeCaller(FacadeCaller caller) {
        this.scheduleFacadeCaller = caller;
    }

    public void setScheduleJournal(Journal journal) {
        this.scheduleJournal = journal;
    }

    public void setScheduleQueue(Queue queue) {
        this.scheduleQueue = queue;
    }

    public void setScheduleStateManager(ScheduleStateManager manager) {
        this.scheduleStateManager = manager;
    }

    public void createService() throws Exception {
        this.scheduleMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() throws Exception {
        Connection con;
        block24: {
            SQLException e22;
            Statement stmt;
            block23: {
                if (this.connectionFactoryServiceName == null && this.connectionFactory == null) {
                    throw new IllegalArgumentException("ConnectionFactoryServiceName or  ConnectionFactory must be specified.");
                }
                if (this.connectionFactoryServiceName != null) {
                    this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
                }
                if (this.scheduleBeanFlowInvokerFactoryServiceName != null) {
                    this.scheduleBeanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.scheduleBeanFlowInvokerFactoryServiceName);
                }
                if (this.scheduleFacadeCallerServiceName != null) {
                    this.scheduleFacadeCaller = (FacadeCaller)ServiceManagerFactory.getServiceObject(this.scheduleFacadeCallerServiceName);
                }
                if (this.scheduleStartTimeFormat != null) {
                    this.scheduleStartTimeDateFormat = new SimpleDateFormat(this.scheduleStartTimeFormat);
                }
                if (this.scheduleEndTimeFormat != null) {
                    this.scheduleEndTimeDateFormat = new SimpleDateFormat(this.scheduleEndTimeFormat);
                }
                if (this.scheduleJournalServiceName != null) {
                    this.scheduleJournal = (Journal)ServiceManagerFactory.getServiceObject(this.scheduleJournalServiceName);
                }
                if (this.scheduleStateManagerServiceName != null) {
                    this.scheduleStateManager = (ScheduleStateManager)ServiceManagerFactory.getServiceObject(this.scheduleStateManagerServiceName);
                }
                if (this.scheduleMasterQuery == null) {
                    throw new IllegalArgumentException("ScheduleMasterQuery must be specified.");
                }
                con = this.connectionFactory.getConnection();
                stmt = null;
                ResultSet rs = null;
                try {
                    stmt = con.createStatement();
                    rs = stmt.executeQuery(this.scheduleMasterQuery);
                    int rowNum = 0;
                    while (rs.next()) {
                        TimerScheduleService schedule;
                        String key = this.createScheduleKey(rs);
                        HashMap<String, TimerScheduleService> schedules = (HashMap<String, TimerScheduleService>)this.scheduleMap.get(key);
                        if (schedules == null) {
                            schedules = new HashMap<String, TimerScheduleService>();
                            this.scheduleMap.put(key, schedules);
                        }
                        if ((schedule = this.createSchedule(rs, ++rowNum)) == null) continue;
                        if (schedules.containsKey(schedule.getName())) {
                            throw new IllegalArgumentException("Schedule name is duplicated : " + schedule.getName());
                        }
                        schedule.create();
                        schedule.start();
                        schedules.put(schedule.getName(), schedule);
                    }
                    Object var9_8 = null;
                    if (rs == null) break block23;
                }
                catch (Throwable throwable) {
                    SQLException e22;
                    Object var9_9 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e22) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e22) {
                            // empty catch block
                        }
                    }
                    con.close();
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (SQLException e22) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                    break block24;
                }
                catch (SQLException e22) {
                    // empty catch block
                }
                {
                }
            }
        }
        con.close();
    }

    public void stopService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = null;
        }
        if (this.scheduleBeanFlowInvokerFactoryServiceName != null) {
            this.scheduleBeanFlowInvokerFactory = null;
        }
        Iterator nameAndScheduleItr = this.scheduleMap.values().iterator();
        while (nameAndScheduleItr.hasNext()) {
            Map nameAndSchedule = (Map)nameAndScheduleItr.next();
            Iterator scheduleItr = nameAndSchedule.values().iterator();
            while (scheduleItr.hasNext()) {
                TimerScheduleService schedule = (TimerScheduleService)scheduleItr.next();
                schedule.stop();
                schedule.destroy();
                scheduleItr.remove();
            }
            nameAndScheduleItr.remove();
        }
    }

    public void destoryService() throws Exception {
        this.connectionFactory = null;
        this.scheduleMap = null;
    }

    protected String createScheduleKey(ResultSet rs) throws Exception {
        String key = null;
        if (this.scheduleKeyQueryIndex > 0) {
            key = rs.getString(this.scheduleKeyQueryIndex);
        }
        return key;
    }

    protected TimerScheduleService createSchedule(ResultSet rs, int rowNum) throws Exception {
        ScheduleStateManager stateManager;
        Boolean isGarbageQueue;
        Queue queue;
        Journal journal;
        String timeoutLogMessageId;
        String errorLogMessageId;
        long dependencyConfirmInterval;
        long dependencyTimeout;
        String[] dependsScheduleNames;
        Boolean isFixedRate;
        int count;
        long period;
        TimerScheduleService schedule = new TimerScheduleService();
        String name = this.createScheduleName(rs, rowNum);
        schedule.setServiceManagerName(this.getServiceManagerName());
        schedule.setServiceName(name);
        schedule.setName(name);
        schedule.setTask(this.createScheduleTask(name, rs));
        schedule.setStartTime(this.createStartTime(name, rs));
        Boolean isExecuteWhenOverStartTime = this.createExecuteWhenOverStartTime(name, rs);
        if (isExecuteWhenOverStartTime != null) {
            schedule.setExecuteWhenOverStartTime(isExecuteWhenOverStartTime);
        }
        schedule.setEndTime(this.createEndTime(name, rs));
        long delay = this.createDelay(name, rs);
        if (delay > 0L) {
            schedule.setDelay(delay);
        }
        if ((period = this.createPeriod(name, rs)) > 0L) {
            schedule.setPeriod(period);
        }
        if ((count = this.createCount(name, rs)) > 0) {
            schedule.setCount(count);
        }
        if ((isFixedRate = this.createFixedRate(name, rs)) != null) {
            schedule.setFixedRate(isFixedRate);
        }
        if ((dependsScheduleNames = this.createDependsScheduleNames(name, rs)) != null) {
            schedule.setDependsScheduleNames(dependsScheduleNames);
        }
        if ((dependencyTimeout = this.createDependencyTimeout(name, rs)) > 0L) {
            schedule.setDependencyTimeout(dependencyTimeout);
        }
        if ((dependencyConfirmInterval = this.createDependencyConfirmInterval(name, rs)) > 0L) {
            schedule.setDependencyConfirmInterval(dependencyConfirmInterval);
        }
        if ((errorLogMessageId = this.createErrorLogMessageId(name, rs)) != null) {
            schedule.setErrorLogMessageId(errorLogMessageId);
        }
        if ((timeoutLogMessageId = this.createTimeoutLogMessageId(name, rs)) != null) {
            schedule.setTimeoutLogMessageId(timeoutLogMessageId);
        }
        if ((journal = this.createJournal(name, rs)) != null) {
            schedule.setJournal(journal);
        }
        if ((queue = this.createQueue(name, rs)) != null) {
            schedule.setQueue(queue);
        }
        if ((isGarbageQueue = this.createGarbageQueue(name, rs)) != null) {
            schedule.setGarbageQueue(isGarbageQueue);
        }
        if ((stateManager = this.createScheduleStateManager(name, rs)) != null) {
            schedule.setScheduleStateManager(stateManager);
        }
        return schedule;
    }

    protected String createScheduleName(ResultSet rs, int rowNum) throws Exception {
        String name = null;
        if (this.scheduleNameQueryIndex > 0) {
            name = rs.getString(this.scheduleNameQueryIndex);
            if (rs.wasNull()) {
                throw new IllegalArgumentException("Schedule name was null.");
            }
        } else {
            name = this.getServiceName() + rowNum;
        }
        return name;
    }

    protected ScheduleTask createScheduleTask(String scheduleName, ResultSet rs) throws Exception {
        String scheduleTaskServiceNameStr;
        String beanFlowName;
        String beanFlowNames;
        ServiceNameEditor serviceNameEditor = new ServiceNameEditor();
        if (this.scheduleBeanFlowNamesQueryIndex > 0 && (beanFlowNames = rs.getString(this.scheduleBeanFlowNamesQueryIndex)) != null && beanFlowNames.length() != 0) {
            String serviceNameStr;
            StringArrayEditor stringArrayEditor = new StringArrayEditor();
            stringArrayEditor.setAsText(beanFlowNames);
            String[] beanFlowNameArray = (String[])stringArrayEditor.getValue();
            FacadeCaller facadeCaller = null;
            if (this.scheduleFacadeCallerServiceNameQueryIndex > 0 && (serviceNameStr = rs.getString(this.scheduleFacadeCallerServiceNameQueryIndex)) != null) {
                serviceNameEditor.setAsText(serviceNameStr);
                facadeCaller = (FacadeCaller)ServiceManagerFactory.getServiceObject((ServiceName)serviceNameEditor.getValue());
            }
            if (facadeCaller == null) {
                facadeCaller = this.scheduleFacadeCaller;
            }
            if (facadeCaller == null) {
                throw new IllegalArgumentException("FacadeCaller is null : " + scheduleName);
            }
            String iocCallType = null;
            if (this.scheduleIOCCallTypeQueryIndex > 0) {
                iocCallType = rs.getString(this.scheduleIOCCallTypeQueryIndex);
            }
            IOCCallScheduleTaskService iocCallTask = new IOCCallScheduleTaskService();
            iocCallTask.setBeanFlowNames(beanFlowNameArray);
            iocCallTask.setFacadeCaller(facadeCaller);
            if (iocCallType != null) {
                iocCallTask.setIOCCallType(iocCallType);
            }
            iocCallTask.create();
            iocCallTask.start();
            return iocCallTask;
        }
        if (this.scheduleBeanFlowNameQueryIndex > 0 && (beanFlowName = rs.getString(this.scheduleBeanFlowNameQueryIndex)) != null && beanFlowName.length() != 0) {
            String serviceNameStr;
            BeanFlowInvokerFactory beanFlowInvokerFactory = null;
            if (this.scheduleBeanFlowInvokerFactoryServiceNameQueryIndex > 0 && (serviceNameStr = rs.getString(this.scheduleBeanFlowInvokerFactoryServiceNameQueryIndex)) != null) {
                serviceNameEditor.setAsText(serviceNameStr);
                beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject((ServiceName)serviceNameEditor.getValue());
            }
            if (beanFlowInvokerFactory == null) {
                beanFlowInvokerFactory = this.scheduleBeanFlowInvokerFactory;
            }
            if (beanFlowInvokerFactory == null) {
                throw new IllegalArgumentException("BeanFlowInvokerFactory is null : " + scheduleName);
            }
            BeanFlowCallScheduleTaskService beanFlowTask = new BeanFlowCallScheduleTaskService();
            beanFlowTask.setBeanFlowName(beanFlowName);
            beanFlowTask.setBeanFlowInvokerFactory(beanFlowInvokerFactory);
            beanFlowTask.create();
            beanFlowTask.start();
            return beanFlowTask;
        }
        if (this.scheduleTaskServiceNameQueryIndex > 0 && (scheduleTaskServiceNameStr = rs.getString(this.scheduleTaskServiceNameQueryIndex)) != null) {
            serviceNameEditor.setAsText(scheduleTaskServiceNameStr);
            return (ScheduleTask)ServiceManagerFactory.getServiceObject((ServiceName)serviceNameEditor.getValue());
        }
        throw new IllegalArgumentException("Task is null : " + scheduleName);
    }

    protected Date createStartTime(String scheduleName, ResultSet rs) throws Exception {
        return this.getDate(scheduleName, rs, this.scheduleStartTimeQueryIndex, this.scheduleStartTimeDateFormat);
    }

    private Date getDate(String scheduleName, ResultSet rs, int queryIndex, DateFormat format) throws Exception {
        Date result = null;
        if (queryIndex > 0) {
            int sqlType = rs.getMetaData().getColumnType(queryIndex);
            switch (sqlType) {
                case 91: 
                case 93: {
                    result = rs.getTimestamp(queryIndex);
                    break;
                }
                case 92: {
                    Time time = rs.getTime(queryIndex);
                    Calendar now = Calendar.getInstance();
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(time);
                    cal.set(1, now.get(1));
                    cal.set(6, now.get(6));
                    result = cal.getTime();
                    break;
                }
                case 1: 
                case 12: {
                    if (format == null) {
                        throw new IllegalArgumentException("DateFormat is null : " + scheduleName);
                    }
                    String dateStr = rs.getString(queryIndex);
                    if (dateStr != null && sqlType == 1) {
                        dateStr = dateStr.trim();
                    }
                    if (dateStr == null || dateStr.length() == 0) break;
                    result = format.parse(dateStr);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported sql type : " + sqlType);
                }
            }
        }
        return result;
    }

    protected Boolean createExecuteWhenOverStartTime(String scheduleName, ResultSet rs) throws Exception {
        return this.getBoolean(scheduleName, rs, this.scheduleExecuteWhenOverStartTimeQueryIndex);
    }

    private Boolean getBoolean(String scheduleName, ResultSet rs, int queryIndex) throws Exception {
        Boolean result = null;
        if (queryIndex > 0) {
            int sqlType = rs.getMetaData().getColumnType(queryIndex);
            switch (sqlType) {
                case 16: {
                    boolean boolVal = rs.getBoolean(queryIndex);
                    if (rs.wasNull()) break;
                    result = boolVal ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1: 
                case 12: {
                    String strVal = rs.getString(queryIndex);
                    if (strVal != null && sqlType == 1) {
                        strVal = strVal.trim();
                    }
                    if (strVal == null || strVal.length() == 0) break;
                    result = "0".equals(strVal) || strVal == null || !"true".equalsIgnoreCase(strVal) ? Boolean.FALSE : Boolean.TRUE;
                    break;
                }
                case -6: 
                case 2: 
                case 4: 
                case 5: {
                    int intVal = rs.getInt(queryIndex);
                    if (rs.wasNull()) break;
                    result = intVal == 0 ? Boolean.FALSE : Boolean.TRUE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported sql type : " + sqlType);
                }
            }
        }
        return result;
    }

    protected Date createEndTime(String scheduleName, ResultSet rs) throws Exception {
        return this.getDate(scheduleName, rs, this.scheduleEndTimeQueryIndex, this.scheduleEndTimeDateFormat);
    }

    protected long createDelay(String scheduleName, ResultSet rs) throws Exception {
        long delay = -1L;
        if (this.scheduleDelayQueryIndex > 0) {
            delay = rs.getLong(this.scheduleDelayQueryIndex);
            if (rs.wasNull()) {
                delay = -1L;
            }
        }
        return delay;
    }

    protected long createPeriod(String scheduleName, ResultSet rs) throws Exception {
        long period = -1L;
        if (this.schedulePeriodQueryIndex > 0) {
            period = rs.getLong(this.schedulePeriodQueryIndex);
            if (rs.wasNull()) {
                period = -1L;
            }
        }
        return period;
    }

    protected int createCount(String scheduleName, ResultSet rs) throws Exception {
        int period = -1;
        if (this.scheduleCountQueryIndex > 0) {
            period = rs.getInt(this.scheduleCountQueryIndex);
            if (rs.wasNull()) {
                period = -1;
            }
        }
        return period;
    }

    protected Boolean createFixedRate(String scheduleName, ResultSet rs) throws Exception {
        return this.getBoolean(scheduleName, rs, this.scheduleFixedRateQueryIndex);
    }

    protected String[] createDependsScheduleNames(String scheduleName, ResultSet rs) throws Exception {
        String[] dependsScheduleNames = null;
        if (this.scheduleDependsScheduleNamesQueryIndex > 0) {
            String names = rs.getString(this.scheduleDependsScheduleNamesQueryIndex);
            if (names != null && names.length() != 0) {
                names = names.trim();
            }
            if (names != null && names.length() != 0) {
                StringArrayEditor stringArrayEditor = new StringArrayEditor();
                stringArrayEditor.setAsText(names);
                dependsScheduleNames = (String[])stringArrayEditor.getValue();
            }
        }
        return dependsScheduleNames;
    }

    protected long createDependencyTimeout(String scheduleName, ResultSet rs) throws Exception {
        long timeout = -1L;
        if (this.scheduleDependencyTimeoutQueryIndex > 0) {
            timeout = rs.getLong(this.scheduleDependencyTimeoutQueryIndex);
            if (rs.wasNull()) {
                timeout = -1L;
            }
        }
        return timeout;
    }

    protected long createDependencyConfirmInterval(String scheduleName, ResultSet rs) throws Exception {
        long interval = -1L;
        if (this.scheduleDependencyConfirmIntervalQueryIndex > 0) {
            interval = rs.getLong(this.scheduleDependencyConfirmIntervalQueryIndex);
            if (rs.wasNull()) {
                interval = -1L;
            }
        }
        return interval;
    }

    protected String createErrorLogMessageId(String scheduleName, ResultSet rs) throws Exception {
        String id = null;
        if (this.scheduleErrorLogMessageIdQueryIndex > 0 && (id = rs.getString(this.scheduleErrorLogMessageIdQueryIndex)) != null && id.length() != 0) {
            id = id.trim();
        }
        if (id == null || id.length() == 0) {
            id = this.scheduleErrorLogMessageId;
        }
        return id;
    }

    protected String createTimeoutLogMessageId(String scheduleName, ResultSet rs) throws Exception {
        String id = null;
        if (this.scheduleTimeoutLogMessageIdQueryIndex > 0 && (id = rs.getString(this.scheduleTimeoutLogMessageIdQueryIndex)) != null && id.length() != 0) {
            id = id.trim();
        }
        if (id == null || id.length() == 0) {
            id = this.scheduleTimeoutLogMessageId;
        }
        return id;
    }

    protected Journal createJournal(String scheduleName, ResultSet rs) throws Exception {
        String serviceNameStr;
        Journal journal = null;
        if (this.scheduleJournalServiceNameQueryIndex > 0 && (serviceNameStr = rs.getString(this.scheduleJournalServiceNameQueryIndex)) != null) {
            ServiceNameEditor serviceNameEditor = new ServiceNameEditor();
            serviceNameEditor.setAsText(serviceNameStr);
            journal = (Journal)ServiceManagerFactory.getServiceObject((ServiceName)serviceNameEditor.getValue());
        }
        if (journal == null) {
            journal = this.scheduleJournal;
        }
        return journal;
    }

    protected Queue createQueue(String scheduleName, ResultSet rs) throws Exception {
        String serviceNameStr;
        Queue queue = null;
        if (this.scheduleQueueServiceNameQueryIndex > 0 && (serviceNameStr = rs.getString(this.scheduleQueueServiceNameQueryIndex)) != null) {
            ServiceNameEditor serviceNameEditor = new ServiceNameEditor();
            serviceNameEditor.setAsText(serviceNameStr);
            queue = (Queue)ServiceManagerFactory.getServiceObject((ServiceName)serviceNameEditor.getValue());
        }
        if (queue == null) {
            queue = this.scheduleQueueServiceName != null ? (Queue)ServiceManagerFactory.getServiceObject(this.scheduleQueueServiceName) : this.scheduleQueue;
        }
        return queue;
    }

    protected Boolean createGarbageQueue(String scheduleName, ResultSet rs) throws Exception {
        return this.getBoolean(scheduleName, rs, this.scheduleGarbageQueueQueryIndex);
    }

    protected ScheduleStateManager createScheduleStateManager(String scheduleName, ResultSet rs) throws Exception {
        String serviceNameStr;
        ScheduleStateManager manager = null;
        if (this.scheduleStateManagerServiceNameQueryIndex > 0 && (serviceNameStr = rs.getString(this.scheduleStateManagerServiceNameQueryIndex)) != null) {
            ServiceNameEditor serviceNameEditor = new ServiceNameEditor();
            serviceNameEditor.setAsText(serviceNameStr);
            manager = (ScheduleStateManager)ServiceManagerFactory.getServiceObject((ServiceName)serviceNameEditor.getValue());
        }
        if (manager == null) {
            manager = this.scheduleStateManager;
        }
        return manager;
    }

    public Schedule[] getSchedules(Object key) {
        Map schedules = (Map)this.scheduleMap.get(key);
        if (schedules == null && key != null) {
            schedules = (Map)this.scheduleMap.get(null);
        }
        return schedules == null ? new Schedule[]{} : schedules.values().toArray(new Schedule[schedules.size()]);
    }
}

