/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.scheduler.ScheduleStateManager;
import jp.ossc.nimbus.service.scheduler.ScheduleTask;
import jp.ossc.nimbus.service.scheduler.Scheduler;
import jp.ossc.nimbus.service.scheduler.TimerSchedule;
import jp.ossc.nimbus.service.scheduler.TimerScheduleServiceMBean;

public class TimerScheduleService
extends ServiceBase
implements TimerSchedule,
Serializable,
TimerScheduleServiceMBean {
    private static final long serialVersionUID = 8328157884039980522L;
    protected String name;
    protected ServiceName taskServiceName;
    protected ManagedTimerTask task;
    protected transient ScheduleTask scheduleTask;
    protected Date startTime;
    protected Date endTime;
    protected long delay = -1L;
    protected long period = -1L;
    protected int count = -1;
    protected boolean isFixedRate;
    protected String[] dependsScheduleNames;
    protected long dependencyTimeout = -1L;
    protected long dependencyConfirmInterval = 1000L;
    protected String errorLogMessageId = "TS___00001";
    protected String timeoutLogMessageId = "TS___00002";
    protected ServiceName journalServiceName;
    protected transient Journal journal;
    protected ServiceName queueServiceName;
    protected transient Queue queue;
    protected boolean isGarbageQueue = false;
    protected transient Daemon daemon;
    protected transient Scheduler scheduler;
    protected ServiceName scheduleStateManagerServiceName;
    protected transient ScheduleStateManager scheduleStateManager;
    protected boolean isExecuteWhenOverStartTime = true;

    public void setName(String name) {
        this.name = name;
    }

    public void setTaskServiceName(ServiceName name) {
        this.taskServiceName = name;
    }

    public ServiceName getTaskServiceName() {
        return this.taskServiceName;
    }

    public void setStartTime(Date time) {
        this.startTime = time;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setExecuteWhenOverStartTime(boolean isExecute) {
        this.isExecuteWhenOverStartTime = isExecute;
    }

    public boolean isExecuteWhenOverStartTime() {
        return this.isExecuteWhenOverStartTime;
    }

    public void setEndTime(Date time) {
        this.endTime = time;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public void setFixedRate(boolean isFixedRate) {
        this.isFixedRate = isFixedRate;
    }

    public boolean isFixedRate() {
        return this.isFixedRate;
    }

    public void setDependsScheduleNames(String[] names) {
        this.dependsScheduleNames = names;
    }

    public String[] getDependsScheduleNames() {
        return this.dependsScheduleNames;
    }

    public void setDependencyTimeout(long timeout) {
        this.dependencyTimeout = timeout;
    }

    public long getDependencyTimeout() {
        return this.dependencyTimeout;
    }

    public void setDependencyConfirmInterval(long interval) {
        this.dependencyConfirmInterval = interval;
    }

    public long getDependencyConfirmInterval() {
        return this.dependencyConfirmInterval;
    }

    public void setErrorLogMessageId(String id) {
        this.errorLogMessageId = id;
    }

    public String getErrorLogMessageId() {
        return this.errorLogMessageId;
    }

    public void setTimeoutLogMessageId(String id) {
        this.timeoutLogMessageId = id;
    }

    public String getTimeoutLogMessageId() {
        return this.timeoutLogMessageId;
    }

    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    public void setGarbageQueue(boolean isGarbage) {
        this.isGarbageQueue = isGarbage;
    }

    public boolean isGarbageQueue() {
        return this.isGarbageQueue;
    }

    public void setScheduleStateManagerServiceName(ServiceName name) {
        this.scheduleStateManagerServiceName = name;
    }

    public ServiceName getScheduleStateManagerServiceName() {
        return this.scheduleStateManagerServiceName;
    }

    public void startService() throws Exception {
        if (this.taskServiceName != null) {
            this.scheduleTask = (ScheduleTask)ServiceManagerFactory.getServiceObject(this.taskServiceName);
        }
        if (this.scheduleTask == null) {
            throw new IllegalArgumentException("Task must be specified.");
        }
        this.task = new ManagedTimerTask(this.scheduleTask);
        boolean bl = this.task.isCyclic = this.period != -1L;
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.queueServiceName != null) {
            this.queue = (Queue)ServiceManagerFactory.getServiceObject(this.queueServiceName);
        }
        if (this.scheduleStateManager == null && this.scheduleStateManagerServiceName != null) {
            this.scheduleStateManager = (ScheduleStateManager)ServiceManagerFactory.getServiceObject(this.scheduleStateManagerServiceName);
        }
        if (this.scheduleStateManager != null && -1 == this.scheduleStateManager.getState(this.getName())) {
            this.scheduleStateManager.changeState(this.getName(), 0);
        }
        if (this.queue != null) {
            this.daemon = new Daemon(this.task);
            this.daemon.start();
        }
    }

    public void stopService() throws Exception {
        this.cancel();
        if (this.queue != null) {
            this.daemon.stop();
            this.queue.release();
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void executeForce() {
        ManagedTimerTask tmpTask = new ManagedTimerTask(this.scheduleTask);
        tmpTask.isForce = true;
        tmpTask.run();
    }

    public void executeForce(Timer timer, long delay) {
        ManagedTimerTask tmpTask = new ManagedTimerTask(this.scheduleTask);
        tmpTask.isForce = true;
        timer.schedule((TimerTask)tmpTask, delay);
    }

    public void executeForce(Timer timer, Date time) {
        ManagedTimerTask tmpTask = new ManagedTimerTask(this.scheduleTask);
        tmpTask.isForce = true;
        timer.schedule((TimerTask)tmpTask, time);
    }

    public void schedule(Timer timer) {
        if (this.scheduleStateManager != null) {
            switch (this.scheduleStateManager.getState(this.getName())) {
                case 4: {
                    this.task.isClosed = true;
                    return;
                }
                case 5: {
                    this.task.isValid = false;
                }
            }
        }
        this.task.isValid = true;
        this.task.maxCount = this.count;
        Calendar nowCal = null;
        Calendar tmpCal = null;
        if (this.endTime != null) {
            nowCal = Calendar.getInstance();
            tmpCal = Calendar.getInstance();
            tmpCal.setTime(this.endTime);
            if (nowCal.after(tmpCal)) {
                return;
            }
        }
        if (!this.isExecuteWhenOverStartTime && this.startTime != null) {
            if (nowCal == null) {
                nowCal = Calendar.getInstance();
                tmpCal = Calendar.getInstance();
            } else {
                tmpCal.clear();
            }
            tmpCal.setTime(this.startTime);
            if (tmpCal.before(nowCal)) {
                if (this.task.isCyclic) {
                    long startTimeInMillis = this.startTime.getTime();
                    do {
                        tmpCal.clear();
                        tmpCal.setTimeInMillis(startTimeInMillis += this.period);
                    } while (tmpCal.before(nowCal));
                    this.startTime.setTime(startTimeInMillis);
                } else {
                    return;
                }
            }
        }
        if (this.scheduleStateManager != null) {
            this.scheduleStateManager.changeState(this.getName(), 1);
        }
        if (this.isFixedRate) {
            if (this.delay >= 0L) {
                timer.scheduleAtFixedRate((TimerTask)this.task, this.delay, this.period);
            } else {
                timer.scheduleAtFixedRate((TimerTask)this.task, this.startTime == null ? new Date() : this.startTime, this.period);
            }
        } else if (this.delay >= 0L && this.period > 0L) {
            timer.schedule((TimerTask)this.task, this.delay, this.period);
        } else if (this.period > 0L) {
            timer.schedule((TimerTask)this.task, this.startTime == null ? new Date() : this.startTime, this.period);
        } else if (this.delay >= 0L) {
            timer.schedule((TimerTask)this.task, this.delay);
        } else {
            timer.schedule((TimerTask)this.task, this.startTime == null ? new Date() : this.startTime);
        }
        this.task.isClosed = false;
        if (this.endTime != null) {
            timer.schedule(new TimerTask(){

                public void run() {
                    TimerScheduleService.this.task.cancel();
                    TimerScheduleService.this.task.isClosed = true;
                    if (TimerScheduleService.this.scheduleStateManager != null) {
                        TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                    }
                }
            }, this.endTime);
        }
    }

    public String getName() {
        return this.name == null ? this.getServiceName() : this.name;
    }

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public void setValid(boolean isValid) {
        if (this.task != null) {
            this.task.isValid = isValid;
            if (!isValid && this.scheduleStateManager != null) {
                this.scheduleStateManager.changeState(this.getName(), 5);
            }
        }
    }

    public boolean isValid() {
        return this.task == null ? false : this.task.isValid;
    }

    public boolean isCyclic() {
        return this.task == null ? false : this.task.isCyclic;
    }

    public boolean isClosed() {
        return this.task == null ? true : this.task.isClosed;
    }

    public boolean isRunning() {
        return this.task == null ? false : this.task.isRunning;
    }

    public boolean isError() {
        return this.task == null ? false : this.task.isError;
    }

    public boolean isWaiting() {
        return this.task == null ? false : this.task.isWaiting;
    }

    public boolean isTimeout() {
        return this.task == null ? false : this.task.isTimeout;
    }

    public Date getLastExecutionTime() {
        return this.task == null || this.task.lastExecutionTime == 0L ? null : new Date(this.task.lastExecutionTime);
    }

    public Date getScheduledExecutionTime() {
        return this.task == null ? null : new Date(this.task.scheduledExecutionTime == 0L ? this.task.scheduledExecutionTime() : this.task.scheduledExecutionTime);
    }

    public void setScheduleStateManager(ScheduleStateManager manager) {
        this.scheduleStateManager = manager;
        if (this.scheduleStateManager != null && this.getState() == 3 && -1 == this.scheduleStateManager.getState(this.getName())) {
            this.scheduleStateManager.changeState(this.getName(), 0);
        }
    }

    public ScheduleStateManager getScheduleStateManager() {
        return this.scheduleStateManager;
    }

    public void setTask(ScheduleTask task) {
        if (task == null) {
            throw new IllegalArgumentException("Task is null.");
        }
        this.scheduleTask = task;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('{');
        buf.append("name=").append(this.getName());
        buf.append(", startTime=").append(this.startTime);
        buf.append(", delay=").append(this.delay);
        buf.append(", period=").append(this.period);
        buf.append(", count=").append(this.count);
        buf.append(", isFixedRate=").append(this.isFixedRate);
        buf.append(", task=").append(this.task);
        buf.append(", isValid=").append(this.isValid());
        buf.append(", isClosed=").append(this.isClosed());
        buf.append(", isRunning=").append(this.isRunning());
        buf.append(", scheduledExecutionTime=").append(this.getScheduledExecutionTime());
        buf.append(", lastExecutionTime=").append(this.getLastExecutionTime());
        buf.append(", queue=").append(this.queue);
        buf.append('}');
        return buf.toString();
    }

    protected class ManagedTimerTask
    extends TimerTask
    implements DaemonRunnable,
    Serializable {
        private static final long serialVersionUID = -8278944414741844753L;
        protected transient ScheduleTask task;
        protected boolean isRunning;
        protected boolean isClosed = true;
        protected boolean isCyclic;
        protected boolean isValid;
        protected boolean isWaiting;
        protected boolean isError;
        protected boolean isTimeout;
        protected long lastExecutionTime;
        protected long scheduledExecutionTime;
        protected int executionCount;
        protected int maxCount;
        protected boolean isForce;

        public ManagedTimerTask(ScheduleTask task) {
            this.task = task;
        }

        public void run() {
            if (!this.isForce) {
                if (TimerScheduleService.this.scheduleStateManager != null) {
                    int state = TimerScheduleService.this.scheduleStateManager.getState(TimerScheduleService.this.getName());
                    this.isValid = state != 5;
                    boolean bl = this.isClosed = state == 4;
                }
                if (!this.isValid) {
                    return;
                }
                if (this.isClosed) {
                    this.cancel();
                    return;
                }
            }
            if (TimerScheduleService.this.queue == null || this.isForce) {
                this.consume(this.task, null);
            } else {
                TimerScheduleService.this.queue.push(this.task);
            }
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) {
            return TimerScheduleService.this.queue.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void consume(Object dequeued, DaemonControl ctrl) {
            block79: {
                block78: {
                    block77: {
                        block80: {
                            block75: {
                                block76: {
                                    if (dequeued == null) {
                                        return;
                                    }
                                    try {
                                        try {
                                            block73: {
                                                if (TimerScheduleService.this.journal != null) {
                                                    TimerScheduleService.this.journal.startJournal("Schedule");
                                                    TimerScheduleService.this.journal.addInfo("Name", TimerScheduleService.this.getName());
                                                }
                                                this.isError = false;
                                                this.isTimeout = false;
                                                if (TimerScheduleService.this.dependsScheduleNames != null && TimerScheduleService.this.dependsScheduleNames.length != 0) {
                                                    long start = System.currentTimeMillis();
                                                    long procTime = 0L;
                                                    while (true) {
                                                        boolean isExistNotClosed = false;
                                                        for (int i = 0; i < TimerScheduleService.this.dependsScheduleNames.length; ++i) {
                                                            TimerSchedule schedule = TimerScheduleService.this.scheduler.getSchedule(TimerScheduleService.this.dependsScheduleNames[i]);
                                                            if (schedule == null || schedule.isCyclic() || schedule.isClosed()) continue;
                                                            isExistNotClosed = true;
                                                            break;
                                                        }
                                                        if (!isExistNotClosed) break block73;
                                                        this.isWaiting = true;
                                                        if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce && !this.isClosed) {
                                                            TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 2);
                                                        }
                                                        try {
                                                            if (TimerScheduleService.this.dependencyTimeout > 0L) {
                                                                Thread.sleep(TimerScheduleService.this.dependencyTimeout - procTime > TimerScheduleService.this.dependencyConfirmInterval ? TimerScheduleService.this.dependencyConfirmInterval : TimerScheduleService.this.dependencyTimeout - procTime);
                                                            } else {
                                                                Thread.sleep(TimerScheduleService.this.dependencyConfirmInterval);
                                                            }
                                                        }
                                                        catch (InterruptedException e) {
                                                            this.cancel();
                                                            if (TimerScheduleService.this.getLogger() != null) {
                                                                TimerScheduleService.this.getLogger().write(TimerScheduleService.this.timeoutLogMessageId, e);
                                                            }
                                                            if (TimerScheduleService.this.journal != null) {
                                                                TimerScheduleService.this.journal.addInfo("Exception", e);
                                                                TimerScheduleService.this.journal.addInfo("ResultStatus", "TIMEOUT");
                                                            }
                                                            this.isWaiting = false;
                                                            this.isTimeout = true;
                                                            Object var11_10 = null;
                                                            if (this.isCyclic) {
                                                                this.scheduledExecutionTime = this.scheduledExecutionTime() + TimerScheduleService.this.period;
                                                                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce && !this.isClosed) {
                                                                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 1);
                                                                }
                                                            } else if (!this.isError && !this.isTimeout) {
                                                                this.isClosed = true;
                                                                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                                                                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                                                                }
                                                            }
                                                            this.isRunning = false;
                                                            if (this.maxCount > 0 && this.executionCount >= this.maxCount) {
                                                                this.cancel();
                                                                this.isClosed = true;
                                                                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                                                                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                                                                }
                                                            }
                                                            if (TimerScheduleService.this.journal == null) return;
                                                            TimerScheduleService.this.journal.endJournal();
                                                            return;
                                                        }
                                                        procTime = System.currentTimeMillis() - start;
                                                        if (TimerScheduleService.this.dependencyTimeout > 0L && procTime >= TimerScheduleService.this.dependencyTimeout) {
                                                            this.cancel();
                                                            if (TimerScheduleService.this.getLogger() != null) {
                                                                TimerScheduleService.this.getLogger().write(TimerScheduleService.this.timeoutLogMessageId);
                                                            }
                                                            if (TimerScheduleService.this.journal != null) {
                                                                TimerScheduleService.this.journal.addInfo("ResultStatus", "TIMEOUT");
                                                            }
                                                            this.isWaiting = false;
                                                            this.isTimeout = true;
                                                            Object var11_11 = null;
                                                            if (!this.isCyclic) break block75;
                                                            break block76;
                                                        }
                                                        if (this.isForce) continue;
                                                        if (TimerScheduleService.this.scheduleStateManager != null) {
                                                            int state = TimerScheduleService.this.scheduleStateManager.getState(TimerScheduleService.this.getName());
                                                            this.isValid = state != 5;
                                                            boolean bl = this.isClosed = state == 4;
                                                        }
                                                        if (!this.isValid) {
                                                            break block77;
                                                        }
                                                        if (this.isClosed) break;
                                                    }
                                                    this.cancel();
                                                    break block78;
                                                }
                                            }
                                            this.isWaiting = false;
                                            this.isRunning = true;
                                            if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce && !this.isClosed) {
                                                TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 3);
                                            }
                                            this.lastExecutionTime = System.currentTimeMillis();
                                            ++this.executionCount;
                                            this.task.run();
                                            if (TimerScheduleService.this.journal != null) {
                                                TimerScheduleService.this.journal.addInfo("ResultStatus", "SUCCESS");
                                            }
                                            break block79;
                                        }
                                        catch (Throwable th) {
                                            this.isError = true;
                                            if (TimerScheduleService.this.getLogger() != null) {
                                                TimerScheduleService.this.getLogger().write(TimerScheduleService.this.errorLogMessageId, th);
                                            }
                                            if (TimerScheduleService.this.journal != null) {
                                                TimerScheduleService.this.journal.addInfo("Exception", th);
                                                TimerScheduleService.this.journal.addInfo("ResultStatus", "ERROR");
                                            }
                                            Object var11_15 = null;
                                            if (this.isCyclic) {
                                                this.scheduledExecutionTime = this.scheduledExecutionTime() + TimerScheduleService.this.period;
                                                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce && !this.isClosed) {
                                                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 1);
                                                }
                                            } else if (!this.isError && !this.isTimeout) {
                                                this.isClosed = true;
                                                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                                                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                                                }
                                            }
                                            this.isRunning = false;
                                            if (this.maxCount > 0 && this.executionCount >= this.maxCount) {
                                                this.cancel();
                                                this.isClosed = true;
                                                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                                                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                                                }
                                            }
                                            if (TimerScheduleService.this.journal == null) return;
                                            TimerScheduleService.this.journal.endJournal();
                                            return;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_16 = null;
                                        if (this.isCyclic) {
                                            this.scheduledExecutionTime = this.scheduledExecutionTime() + TimerScheduleService.this.period;
                                            if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce && !this.isClosed) {
                                                TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 1);
                                            }
                                        } else if (!this.isError && !this.isTimeout) {
                                            this.isClosed = true;
                                            if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                                                TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                                            }
                                        }
                                        this.isRunning = false;
                                        if (this.maxCount > 0 && this.executionCount >= this.maxCount) {
                                            this.cancel();
                                            this.isClosed = true;
                                            if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                                                TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                                            }
                                        }
                                        if (TimerScheduleService.this.journal == null) throw throwable;
                                        TimerScheduleService.this.journal.endJournal();
                                        throw throwable;
                                    }
                                }
                                this.scheduledExecutionTime = this.scheduledExecutionTime() + TimerScheduleService.this.period;
                                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce && !this.isClosed) {
                                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 1);
                                }
                                break block80;
                            }
                            if (!this.isError && !this.isTimeout) {
                                this.isClosed = true;
                                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                                }
                            }
                        }
                        this.isRunning = false;
                        if (this.maxCount > 0 && this.executionCount >= this.maxCount) {
                            this.cancel();
                            this.isClosed = true;
                            if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                                TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                            }
                        }
                        if (TimerScheduleService.this.journal == null) return;
                        TimerScheduleService.this.journal.endJournal();
                        return;
                    }
                    Object var11_12 = null;
                    if (this.isCyclic) {
                        this.scheduledExecutionTime = this.scheduledExecutionTime() + TimerScheduleService.this.period;
                        if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce && !this.isClosed) {
                            TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 1);
                        }
                    } else if (!this.isError && !this.isTimeout) {
                        this.isClosed = true;
                        if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                            TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                        }
                    }
                    this.isRunning = false;
                    if (this.maxCount > 0 && this.executionCount >= this.maxCount) {
                        this.cancel();
                        this.isClosed = true;
                        if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                            TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                        }
                    }
                    if (TimerScheduleService.this.journal == null) return;
                    TimerScheduleService.this.journal.endJournal();
                    return;
                }
                Object var11_13 = null;
                if (this.isCyclic) {
                    this.scheduledExecutionTime = this.scheduledExecutionTime() + TimerScheduleService.this.period;
                    if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce && !this.isClosed) {
                        TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 1);
                    }
                } else if (!this.isError && !this.isTimeout) {
                    this.isClosed = true;
                    if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                        TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                    }
                }
                this.isRunning = false;
                if (this.maxCount > 0 && this.executionCount >= this.maxCount) {
                    this.cancel();
                    this.isClosed = true;
                    if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                        TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                    }
                }
                if (TimerScheduleService.this.journal == null) return;
                TimerScheduleService.this.journal.endJournal();
                return;
            }
            Object var11_14 = null;
            if (this.isCyclic) {
                this.scheduledExecutionTime = this.scheduledExecutionTime() + TimerScheduleService.this.period;
                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce && !this.isClosed) {
                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 1);
                }
            } else if (!this.isError && !this.isTimeout) {
                this.isClosed = true;
                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                }
            }
            this.isRunning = false;
            if (this.maxCount > 0 && this.executionCount >= this.maxCount) {
                this.cancel();
                this.isClosed = true;
                if (TimerScheduleService.this.scheduleStateManager != null && !this.isForce) {
                    TimerScheduleService.this.scheduleStateManager.changeState(TimerScheduleService.this.getName(), 4);
                }
            }
            if (TimerScheduleService.this.journal == null) return;
            TimerScheduleService.this.journal.endJournal();
        }

        public void garbage() {
            if (TimerScheduleService.this.queue != null && TimerScheduleService.this.isGarbageQueue) {
                while (TimerScheduleService.this.queue.size() > 0) {
                    this.consume(TimerScheduleService.this.queue.get(0L), null);
                }
            }
        }

        public boolean cancel() {
            this.isRunning = false;
            this.isWaiting = false;
            return super.cancel();
        }
    }
}

