/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.CSVJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.DynaBeanCSVJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class DynaBeanCSVJournalEditorService
extends CSVJournalEditorServiceBase
implements DynaBeanCSVJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -1932366127966557595L;
    private static final String DEFAULT_SECRET_STRING = "******";
    private static final String PROPERTY_VALUE_SEPARATOR = "=";
    private static final String PROPERTY_SEPARATOR = ",";
    private String secretString = "******";
    private String[] secretProperties;
    protected Set secretPropertySet;
    private String[] enabledProperties;
    protected Set enabledPropertySet;
    private final Map outputElements = new HashMap();
    protected String[] outputElementKeys = new String[]{"DYNA_CLASS", "PROPERTIES"};

    public DynaBeanCSVJournalEditorService() {
        this.defineElements();
    }

    protected void defineElements() {
        this.defineElementEditor("DYNA_CLASS", new ElementEditor(){
            private static final long serialVersionUID = -8113402783790668238L;

            protected StringBuffer toString(EditorFinder finder, Object key, DynaBean bean, StringBuffer buf) {
                return DynaBeanCSVJournalEditorService.this.makeDynaClassFormat(finder, key, bean, buf);
            }
        });
        this.defineElementEditor("PROPERTIES", new ElementEditor(){
            private static final long serialVersionUID = 4127468984641295749L;

            protected StringBuffer toString(EditorFinder finder, Object key, DynaBean bean, StringBuffer buf) {
                return DynaBeanCSVJournalEditorService.this.makePropertiesFormat(finder, key, bean, buf);
            }
        });
    }

    protected void defineElementEditor(String key, ElementEditor editor) {
        this.outputElements.put(key, editor);
    }

    protected JournalEditor findElementEditor(String key) {
        return (JournalEditor)this.outputElements.get(key);
    }

    public void setOutputElementKeys(String[] keys) throws IllegalArgumentException {
        if (keys != null && keys.length != 0) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.outputElements.containsKey(key)) continue;
                throw new IllegalArgumentException(key + " is undefined.");
            }
            this.outputElementKeys = keys;
        }
    }

    public String[] getOutputElementKeys() {
        return this.outputElementKeys;
    }

    public void setSecretString(String str) {
        this.secretString = str;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public void setSecretProperties(String[] names) {
        this.secretProperties = names;
    }

    public String[] getSecretProperties() {
        return this.secretProperties;
    }

    public void setEnabledProperties(String[] names) {
        this.enabledProperties = names;
    }

    public String[] getEnabledProperties() {
        return this.enabledProperties;
    }

    public void createService() {
        this.secretPropertySet = new HashSet();
        this.enabledPropertySet = new HashSet();
    }

    public void startService() {
        int i;
        if (this.secretProperties != null) {
            for (i = 0; i < this.secretProperties.length; ++i) {
                this.secretPropertySet.add(this.secretProperties[i]);
            }
        }
        if (this.enabledProperties != null) {
            for (i = 0; i < this.enabledProperties.length; ++i) {
                this.enabledPropertySet.add(this.enabledProperties[i]);
            }
        }
    }

    public void stopService() {
        this.secretPropertySet.clear();
        this.enabledPropertySet.clear();
    }

    public void destroyService() {
        this.secretPropertySet = null;
        this.enabledPropertySet = null;
    }

    protected void processCSV(EditorFinder finder, Object key, Object value) {
        for (int i = 0; i < this.outputElementKeys.length; ++i) {
            JournalEditor editor = this.findElementEditor(this.outputElementKeys[i]);
            this.addElement(editor.toObject(finder, key, value));
        }
    }

    protected StringBuffer makeDynaClassFormat(EditorFinder finder, Object key, DynaBean bean, StringBuffer buf) {
        this.makeObjectFormat(finder, null, bean.getDynaClass(), buf);
        return buf;
    }

    protected StringBuffer makePropertiesFormat(EditorFinder finder, Object key, DynaBean bean, StringBuffer buf) {
        DynaClass dynaClass = bean.getDynaClass();
        DynaProperty[] props = dynaClass.getDynaProperties();
        if (props == null || props.length == 0) {
            buf.append("null");
            return buf;
        }
        int max = props.length;
        for (int i = 0; i < max; ++i) {
            String name = props[i].getName();
            if (!this.enabledPropertySet.isEmpty() && !this.enabledPropertySet.contains(name)) continue;
            buf.append(name);
            buf.append(PROPERTY_VALUE_SEPARATOR);
            if (this.secretPropertySet.contains(name)) {
                buf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, bean.get(name), buf);
            }
            if (i == max - 1) continue;
            buf.append(PROPERTY_SEPARATOR);
        }
        return buf;
    }

    protected abstract class ElementEditor
    extends ImmutableJournalEditorServiceBase
    implements Serializable {
        protected ElementEditor() {
        }

        public String toString(EditorFinder finder, Object key, Object value) {
            StringBuffer buf = new StringBuffer(super.toString(finder, key, value));
            return this.toString(finder, key, (DynaBean)value, buf).toString();
        }

        protected abstract StringBuffer toString(EditorFinder var1, Object var2, DynaBean var3, StringBuffer var4);
    }
}

