/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.keepalive.ClusterServiceMBean;

public class ClusterService
extends ServiceBase
implements ClusterServiceMBean {
    private static final long serialVersionUID = 4503189967951662029L;
    protected static final int MESSAGE_ID_ADD_REQ = 1;
    protected static final int MESSAGE_ID_MEMBER_CHANGE_REQ = 2;
    protected static final int MESSAGE_ID_MEMBER_MERGE_REQ = 3;
    protected static final int MESSAGE_ID_MEMBER_MERGE_RES = 4;
    protected static final int MESSAGE_ID_MAIN_HELLO_REQ = 5;
    protected static final int MESSAGE_ID_MAIN_REQ = 6;
    protected static final int MESSAGE_ID_MAIN_RES = 7;
    protected static final int MESSAGE_ID_HELLO_REQ = 8;
    protected static final int MESSAGE_ID_HELLO_RES = 9;
    protected static final int MESSAGE_ID_BYE_REQ = 10;
    protected ServiceName targetServiceName;
    protected String multicastGroupAdress;
    protected int multicastPort = 1500;
    protected int timeToLive = -1;
    protected int receiveBufferSize = 2048;
    protected long heartBeatInterval = 1000L;
    protected long heartBeatResponseTimeout = 500L;
    protected int heartBeatRetryCount;
    protected long addMemberResponseTimeout = 500L;
    protected GlobalUID uid;
    protected InetAddress group;
    protected MulticastSocket socket;
    protected Daemon clusterMessageReceiver;
    protected Daemon heartBeater;
    protected boolean isMain;
    protected List members;
    protected boolean isAddRequesting;
    protected final String addMonitor = "ADD";
    protected boolean isMainRequesting;
    protected Set mainReqMembers;
    protected final String helloMonitor = "HELLO";
    protected GlobalUID helloTarget;
    protected boolean isHelloOK;

    public void setTargetServiceName(ServiceName name) {
        this.targetServiceName = name;
    }

    public ServiceName getTargetServiceName() {
        return this.targetServiceName;
    }

    public void setMulticastGroupAdress(String ip) {
        this.multicastGroupAdress = ip;
    }

    public String getMulticastGroupAdress() {
        return this.multicastGroupAdress;
    }

    public void setMulticastPort(int port) {
        this.multicastPort = port;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setTimeToLive(int ttl) {
        this.timeToLive = ttl;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setHeartBeatInterval(long interval) {
        this.heartBeatInterval = interval;
    }

    public long getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public void setHeartBeatResponseTimeout(long timeout) {
        this.heartBeatResponseTimeout = timeout;
    }

    public long getHeartBeatResponseTimeout() {
        return this.heartBeatResponseTimeout;
    }

    public void setHeartBeatRetryCount(int count) {
        this.heartBeatRetryCount = count;
    }

    public int getHeartBeatRetryCount() {
        return this.heartBeatRetryCount;
    }

    public void setAddMemberResponseTimeout(long timeout) {
        this.addMemberResponseTimeout = timeout;
    }

    public long getAddMemberResponseTimeout() {
        return this.addMemberResponseTimeout;
    }

    public boolean isMain() {
        return this.isMain;
    }

    public List getMembers() {
        return this.members;
    }

    public Object getUID() {
        return this.uid;
    }

    public void createService() throws Exception {
        this.members = Collections.synchronizedList(new ArrayList());
        this.mainReqMembers = Collections.synchronizedSet(new HashSet());
        this.uid = new GlobalUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() throws Exception {
        if (this.targetServiceName == null) {
            throw new IllegalArgumentException("TargetServiceName is null.");
        }
        if (this.multicastGroupAdress == null) {
            throw new IllegalArgumentException("MulticastGroupAdress is null.");
        }
        this.group = InetAddress.getByName(this.multicastGroupAdress);
        this.socket = new MulticastSocket(this.multicastPort);
        if (this.timeToLive >= 0) {
            this.socket.setTimeToLive(this.timeToLive);
        }
        this.socket.joinGroup(this.group);
        this.clusterMessageReceiver = new Daemon(new MessageReceiver());
        this.clusterMessageReceiver.setName("Nimbus Cluster MessageReceiver " + this.getServiceNameObject());
        this.clusterMessageReceiver.start();
        Object object = "ADD";
        synchronized ("ADD") {
            this.isAddRequesting = true;
            try {
                this.sendMessage(1);
                "ADD".wait(this.addMemberResponseTimeout);
            }
            finally {
                this.isAddRequesting = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.members.size() == 0) {
                try {
                    ServiceManagerFactory.getService(this.targetServiceName).start();
                    object = this.members;
                    synchronized (object) {
                        if (!this.members.contains(this.uid)) {
                            this.members.add(this.uid);
                        }
                        this.isMain = true;
                        this.isMainRequesting = false;
                    }
                }
                catch (Exception e) {
                    this.sendMessage(10);
                    throw e;
                }
            }
            this.heartBeater = new Daemon(new HeartBeater());
            this.heartBeater.setName("Nimbus Cluster HeartBeater " + this.getServiceNameObject());
            this.heartBeater.start();
            return;
        }
    }

    public void stopService() throws Exception {
        this.heartBeater.stop(100L);
        this.heartBeater = null;
        this.clusterMessageReceiver.stop(100L);
        this.clusterMessageReceiver = null;
        try {
            this.sendMessage(10);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ServiceManagerFactory.getService(this.targetServiceName).stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.socket != null) {
            try {
                this.socket.leaveGroup(this.group);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket.close();
        }
        this.isMain = false;
        this.group = null;
        this.members.clear();
        this.mainReqMembers.clear();
    }

    public void destroyService() throws Exception {
        this.uid = null;
        this.members = null;
        this.mainReqMembers = null;
    }

    protected void sendMessage(int messageId) throws IOException {
        this.sendMessage(messageId, null);
    }

    protected void sendMessage(int messageId, GlobalUID toUID) throws IOException {
        this.sendMessage(messageId, this.uid, toUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(int messageId, GlobalUID fromUID, GlobalUID toUID) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeInt(messageId);
            oos.writeObject(fromUID);
            oos.writeObject(toUID);
            switch (messageId) {
                case 1: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    oos.writeInt(this.members.size());
                    int imax = this.members.size();
                    for (int i = 0; i < imax; ++i) {
                        oos.writeObject(this.members.get(i));
                    }
                    break;
                }
                case 7: {
                    oos.writeBoolean(!this.isMain);
                    break;
                }
            }
            oos.close();
            byte[] bytes = baos.toByteArray();
            if (bytes.length > 0) {
                DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.group, this.multicastPort);
                this.socket.send(packet);
            }
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void handleMessage(InputStream is) {
        ois = null;
        try {
            block78: {
                block77: {
                    ois = new ObjectInputStream(is);
                    messageId = ois.readInt();
                    fromUID = (GlobalUID)ois.readObject();
                    toUID = (GlobalUID)ois.readObject();
                    if (this.uid.equals(fromUID)) break block77;
                    if (toUID == null || this.uid.equals(toUID)) break block78;
                }
                var21_8 = null;
                if (ois == null) return;
                try {
                    ois.close();
                    return;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return;
            }
            memberSize = 0;
            newMembers = null;
            switch (messageId) {
                case 1: {
                    if (!this.isMain) break;
                    var8_20 = this.members;
                    // MONITORENTER : var8_20
                    if (!this.members.contains(fromUID)) {
                        this.members.add(fromUID);
                    }
                    // MONITOREXIT : var8_20
                    this.sendMessage(2);
                    break;
                }
                case 2: {
                    if (this.isMain || this.members.size() != 0 && this.members.indexOf(fromUID) != 0) break;
                    memberSize = ois.readInt();
                    newMembers = new ArrayList<E>();
                    if (memberSize > 0) {
                        for (i = 0; i < memberSize; ++i) {
                            newMembers.add(ois.readObject());
                        }
                    }
                    i = this.members;
                    // MONITORENTER : i
                    if (newMembers.contains(this.uid) && !this.members.equals(newMembers)) {
                        this.members = Collections.synchronizedList(newMembers);
                    }
                    // MONITOREXIT : i
                    if (!this.isAddRequesting || !this.members.contains(this.uid)) break;
                    i = "ADD";
                    // MONITORENTER : "ADD"
                    "ADD".notifyAll();
                    // MONITOREXIT : i
                    break;
                }
                case 3: {
                    if (!this.isMain) break;
                    memberSize = ois.readInt();
                    newMembers = new ArrayList<E>();
                    if (memberSize > 0) {
                        for (i = 0; i < memberSize; ++i) {
                            newMembers.add(ois.readObject());
                        }
                    }
                    i = this.members;
                    // MONITORENTER : i
                    newMembers.removeAll(this.members);
                    if (newMembers.size() != 0) {
                        this.members.addAll(newMembers);
                    }
                    // MONITOREXIT : i
                    this.sendMessage(4);
                    break;
                }
                case 4: {
                    memberSize = ois.readInt();
                    newMembers = new ArrayList<Object>();
                    if (memberSize > 0) {
                        for (i = 0; i < memberSize; ++i) {
                            newMembers.add(ois.readObject());
                        }
                    }
                    if (this.isMain && newMembers.indexOf(this.uid) != 0) {
                        try {
                            ServiceManagerFactory.getService(this.targetServiceName).stop();
                        }
                        catch (ServiceNotFoundException e) {
                            // empty catch block
                        }
                        this.isMain = false;
                        this.isMainRequesting = false;
                    }
                    var8_27 = this.members;
                    // MONITORENTER : var8_27
                    if (newMembers.contains(this.uid) && !this.members.equals(newMembers)) {
                        this.members = Collections.synchronizedList(newMembers);
                    }
                    // MONITOREXIT : var8_27
                    break;
                }
                case 5: {
                    if (!this.isMain) {
                        if (this.members.size() != 1 || this.isAddRequesting) break;
                        this.sendMessage(1, fromUID);
                        break;
                    }
                    if (this.uid.compareTo(fromUID) <= 0) break;
                    this.sendMessage(3, fromUID);
                    break;
                }
                case 6: {
                    this.sendMessage(7, fromUID);
                    break;
                }
                case 7: {
                    if (!this.isMainRequesting) break;
                    if (ois.readBoolean()) {
                        var8_28 = this.mainReqMembers;
                        // MONITORENTER : var8_28
                        this.mainReqMembers.remove(fromUID);
                        if (this.mainReqMembers.size() == 0) {
                            try {
                                ServiceManagerFactory.getService(this.targetServiceName).start();
                                this.isMain = true;
                                this.isMainRequesting = false;
                            }
                            catch (Exception e) {
                                this.sendMessage(10);
                            }
                        }
                        // MONITOREXIT : var8_28
                        break;
                    }
                    this.isMainRequesting = false;
                    this.mainReqMembers.clear();
                    break;
                }
                case 8: {
                    this.sendMessage(9, fromUID);
                    break;
                }
                case 9: {
                    var8_29 = "HELLO";
                    // MONITORENTER : "HELLO"
                    if (this.helloTarget != null && this.helloTarget.equals(fromUID)) {
                        this.isHelloOK = true;
                        "HELLO".notify();
                    }
                    // MONITOREXIT : var8_29
                    break;
                }
                case 10: {
                    if (this.isMain) {
                        var8_30 = this.members;
                        // MONITORENTER : var8_30
                        if (this.members.remove(fromUID)) {
                            this.sendMessage(2);
                        }
                        // MONITOREXIT : var8_30
                        break;
                    }
                    if (this.isMainRequesting) {
                        var8_31 /* !! */  = this.mainReqMembers;
                        // MONITORENTER : var8_31 /* !! */ 
                        this.mainReqMembers.remove(fromUID);
                        // MONITOREXIT : var8_31 /* !! */ 
                    }
                    var8_31 /* !! */  = this.members;
                    // MONITORENTER : var8_31 /* !! */ 
                    this.members.remove(fromUID);
                    if (this.members.indexOf(this.uid) == 0) {
                        if (this.members.size() == 1) {
                            try {
                                ServiceManagerFactory.getService(this.targetServiceName).start();
                                this.isMain = true;
                                this.isMainRequesting = false;
                            }
                            catch (Exception e) {
                                this.sendMessage(10);
                            }
                        } else if (!this.isMainRequesting) {
                            var9_34 = this.mainReqMembers;
                            // MONITORENTER : var9_34
                            this.mainReqMembers.clear();
                            this.mainReqMembers.addAll(this.members);
                            this.mainReqMembers.remove(this.uid);
                            this.isMainRequesting = true;
                            this.sendMessage(6);
                            // MONITOREXIT : var9_34
                        }
                    }
                    // MONITOREXIT : var8_31 /* !! */ 
                    break;
                }
            }
            var21_9 = null;
            if (ois == null) return;
            try {}
            catch (IOException e2) {
                return;
            }
            ois.close();
            return;
            catch (ClassNotFoundException e) {
                var21_10 = null;
                if (ois == null) return;
                try {}
                catch (IOException e2) {
                    return;
                }
                ois.close();
                return;
            }
            catch (IOException var3_5) {
                var21_11 = null;
                if (ois == null) return;
                try {}
                catch (IOException e2) {
                    return;
                }
                ois.close();
                return;
            }
        }
        catch (Throwable var20_35) {
            var21_12 = null;
            if (ois == null) throw var20_35;
            ** try [egrp 16[TRYBLOCK] [34 : 1197->1204)] { 
lbl209:
            // 1 sources

            ois.close();
            throw var20_35;
lbl211:
            // 1 sources

            catch (IOException e2) {
                // empty catch block
            }
            throw var20_35;
        }
    }

    protected class HeartBeater
    implements DaemonRunnable {
        protected long lastSendTime = -1L;
        protected int heartBeatFailedCount;
        protected GlobalUID targetMember;

        protected HeartBeater() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            long processTime = System.currentTimeMillis() - this.lastSendTime;
            if (ClusterService.this.heartBeatInterval > processTime) {
                Thread.sleep(ClusterService.this.heartBeatInterval - processTime);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void consume(Object received, DaemonControl ctrl) throws Throwable {
            if (ClusterService.this.isMain) {
                this.lastSendTime = System.currentTimeMillis();
                ClusterService.this.sendMessage(5);
            }
            GlobalUID member = null;
            Object object = ClusterService.this.members;
            synchronized (object) {
                if (ClusterService.this.members.size() > 1) {
                    int index = ClusterService.this.members.indexOf(ClusterService.this.uid);
                    if (index == -1) {
                        return;
                    }
                    index = index == ClusterService.this.members.size() - 1 ? 0 : ++index;
                    member = (GlobalUID)ClusterService.this.members.get(index);
                    if (!member.equals(this.targetMember)) {
                        this.heartBeatFailedCount = 0;
                    }
                }
            }
            if (member == null || member.equals(ClusterService.this.uid)) return;
            this.targetMember = member;
            try {
                object = "HELLO";
                synchronized ("HELLO") {
                    ClusterService.this.isHelloOK = false;
                    ClusterService.this.helloTarget = member;
                    this.lastSendTime = System.currentTimeMillis();
                    ClusterService.this.sendMessage(8, ClusterService.this.helloTarget);
                    "HELLO".wait(ClusterService.this.heartBeatResponseTimeout);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    if (ClusterService.this.isHelloOK) {
                        this.heartBeatFailedCount = 0;
                        return;
                    }
                    ++this.heartBeatFailedCount;
                    if (this.heartBeatFailedCount - 1 < ClusterService.this.heartBeatRetryCount) return;
                    if (ClusterService.this.isMainRequesting) {
                        object = ClusterService.this.mainReqMembers;
                        synchronized (object) {
                            ClusterService.this.mainReqMembers.remove(member);
                        }
                    }
                    object = ClusterService.this.members;
                    synchronized (object) {
                        ClusterService.this.members.remove(member);
                    }
                    if (ClusterService.this.isMain) {
                        ClusterService.this.sendMessage(2);
                        return;
                    } else {
                        ClusterService.this.sendMessage(10, member, null);
                    }
                    return;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        public void garbage() {
        }
    }

    protected class MessageReceiver
    implements DaemonRunnable {
        protected MessageReceiver() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            byte[] buf = new byte[ClusterService.this.receiveBufferSize];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            try {
                ClusterService.this.socket.receive(packet);
            }
            catch (IOException e) {
                return null;
            }
            return packet;
        }

        public void consume(Object received, DaemonControl ctrl) throws Throwable {
            DatagramPacket packet = (DatagramPacket)received;
            if (packet == null) {
                return;
            }
            ClusterService.this.handleMessage(new ByteArrayInputStream(packet.getData(), 0, packet.getLength()));
        }

        public void garbage() {
        }
    }

    protected static class GlobalUID
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 2185113122895103559L;
        protected final UID uid = new UID();
        protected final InetAddress adress = InetAddress.getLocalHost();

        public boolean equals(Object obj) {
            if (!(obj instanceof GlobalUID)) {
                return false;
            }
            GlobalUID cmp = (GlobalUID)obj;
            return this.uid.equals(cmp.uid) && this.adress.equals(cmp.adress);
        }

        public int hashCode() {
            return this.uid.hashCode() + this.adress.hashCode();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.adress).append(':');
            buf.append(this.uid.toString());
            return buf.toString();
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof GlobalUID)) {
                return -1;
            }
            GlobalUID cmp = (GlobalUID)obj;
            return this.hashCode() - cmp.hashCode();
        }
    }
}

