/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.lang;

import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceName;

public class IllegalServiceStateException
extends RuntimeException {
    private static final long serialVersionUID = 1340027189376383082L;
    private final String managerName;
    private final String serviceName;
    private final int serviceState;

    public IllegalServiceStateException(Service service) {
        this(service != null ? service.getServiceManagerName() : null, service != null ? service.getServiceName() : null, service != null ? service.getState() : 9);
    }

    public IllegalServiceStateException(ServiceName name, int state) {
        this(name != null ? name.getServiceManagerName() : null, name != null ? name.getServiceName() : null, state);
    }

    public IllegalServiceStateException(String manager, String service, int state) {
        this.managerName = manager;
        this.serviceName = service;
        this.serviceState = state;
    }

    public String getServiceManagerName() {
        return this.managerName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getServiceState() {
        return this.serviceState;
    }

    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.managerName).append('#').append(this.serviceName).append(',').append(Service.STATES[this.serviceState]);
        return buf.toString();
    }
}

