/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpServletRequestCheckException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpServletRequestCheckInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;

public class HttpServletRequestCheckInterceptorService
extends ServletFilterInterceptorService
implements HttpServletRequestCheckInterceptorServiceMBean {
    private static final long serialVersionUID = -8791823240259229953L;
    protected int maxContentLength = -1;
    protected int minContentLength = -1;
    protected boolean isAllowNullContentType = true;
    protected String[] validContentTypes;
    protected String[] invalidContentTypes;
    protected boolean isAllowNullCharacterEncoding = true;
    protected String[] validCharacterEncodings;
    protected String[] invalidCharacterEncodings;
    protected boolean isAllowNullLocale = true;
    protected String[] validLocales;
    protected Pattern[] validLocalePatterns;
    protected String[] validProtocols;
    protected String[] validRemoteAddrs;
    protected Pattern[] validRemoteAddrPatterns;
    protected String[] validRemoteHosts;
    protected Pattern[] validRemoteHostPatterns;
    protected int[] validRemotePorts;
    protected String[] validSchemata;
    protected String[] validServerNames;
    protected Pattern[] validServerNamePatterns;
    protected String[] validMethods;
    protected String[] invalidMethods;
    protected Properties headerEquals;
    protected Map headerEqualsMap;
    protected int errorStatus = 400;
    protected boolean isThrowOnError;

    public void setMaxContentLength(int max) {
        this.maxContentLength = max;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public void setMinContentLength(int min) {
        this.minContentLength = min;
    }

    public int getMinContentLength() {
        return this.minContentLength;
    }

    public void setAllowNullContentType(boolean isAllow) {
        this.isAllowNullContentType = isAllow;
    }

    public boolean isAllowNullContentType() {
        return this.isAllowNullContentType;
    }

    public void setValidContentTypes(String[] types) {
        this.validContentTypes = types;
    }

    public String[] getValidContentTypes() {
        return this.validContentTypes;
    }

    public void setInvalidContentTypes(String[] types) {
        this.invalidContentTypes = types;
    }

    public String[] getInvalidContentTypes() {
        return this.invalidContentTypes;
    }

    public void setAllowNullCharacterEncoding(boolean isAllow) {
        this.isAllowNullCharacterEncoding = isAllow;
    }

    public boolean isAllowNullCharacterEncoding() {
        return this.isAllowNullCharacterEncoding;
    }

    public void setValidCharacterEncodings(String[] encodings) {
        this.validCharacterEncodings = encodings;
    }

    public String[] getValidCharacterEncodings() {
        return this.validCharacterEncodings;
    }

    public void setInvalidCharacterEncodings(String[] encodings) {
        this.invalidCharacterEncodings = encodings;
    }

    public String[] getInvalidCharacterEncodings() {
        return this.invalidCharacterEncodings;
    }

    public void setAllowNullLocale(boolean isAllow) {
        this.isAllowNullLocale = isAllow;
    }

    public boolean isAllowNullLocale() {
        return this.isAllowNullLocale;
    }

    public void setValidLocales(String[] locales) {
        this.validLocales = locales;
    }

    public String[] getValidLocales() {
        return this.validLocales;
    }

    public void setValidProtocols(String[] protocols) {
        this.validProtocols = protocols;
    }

    public String[] getValidProtocols() {
        return this.validProtocols;
    }

    public void setValidRemoteAddrs(String[] addrs) {
        this.validRemoteAddrs = addrs;
    }

    public String[] getValidRemoteAddrs() {
        return this.validRemoteAddrs;
    }

    public void setValidRemoteHosts(String[] hosts) {
        this.validRemoteHosts = hosts;
    }

    public String[] getValidRemoteHosts() {
        return this.validRemoteHosts;
    }

    public void setValidRemotePorts(int[] ports) {
        this.validRemotePorts = ports;
    }

    public int[] getValidRemotePorts() {
        return this.validRemotePorts;
    }

    public void setValidSchemata(String[] schemata) {
        this.validSchemata = schemata;
    }

    public String[] getValidSchemata() {
        return this.validSchemata;
    }

    public void setValidServerNames(String[] names) {
        this.validServerNames = names;
    }

    public String[] getValidServerNames() {
        return this.validServerNames;
    }

    public void setValidMethods(String[] methods) {
        this.validMethods = methods;
    }

    public String[] getValidMethods() {
        return this.validMethods;
    }

    public void setInvalidMethods(String[] methods) {
        this.invalidMethods = methods;
    }

    public String[] getInvalidMethods() {
        return this.invalidMethods;
    }

    public void setHeaderEquals(Properties cond) {
        this.headerEquals = cond;
    }

    public Properties getHeaderEquals() {
        return this.headerEquals;
    }

    public void setErrorStatus(int status) {
        this.errorStatus = status;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public void setThrowOnError(boolean isThrow) {
        this.isThrowOnError = isThrow;
    }

    public boolean isThrowOnError() {
        return this.isThrowOnError;
    }

    public void startService() throws Exception {
        int i;
        if (this.validLocales != null && this.validLocales.length != 0) {
            this.validLocalePatterns = new Pattern[this.validLocales.length];
            for (i = 0; i < this.validLocales.length; ++i) {
                this.validLocalePatterns[i] = Pattern.compile(this.validLocales[i]);
            }
        }
        if (this.validRemoteAddrs != null && this.validRemoteAddrs.length != 0) {
            this.validRemoteAddrPatterns = new Pattern[this.validRemoteAddrs.length];
            for (i = 0; i < this.validRemoteAddrs.length; ++i) {
                this.validRemoteAddrPatterns[i] = Pattern.compile(this.validRemoteAddrs[i]);
            }
        }
        if (this.validRemoteHosts != null && this.validRemoteHosts.length != 0) {
            this.validRemoteHostPatterns = new Pattern[this.validRemoteHosts.length];
            for (i = 0; i < this.validRemoteHosts.length; ++i) {
                this.validRemoteHostPatterns[i] = Pattern.compile(this.validRemoteHosts[i]);
            }
        }
        if (this.validServerNames != null && this.validServerNames.length != 0) {
            this.validServerNamePatterns = new Pattern[this.validServerNames.length];
            for (i = 0; i < this.validServerNames.length; ++i) {
                this.validServerNamePatterns[i] = Pattern.compile(this.validServerNames[i]);
            }
        }
        if (this.headerEquals != null) {
            this.headerEqualsMap = new HashMap();
            Iterator<Object> names = this.headerEquals.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                this.headerEqualsMap.put(name, Pattern.compile(this.headerEquals.getProperty(name)));
            }
        }
    }

    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        ServletRequest request = context.getServletRequest();
        ServletResponse response = context.getServletResponse();
        if (this.getState() == 3) {
            Matcher m;
            int i;
            Enumeration locales;
            String encoding;
            int i2;
            int contentLength = request.getContentLength();
            if (this.maxContentLength >= 0 && contentLength >= this.maxContentLength) {
                return this.fail(request, response, "MaxContentLength is " + this.maxContentLength + " : " + contentLength);
            }
            if (this.minContentLength >= 0 && contentLength <= this.minContentLength) {
                return this.fail(request, response, "MinContentLength is " + this.minContentLength + " : " + contentLength);
            }
            String contentType = request.getContentType();
            if (contentType == null) {
                if (!this.isAllowNullContentType) {
                    return this.fail(request, response, "ContentType is null.");
                }
            } else {
                if (this.validContentTypes != null) {
                    boolean success = false;
                    for (i2 = 0; i2 < this.validContentTypes.length; ++i2) {
                        if (!contentType.equalsIgnoreCase(this.validContentTypes[i2])) continue;
                        success = true;
                        break;
                    }
                    if (!success) {
                        return this.fail(request, response, "ContentType is invalid : " + contentType);
                    }
                }
                if (this.invalidContentTypes != null) {
                    for (int i3 = 0; i3 < this.invalidContentTypes.length; ++i3) {
                        if (!contentType.equals(this.invalidContentTypes[i3])) continue;
                        return this.fail(request, response, "ContentType is invalid : " + contentType);
                    }
                }
            }
            if ((encoding = request.getCharacterEncoding()) == null) {
                if (!this.isAllowNullCharacterEncoding) {
                    return this.fail(request, response, "CharacterEncoding is null.");
                }
            } else {
                if (this.validCharacterEncodings != null) {
                    boolean success = false;
                    for (int i4 = 0; i4 < this.validCharacterEncodings.length; ++i4) {
                        if (!encoding.equals(this.validCharacterEncodings[i4])) continue;
                        success = true;
                        break;
                    }
                    if (!success) {
                        return this.fail(request, response, "CharacterEncoding is invalid : " + encoding);
                    }
                }
                if (this.invalidCharacterEncodings != null) {
                    for (i2 = 0; i2 < this.invalidCharacterEncodings.length; ++i2) {
                        if (!encoding.equals(this.invalidCharacterEncodings[i2])) continue;
                        return this.fail(request, response, "CharacterEncoding is invalid : " + encoding);
                    }
                }
            }
            if (!(locales = request.getLocales()).hasMoreElements()) {
                if (!this.isAllowNullLocale) {
                    return this.fail(request, response, "Locale is null.");
                }
            } else if (this.validLocales != null) {
                boolean success = false;
                while (locales.hasMoreElements()) {
                    String locale = ((Locale)locales.nextElement()).toString();
                    for (i = 0; i < this.validLocales.length; ++i) {
                        m = this.validLocalePatterns[i].matcher(locale);
                        if (!m.matches()) continue;
                        success = true;
                        break;
                    }
                    if (!success) continue;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Locale is invalid : " + locales);
                }
            }
            if (this.validProtocols != null) {
                String protocol = request.getProtocol();
                boolean success = false;
                for (i = 0; i < this.validProtocols.length; ++i) {
                    if (!protocol.equals(this.validProtocols[i])) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Protocol is invalid : " + protocol);
                }
            }
            if (this.validRemoteAddrs != null) {
                String addr = request.getRemoteAddr();
                boolean success = false;
                for (i = 0; i < this.validRemoteAddrs.length; ++i) {
                    m = this.validRemoteAddrPatterns[i].matcher(addr);
                    if (!m.matches()) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Remote address is invalid : " + addr);
                }
            }
            if (this.validRemoteHosts != null) {
                String host = request.getRemoteHost();
                boolean success = false;
                for (i = 0; i < this.validRemoteHosts.length; ++i) {
                    m = this.validRemoteHostPatterns[i].matcher(host);
                    if (!m.matches()) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Remote host is invalid : " + host);
                }
            }
            if (this.validRemotePorts != null) {
                int port = request.getRemotePort();
                boolean success = false;
                for (i = 0; i < this.validRemotePorts.length; ++i) {
                    if (port != this.validRemotePorts[i]) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Remote port is invalid : " + port);
                }
            }
            if (this.validSchemata != null) {
                String scheme = request.getScheme();
                boolean success = false;
                for (i = 0; i < this.validSchemata.length; ++i) {
                    if (!scheme.equals(this.validSchemata[i])) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Scheme is invalid : " + scheme);
                }
            }
            if (this.validServerNames != null) {
                String serverName = request.getServerName();
                boolean success = false;
                for (i = 0; i < this.validServerNames.length; ++i) {
                    m = this.validServerNamePatterns[i].matcher(serverName);
                    if (!m.matches()) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return this.fail(request, response, "Server name is invalid : " + serverName);
                }
            }
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpReq = (HttpServletRequest)request;
                String method = httpReq.getMethod();
                if (this.validMethods != null && method != null) {
                    boolean success = false;
                    for (int i5 = 0; i5 < this.validMethods.length; ++i5) {
                        if (!method.equals(this.validMethods[i5])) continue;
                        success = true;
                        break;
                    }
                    if (!success) {
                        return this.fail(request, response, "Method is invalid : " + method);
                    }
                }
                if (this.invalidMethods != null && method != null) {
                    for (i = 0; i < this.invalidMethods.length; ++i) {
                        if (!method.equals(this.invalidMethods[i])) continue;
                        return this.fail(request, response, "Method is invalid : " + method);
                    }
                }
                if (this.headerEqualsMap != null && this.headerEqualsMap.size() != 0) {
                    Iterator names = this.headerEqualsMap.keySet().iterator();
                    while (names.hasNext()) {
                        String name = (String)names.next();
                        String value = httpReq.getHeader(name);
                        if (value == null) {
                            return this.fail(request, response, "Header " + name + " is invalid : " + value);
                        }
                        Pattern p = (Pattern)this.headerEqualsMap.get(name);
                        Matcher m2 = p.matcher(value);
                        if (m2.matches()) continue;
                        return this.fail(request, response, "Header " + name + " is invalid : " + value);
                    }
                }
            }
        }
        return chain.invokeNext(context);
    }

    protected Object fail(ServletRequest request, ServletResponse response, String message) throws HttpServletRequestCheckException {
        if (this.isThrowOnError) {
            throw new HttpServletRequestCheckException(message);
        }
        if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).setStatus(this.errorStatus);
        }
        return null;
    }
}

