/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jp.ossc.nimbus.service.cache.DefaultKeyCachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;

public class FileKeyCachedReference
extends DefaultKeyCachedReference
implements Serializable {
    private static final long serialVersionUID = 1386986712271917526L;

    public FileKeyCachedReference(File file) throws IOException, ClassNotFoundException {
        super(null, file);
        this.cacheKey = ((MapEntry)this.deserializeObject(file)).getKey();
    }

    public FileKeyCachedReference(Serializable key, File file, Serializable obj) throws IOException {
        super(key, file);
        this.serializeObject(file, new MapEntry(key, obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serializeObject(File file, Serializable obj) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(obj);
            Object var5_4 = null;
            if (oos == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            oos.close();
            return;
        }
        catch (Exception e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object deserializeObject(File file) throws IOException, ClassNotFoundException {
        Object entry = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(file));
            entry = ois.readObject();
            Object var5_4 = null;
            if (ois == null) return entry;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ois.close();
            return entry;
        }
        catch (IOException ex) {}
        return entry;
    }

    public File getFile(Object source) {
        return (File)super.get(source, false);
    }

    public Object get(Object source, boolean notify) {
        Object obj = super.get(source, notify);
        if (obj instanceof File) {
            File file = (File)obj;
            if (file.exists() && file.canRead()) {
                MapEntry entry = null;
                try {
                    entry = (MapEntry)this.deserializeObject(file);
                }
                catch (IOException e) {
                    return null;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                return entry.getValue();
            }
            return null;
        }
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object source, Object obj) throws IllegalCachedReferenceException {
        this.notifyChange(source, obj);
        if (obj != null) {
            if (!(obj instanceof Serializable)) throw new IllegalCachedReferenceException("No serializable object : " + obj);
            try {
                this.serializeObject((File)this.cacheObj, (Serializable)obj);
                return;
            }
            catch (IOException e) {
                throw new IllegalCachedReferenceException(e);
            }
        } else {
            ((File)this.cacheObj).delete();
        }
    }

    public void remove(Object source) {
        if (this.cacheObj != null) {
            this.notifyRemoved(source);
            File file = (File)this.cacheObj;
            if (file.exists() && file.canRead()) {
                ((File)this.cacheObj).delete();
            }
            this.cacheObj = null;
            if (this.linkedReferences != null) {
                this.linkedReferences.clear();
            }
        }
    }

    protected static class MapEntry
    implements Serializable {
        private static final long serialVersionUID = 4635469653838112700L;
        protected Serializable key;
        protected Serializable value;

        public MapEntry(Serializable k, Serializable val) {
            this.key = k;
            this.value = val;
        }

        public Serializable getKey() {
            return this.key;
        }

        public Serializable getValue() {
            return this.value;
        }
    }
}

