/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceFactoryServiceBase;
import jp.ossc.nimbus.service.cache.MemorySizeOverflowValidatorFactoryServiceMBean;
import jp.ossc.nimbus.service.cache.MemorySizeOverflowValidatorService;

public class MemorySizeOverflowValidatorFactoryService
extends ServiceFactoryServiceBase
implements MemorySizeOverflowValidatorFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = -4609416416411165086L;
    private final MemorySizeOverflowValidatorService template = new MemorySizeOverflowValidatorService();

    protected Service createServiceInstance() throws Exception {
        MemorySizeOverflowValidatorService validator = new MemorySizeOverflowValidatorService();
        validator.setHighHeapMemorySize(this.template.getHighHeapMemorySize());
        validator.setMaxHeapMemorySize(this.template.getMaxHeapMemorySize());
        return validator;
    }

    public void setMaxHeapMemorySize(String size) throws IllegalArgumentException {
        this.template.setMaxHeapMemorySize(size);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            MemorySizeOverflowValidatorService validator = (MemorySizeOverflowValidatorService)instances.next();
            validator.setMaxHeapMemorySize(size);
        }
    }

    public String getMaxHeapMemorySize() {
        return this.template.getMaxHeapMemorySize();
    }

    public void setHighHeapMemorySize(String size) throws IllegalArgumentException {
        this.template.setHighHeapMemorySize(size);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            MemorySizeOverflowValidatorService validator = (MemorySizeOverflowValidatorService)instances.next();
            validator.setHighHeapMemorySize(size);
        }
    }

    public String getHighHeapMemorySize() {
        return this.template.getHighHeapMemorySize();
    }

    public void reset() {
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            MemorySizeOverflowValidatorService validator = (MemorySizeOverflowValidatorService)instances.next();
            validator.reset();
        }
    }
}

