/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.OverflowValidator;
import jp.ossc.nimbus.service.cache.TimeExpierOverflowValidatorServiceMBean;

public class TimeExpierOverflowValidatorService
extends ServiceBase
implements OverflowValidator,
CacheRemoveListener,
Serializable,
TimeExpierOverflowValidatorServiceMBean {
    private static final long serialVersionUID = -5221705956555820688L;
    private long expierTerm = -1L;
    private long period = -1L;
    private Map references;

    public int size() {
        return this.references == null ? 0 : this.references.size();
    }

    public void createService() throws Exception {
        this.references = Collections.synchronizedMap(new LinkedHashMap());
    }

    public void startService() throws Exception {
    }

    public void destroyService() throws Exception {
        this.reset();
        this.references = null;
    }

    public void setExpierTerm(long millis) throws IllegalArgumentException {
        this.expierTerm = millis;
    }

    public long getExpierTerm() {
        return this.expierTerm;
    }

    public void setPeriod(long millis) throws IllegalArgumentException {
        this.period = millis;
    }

    public long getPeriod() {
        return this.period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int validate() {
        if (this.references == null || this.references.size() == 0) {
            return 0;
        }
        Map map = this.references;
        synchronized (map) {
            int count;
            if (this.getState() != 3) {
                return 0;
            }
            long currentTime = System.currentTimeMillis();
            if (this.getExpierTerm() < 0L && this.period <= 0L) {
                return 0;
            }
            Object[] dates = this.references.values().toArray();
            boolean validateExpierTime = true;
            if (this.expierTerm < 0L) {
                validateExpierTime = false;
            }
            boolean validatePeriod = true;
            if (this.period <= 0L) {
                validatePeriod = false;
            }
            for (count = 0; count < dates.length; ++count) {
                long refMillis = ((Date)dates[count]).getTime();
                if (validateExpierTime && currentTime < refMillis + this.expierTerm) {
                    validateExpierTime = false;
                }
                if (validatePeriod && currentTime < refMillis + (this.period - (refMillis - 32400000L) % this.period)) {
                    validatePeriod = false;
                }
                if (!validateExpierTime && !validatePeriod) break;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        Map map = this.references;
        synchronized (map) {
            if (!this.references.containsKey(ref)) {
                this.references.put(ref, new Date());
                ref.addCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        Map map = this.references;
        synchronized (map) {
            if (this.references.containsKey(ref)) {
                this.references.remove(ref);
                ref.removeCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.references != null) {
            Map map = this.references;
            synchronized (map) {
                Object[] refs = this.references.keySet().toArray();
                for (int i = 0; i < refs.length; ++i) {
                    CachedReference ref = (CachedReference)refs[i];
                    this.remove(ref);
                }
                this.references.clear();
            }
        }
    }

    public void removed(CachedReference ref) {
        if (this.references == null) {
            return;
        }
        this.remove(ref);
    }
}

