/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.service.context.DefaultContextService;
import jp.ossc.nimbus.service.context.ServerInfo;
import jp.ossc.nimbus.service.context.ServerInfoServiceMBean;

public class ServerInfoService
extends DefaultContextService
implements ServerInfo,
ServerInfoServiceMBean,
Serializable {
    private static final long serialVersionUID = -6514773824356484808L;
    private static final String[] CAN_NOT_MODIFY_KEYS = new String[]{"JAVA_VERSION", "JAVA_VENDOR", "JAVA_VM_NAME", "JAVA_VM_VERSION", "JAVA_VM_VENDOR", "OS_NAME", "OS_VERSION", "OS_ARCH", "TOTAL_MEMORY", "USED_MEMORY", "FREE_MEMORY", "MAX_MEMORY", "AVAILABLE_PROCESSORS", "HOST_NAME", "HOST_ADDRESS", "ACTIVE_THREAD_COUNT", "ACTIVE_THREAD_GROUP_COUNT"};

    public void startService() throws Exception {
        super.startService();
        this.context.put("JAVA_VERSION", System.getProperty("java.version"));
        this.context.put("JAVA_VENDOR", System.getProperty("java.vendor"));
        this.context.put("JAVA_VM_NAME", System.getProperty("java.vm.name"));
        this.context.put("JAVA_VM_VERSION", System.getProperty("java.vm.version"));
        this.context.put("JAVA_VM_VENDOR", System.getProperty("java.vm.vendor"));
        this.context.put("OS_NAME", System.getProperty("os.name"));
        this.context.put("OS_VERSION", System.getProperty("os.version"));
        this.context.put("OS_ARCH", System.getProperty("os.arch"));
        try {
            this.context.put("MAX_MEMORY", new Long(Runtime.getRuntime().maxMemory()));
        }
        catch (NoSuchMethodError e) {
            this.context.put("MAX_MEMORY", new Long(-1L));
        }
        try {
            this.context.put("AVAILABLE_PROCESSORS", new Integer(Runtime.getRuntime().availableProcessors()));
        }
        catch (NoSuchMethodError e) {
            this.context.put("AVAILABLE_PROCESSORS", new Integer(-1));
        }
        try {
            this.context.put("HOST_NAME", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            this.context.put("HOST_NAME", "UNKOWN");
        }
        try {
            this.context.put("HOST_ADDRESS", InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            this.context.put("HOST_ADDRESS", "UNKOWN");
        }
    }

    public Object get(Object key) {
        if (key != null) {
            if (key.equals("TOTAL_MEMORY")) {
                return new Long(this.getTotalMemory());
            }
            if (key.equals("USED_MEMORY")) {
                return new Long(this.getUsedMemory());
            }
            if (key.equals("FREE_MEMORY")) {
                return new Long(this.getFreeMemory());
            }
            if (key.equals("ACTIVE_THREAD_COUNT")) {
                return new Integer(this.getActiveThreadCount());
            }
            if (key.equals("ACTIVE_THREAD_GROUP_COUNT")) {
                return new Integer(this.getActiveThreadGroupCount());
            }
        }
        return super.get(key);
    }

    private boolean isModifiableKey(Object key) {
        if (key != null) {
            for (int i = 0; i < CAN_NOT_MODIFY_KEYS.length; ++i) {
                if (!key.equals(CAN_NOT_MODIFY_KEYS[i])) continue;
                return false;
            }
        }
        return true;
    }

    public Object put(Object key, Object value) throws IllegalArgumentException {
        if (!this.isModifiableKey(key)) {
            throw new IllegalArgumentException("Can not modify. " + key);
        }
        return super.put(key, value);
    }

    public Set keySet() {
        HashSet<String> result = new HashSet<String>(super.keySet());
        result.add("TOTAL_MEMORY");
        result.add("USED_MEMORY");
        result.add("FREE_MEMORY");
        result.add("ACTIVE_THREAD_COUNT");
        result.add("ACTIVE_THREAD_GROUP_COUNT");
        return Collections.unmodifiableSet(result);
    }

    public Collection values() {
        HashSet<Object> result = new HashSet<Object>(super.values());
        result.add(this.get("TOTAL_MEMORY"));
        result.add(this.get("USED_MEMORY"));
        result.add(this.get("FREE_MEMORY"));
        result.add(this.get("ACTIVE_THREAD_COUNT"));
        result.add(this.get("ACTIVE_THREAD_GROUP_COUNT"));
        return Collections.unmodifiableCollection(result);
    }

    public Object remove(Object key) {
        if (!this.isModifiableKey(key)) {
            throw new IllegalArgumentException("Can not modify. " + key);
        }
        return super.remove(key);
    }

    public void clear() {
        Iterator keys = super.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!this.isModifiableKey(key)) continue;
            super.remove(key);
        }
    }

    public boolean containsKey(Object key) {
        if (key != null) {
            if (key.equals("TOTAL_MEMORY")) {
                return true;
            }
            if (key.equals("USED_MEMORY")) {
                return true;
            }
            if (key.equals("FREE_MEMORY")) {
                return true;
            }
            if (key.equals("ACTIVE_THREAD_COUNT")) {
                return true;
            }
            if (key.equals("ACTIVE_THREAD_GROUP_COUNT")) {
                return true;
            }
        }
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (value != null) {
            if (value instanceof Integer) {
                int intValue = (Integer)value;
                if (this.getActiveThreadCount() == intValue || this.getActiveThreadGroupCount() == intValue) {
                    return true;
                }
            } else if (value instanceof Long) {
                long longValue = (Long)value;
                if (this.getTotalMemory() == longValue || this.getUsedMemory() == longValue || this.getFreeMemory() == longValue) {
                    return true;
                }
            }
        }
        return super.containsValue(value);
    }

    public Set entrySet() {
        HashSet<Map.Entry> result = new HashSet<Map.Entry>();
        Iterator entries = super.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            if (this.isModifiableKey(entry.getKey())) {
                result.add(entry);
                continue;
            }
            result.add(new UnmodifiedEntry(entry));
        }
        return Collections.unmodifiableSet(result);
    }

    public int size() {
        return super.size() + 5;
    }

    public void putAll(Map t) throws IllegalArgumentException {
        Iterator keys = t.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            this.put(key, t.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String list() {
        StringBuffer buf = new StringBuffer();
        Map map = this.context;
        synchronized (map) {
            Object[] staticKeys = this.context.keySet().toArray();
            Object[] variableKeys = new Object[]{"TOTAL_MEMORY", "USED_MEMORY", "FREE_MEMORY", "ACTIVE_THREAD_COUNT", "ACTIVE_THREAD_GROUP_COUNT"};
            Object[] keys = new Object[staticKeys.length + variableKeys.length];
            System.arraycopy(staticKeys, 0, keys, 0, staticKeys.length);
            System.arraycopy(variableKeys, 0, keys, staticKeys.length, variableKeys.length);
            for (int i = 0; i < keys.length; ++i) {
                buf.append(keys[i]);
                buf.append(" : ");
                buf.append(this.get(keys[i]));
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public String getJavaVersion() {
        return (String)this.get("JAVA_VERSION");
    }

    public String getJavaVendor() {
        return (String)this.get("JAVA_VENDOR");
    }

    public String getJavaVMName() {
        return (String)this.get("JAVA_VM_NAME");
    }

    public String getJavaVMVersion() {
        return (String)this.get("JAVA_VM_VERSION");
    }

    public String getJavaVMVendor() {
        return (String)this.get("JAVA_VM_VENDOR");
    }

    public String getOSName() {
        return (String)this.get("OS_NAME");
    }

    public String getOSVersion() {
        return (String)this.get("OS_VERSION");
    }

    public String getOSArch() {
        return (String)this.get("OS_ARCH");
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getUsedMemory() {
        return this.getTotalMemory() - this.getFreeMemory();
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public long getMaxMemory() {
        Long maxMemory = (Long)this.get("MAX_MEMORY");
        if (maxMemory == null) {
            return -1L;
        }
        return maxMemory;
    }

    public int getAvailableProcessors() {
        Integer availableProcessors = (Integer)this.get("AVAILABLE_PROCESSORS");
        if (availableProcessors == null) {
            return -1;
        }
        return availableProcessors;
    }

    public String getHostName() {
        return (String)this.get("HOST_NAME");
    }

    public String getHostAddress() {
        return (String)this.get("HOST_ADDRESS");
    }

    public String listSystemProperties() {
        Properties prop = System.getProperties();
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        Object[] keys = prop.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            buf.append(keys[i]).append('=').append(prop.get(keys[i]));
            if (i == keys.length - 1) continue;
            buf.append(sep);
        }
        return buf.toString();
    }

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        return group;
    }

    public int getActiveThreadCount() {
        return this.getRootThreadGroup().activeCount();
    }

    public int getActiveThreadGroupCount() {
        return this.getRootThreadGroup().activeGroupCount();
    }

    private class UnmodifiedEntry
    implements Map.Entry,
    Serializable {
        private static final long serialVersionUID = -6773950200246057903L;
        private Object key;

        public UnmodifiedEntry(Map.Entry entry) {
            this.key = entry.getKey();
        }

        public UnmodifiedEntry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return ServerInfoService.this.get(this.key);
        }

        public Object setValue(Object value) {
            throw new IllegalArgumentException("Can not modify. " + this.key);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

