/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive.smtp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;
import jp.ossc.nimbus.service.keepalive.smtp.SmtpCheckerServiceMBean;

public class SmtpCheckerService
extends ServiceBase
implements SmtpCheckerServiceMBean,
DaemonRunnable {
    private static final long serialVersionUID = -1543463563116884001L;
    protected static final String C_HELLOW = "HELO localhost\r\n";
    protected static final String C_EOF_KEY = "WOUGN0600002002";
    protected static final String C_WRONG_SIGN = "2";
    protected static final String C_ERRSTATE_KEY = "WOUGN0600002003";
    protected static final String C_NORMALSTATE_KEY = "WOUGN0600002004";
    protected static final String C_QUITE = "QUIT\r\n";
    protected static final String C_TIMEOUT_KEY = "WOUGN0600002005";
    protected static final String C_PROTOCOL_ERROR_KEY = "WOUGN0600002006";
    protected static final String C_IOERROR_KEY = "WOUGN0600002007";
    protected String mHostName;
    protected InetAddress mIp;
    protected volatile int mPort = 0;
    protected volatile int mConnectionTimeOut = 0;
    protected volatile int mTimeOut = 1000;
    protected String eofLogMessageId = "WOUGN0600002002";
    protected String errorStateLogMessageId = "WOUGN0600002003";
    protected String normalStateLogMessageId = "WOUGN0600002004";
    protected String timeoutLogMessageId = "WOUGN0600002005";
    protected String protocolErrorLogMessageId = "WOUGN0600002006";
    protected String ioErrorLogMessageId = "WOUGN0600002007";
    protected boolean isOutputEOFLogMessage;
    protected boolean isOutputErrorStateLogMessage;
    protected boolean isOutputNormalStateLogMessage;
    protected boolean isOutputTimeoutLogMessage;
    protected boolean isOutputProtocolErrorLogMessage;
    protected boolean isOutputIOErrorLogMessage;
    protected List keepAliveListeners;
    protected boolean isAliveCheckSMTPServer;
    protected boolean isAliveSMTPServer;
    protected long aliveCheckSMTPServerInterval = 60000L;
    protected Daemon daemon;
    protected boolean isLoggingDeadSMTPServer = true;
    protected boolean isLoggingRecoverSMTPServer = true;
    protected String deadSMTPServerLogMessageId = "SMTP_00001";
    protected String recoverSMTPServerLogMessageId = "SMTP_00002";

    public void setHostName(String hostName) throws UnknownHostException {
        this.mHostName = hostName;
        this.mIp = InetAddress.getByName(hostName);
    }

    public String getHostName() {
        return this.mHostName;
    }

    public void setPort(int port) {
        this.mPort = port;
    }

    public int getPort() {
        return this.mPort;
    }

    public void setConnectionTimeoutMillis(int milisec) {
        this.mConnectionTimeOut = milisec;
    }

    public int getConnectionTimeoutMillis() {
        return this.mConnectionTimeOut;
    }

    public void setTimeoutMillis(int milisec) {
        this.mTimeOut = milisec;
    }

    public int getTimeoutMillis() {
        return this.mTimeOut;
    }

    public void setEOFLogMessageId(String id) {
        this.eofLogMessageId = id;
    }

    public String getEOFLogMessageId() {
        return this.eofLogMessageId;
    }

    public void setErrorStateLogMessageId(String id) {
        this.errorStateLogMessageId = id;
    }

    public String getErrorStateLogMessageId() {
        return this.errorStateLogMessageId;
    }

    public void setNormalStateLogMessageId(String id) {
        this.normalStateLogMessageId = id;
    }

    public String getNormalStateLogMessageId() {
        return this.normalStateLogMessageId;
    }

    public void setTimeoutLogMessageId(String id) {
        this.timeoutLogMessageId = id;
    }

    public String getTimeoutLogMessageId() {
        return this.timeoutLogMessageId;
    }

    public void setProtocolErrorLogMessageId(String id) {
        this.protocolErrorLogMessageId = id;
    }

    public String getProtocolErrorLogMessageId() {
        return this.protocolErrorLogMessageId;
    }

    public void setIOErrorLogMessageId(String id) {
        this.ioErrorLogMessageId = id;
    }

    public String getIOErrorLogMessageId() {
        return this.ioErrorLogMessageId;
    }

    public void setOutputEOFLogMessage(boolean isOutput) {
        this.isOutputEOFLogMessage = isOutput;
    }

    public boolean isOutputEOFLogMessage() {
        return this.isOutputEOFLogMessage;
    }

    public void setOutputErrorStateLogMessage(boolean isOutput) {
        this.isOutputErrorStateLogMessage = isOutput;
    }

    public boolean isOutputErrorStateLogMessage() {
        return this.isOutputErrorStateLogMessage;
    }

    public void setOutputNormalStateLogMessage(boolean isOutput) {
        this.isOutputNormalStateLogMessage = isOutput;
    }

    public boolean isOutputNormalStateLogMessage() {
        return this.isOutputNormalStateLogMessage;
    }

    public void setOutputTimeoutLogMessage(boolean isOutput) {
        this.isOutputTimeoutLogMessage = isOutput;
    }

    public boolean isOutputTimeoutLogMessage() {
        return this.isOutputTimeoutLogMessage;
    }

    public void setOutputProtocolErrorLogMessage(boolean isOutput) {
        this.isOutputProtocolErrorLogMessage = isOutput;
    }

    public boolean isOutputProtocolErrorLogMessage() {
        return this.isOutputProtocolErrorLogMessage;
    }

    public void setOutputIOErrorLogMessage(boolean isOutput) {
        this.isOutputIOErrorLogMessage = isOutput;
    }

    public boolean isOutputIOErrorLogMessage() {
        return this.isOutputIOErrorLogMessage;
    }

    public void setLoggingDeadSMTPServer(boolean isOutput) {
        this.isLoggingDeadSMTPServer = isOutput;
    }

    public boolean isLoggingDeadSMTPServer() {
        return this.isLoggingDeadSMTPServer;
    }

    public void setLoggingRecoverSMTPServer(boolean isOutput) {
        this.isLoggingRecoverSMTPServer = isOutput;
    }

    public boolean isLoggingRecoverSMTPServer() {
        return this.isLoggingRecoverSMTPServer;
    }

    public void setDeadSMTPServerLogMessageId(String id) {
        this.deadSMTPServerLogMessageId = id;
    }

    public String getDeadSMTPServerLogMessageId() {
        return this.deadSMTPServerLogMessageId;
    }

    public void setRecoverSMTPServerLogMessageId(String id) {
        this.recoverSMTPServerLogMessageId = id;
    }

    public String getRecoverSMTPServerLogMessageId() {
        return this.recoverSMTPServerLogMessageId;
    }

    public void setAliveCheckSMTPServer(boolean isCheck) {
        this.isAliveCheckSMTPServer = isCheck;
        if (isCheck && this.getState() == 3 && !this.daemon.isRunning()) {
            this.daemon.start();
        }
    }

    public boolean isAliveCheckSMTPServer() {
        return this.isAliveCheckSMTPServer;
    }

    public void setAliveCheckSMTPServerInterval(long interval) {
        this.aliveCheckSMTPServerInterval = interval;
    }

    public long getAliveCheckSMTPServerInterval() {
        return this.aliveCheckSMTPServerInterval;
    }

    public boolean isAliveSMTPServer() {
        if (this.getState() != 3) {
            return false;
        }
        if (this.isAliveCheckSMTPServer) {
            return this.isAliveSMTPServer;
        }
        return this.isAlive();
    }

    public String getHostIp() {
        return this.mIp == null ? null : this.mIp.getHostAddress();
    }

    public int getHostPort() {
        return this.mPort;
    }

    public void createService() throws Exception {
        this.keepAliveListeners = new ArrayList();
        this.daemon = new Daemon(this);
        this.daemon.setName("Nimbus SMTPCheckDaemon " + this.getServiceNameObject());
    }

    public void startService() throws Exception {
        this.isAliveSMTPServer = this.isAlive();
        if (this.isAliveCheckSMTPServer) {
            this.daemon.start();
        }
    }

    public void stopService() throws Exception {
        this.daemon.stop();
    }

    public void destroyService() throws Exception {
        this.keepAliveListeners = null;
    }

    public boolean isAlive() {
        return this.isAliveInternal() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Object isAliveInternal() {
        Object ret;
        block32: {
            Socket sock;
            block31: {
                ret = null;
                sock = null;
                int len = 1024;
                sock = new Socket();
                sock.connect(new InetSocketAddress(this.mIp, this.mPort), this.mConnectionTimeOut);
                BufferedInputStream in = new BufferedInputStream(sock.getInputStream(), 1024);
                BufferedOutputStream out = new BufferedOutputStream(sock.getOutputStream(), 1024);
                out.write(C_HELLOW.getBytes(), 0, C_HELLOW.getBytes().length);
                out.flush();
                sock.setSoTimeout(this.mTimeOut);
                byte[] resBuf = new byte[1024];
                int readLen = in.read(resBuf, 0, 1024);
                if (readLen == -1) {
                    if (this.isOutputEOFLogMessage) {
                        this.getLogger().write(this.eofLogMessageId, (Object)this.getSMTPServerInfo());
                    }
                    ret = "Response reading detect EOF.";
                    break block31;
                }
                String retCode = new String(resBuf, 0, readLen);
                if (!retCode.startsWith(C_WRONG_SIGN)) {
                    if (this.isOutputErrorStateLogMessage) {
                        Object[] wd = new String[]{this.getSMTPServerInfo(), retCode};
                        this.getLogger().write(this.errorStateLogMessageId, wd);
                    }
                    ret = "Return code is : " + retCode;
                } else if (this.isOutputNormalStateLogMessage) {
                    this.getLogger().write(this.normalStateLogMessageId, (Object)this.getSMTPServerInfo());
                }
                out.write(C_QUITE.getBytes(), 0, C_QUITE.getBytes().length);
                out.flush();
            }
            Object var11_13 = null;
            try {
                if (sock != null) {
                    sock.close();
                }
                break block32;
            }
            catch (IOException ex) {
                if (this.isOutputIOErrorLogMessage) {
                    this.getLogger().write(this.ioErrorLogMessageId, (Object)this.getSMTPServerInfo(), (Throwable)ex);
                }
                ret = ex;
            }
            break block32;
            {
                catch (InterruptedIOException e) {
                    if (this.isOutputTimeoutLogMessage) {
                        this.getLogger().write(this.timeoutLogMessageId, (Object)this.getSMTPServerInfo());
                    }
                    ret = e;
                    Object var11_14 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                        }
                        break block32;
                    }
                    catch (IOException ex) {
                        if (this.isOutputIOErrorLogMessage) {
                            this.getLogger().write(this.ioErrorLogMessageId, (Object)this.getSMTPServerInfo(), (Throwable)ex);
                        }
                        ret = ex;
                    }
                    break block32;
                }
                catch (SocketException e) {
                    if (this.isOutputProtocolErrorLogMessage) {
                        this.getLogger().write(this.protocolErrorLogMessageId, (Object)this.getSMTPServerInfo(), (Throwable)e);
                    }
                    ret = e;
                    Object var11_15 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                        }
                        break block32;
                    }
                    catch (IOException ex) {
                        if (this.isOutputIOErrorLogMessage) {
                            this.getLogger().write(this.ioErrorLogMessageId, (Object)this.getSMTPServerInfo(), (Throwable)ex);
                        }
                        ret = ex;
                    }
                    break block32;
                }
                catch (IOException e) {
                    if (this.isOutputIOErrorLogMessage) {
                        this.getLogger().write(this.ioErrorLogMessageId, (Object)this.getSMTPServerInfo(), (Throwable)e);
                    }
                    ret = e;
                    Object var11_16 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                        }
                        break block32;
                    }
                    catch (IOException ex) {
                        if (this.isOutputIOErrorLogMessage) {
                            this.getLogger().write(this.ioErrorLogMessageId, (Object)this.getSMTPServerInfo(), (Throwable)ex);
                        }
                        ret = ex;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                try {
                    if (sock != null) {
                        sock.close();
                    }
                }
                catch (IOException ex) {
                    if (this.isOutputIOErrorLogMessage) {
                        this.getLogger().write(this.ioErrorLogMessageId, (Object)this.getSMTPServerInfo(), (Throwable)ex);
                    }
                    ret = ex;
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeepAliveListener(KeepAliveListener listener) {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeepAliveListener(KeepAliveListener listener) {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeepAliveListener() {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.clear();
        }
    }

    public boolean onStart() {
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) {
        try {
            Thread.sleep(this.aliveCheckSMTPServerInterval);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        return this.isAliveInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Object lookupedObj, DaemonControl ctrl) {
        if (!this.isAliveCheckSMTPServer) {
            return;
        }
        if (this.isAliveSMTPServer) {
            if (lookupedObj != null) {
                this.isAliveSMTPServer = false;
                List list = this.keepAliveListeners;
                synchronized (list) {
                    Iterator itr = this.keepAliveListeners.iterator();
                    while (itr.hasNext()) {
                        KeepAliveListener keepAliveListener = (KeepAliveListener)itr.next();
                        keepAliveListener.onDead(this);
                    }
                }
                if (this.isLoggingDeadSMTPServer) {
                    if (lookupedObj instanceof Throwable) {
                        this.getLogger().write(this.deadSMTPServerLogMessageId, new Object[]{this.getSMTPServerInfo(), ((Throwable)lookupedObj).getMessage()}, (Throwable)lookupedObj);
                    } else {
                        this.getLogger().write(this.deadSMTPServerLogMessageId, new Object[]{this.getSMTPServerInfo(), lookupedObj});
                    }
                }
            }
        } else if (lookupedObj == null) {
            this.isAliveSMTPServer = true;
            List list = this.keepAliveListeners;
            synchronized (list) {
                Iterator itr = this.keepAliveListeners.iterator();
                while (itr.hasNext()) {
                    KeepAliveListener keepAliveListener = (KeepAliveListener)itr.next();
                    keepAliveListener.onRecover(this);
                }
            }
            if (this.isLoggingRecoverSMTPServer) {
                this.getLogger().write(this.recoverSMTPServerLogMessageId, (Object)this.getSMTPServerInfo());
            }
        }
    }

    protected String getSMTPServerInfo() {
        return this.getHostName() + ':' + this.getHostPort();
    }

    public void garbage() {
    }
}

