/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.performance;

import java.text.SimpleDateFormat;
import java.util.Date;
import jp.ossc.nimbus.service.performance.PerformanceRecord;
import jp.ossc.nimbus.service.performance.PerformanceRecordOperator;

public class PerformanceRecordImpl
implements PerformanceRecord,
PerformanceRecordOperator {
    protected String mResourceId;
    protected Date mLastProcTime = null;
    protected Date mBestTime = null;
    protected Date mWorstTime = null;
    protected long mProcTimes = 0L;
    protected long mBestPerformance = 0L;
    protected long mWorstPerformance = 0L;
    protected long mAveragePerformance = 0L;
    protected String[] logMsg = new String[2];
    protected long mTotalTime = 0L;

    public void entry(long msec) {
        this.mLastProcTime = new Date();
        if (this.mProcTimes == 0L) {
            this.mBestPerformance = msec;
            this.mWorstPerformance = msec;
            this.mBestTime = this.mLastProcTime;
            this.mWorstTime = this.mLastProcTime;
        } else {
            if (msec < this.mBestPerformance) {
                this.mBestPerformance = msec;
                this.mBestTime = this.mLastProcTime;
            }
            if (msec > this.mWorstPerformance) {
                this.mWorstPerformance = msec;
                this.mWorstTime = this.mLastProcTime;
            }
        }
        this.mTotalTime += msec;
        ++this.mProcTimes;
        this.mAveragePerformance = this.mTotalTime / this.mProcTimes;
    }

    public String toString() {
        StringBuffer retStr = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SS");
        String LastProcTime = formatter.format(this.mLastProcTime);
        String WorstTime = formatter.format(this.mWorstTime);
        String BestTime = formatter.format(this.mBestTime);
        retStr.append("[").append(this.mResourceId).append("]:");
        retStr.append("[ProcTimes=").append(this.mProcTimes).append("]:");
        retStr.append("[LastProcTime=").append(LastProcTime).append("]:");
        retStr.append("[BestPerformance=").append(this.mBestPerformance).append(",").append(BestTime).append("]:");
        retStr.append("[WorstPerformance=").append(this.mWorstPerformance).append(",").append(WorstTime).append("]:");
        retStr.append("[AveragePerformance=").append(this.mAveragePerformance).append("]");
        return retStr.toString();
    }

    public void setResourceId(String id) {
        this.mResourceId = id;
    }

    public String getResourceId() {
        return this.mResourceId;
    }

    public long getCallTime() {
        return this.mProcTimes;
    }

    public Date getLastCallTime() {
        return this.mLastProcTime;
    }

    public long getBestPerformance() {
        return this.mBestPerformance;
    }

    public Date getBestPerformanceTime() {
        return this.mBestTime;
    }

    public long getWorstPerformance() {
        return this.mWorstPerformance;
    }

    public Date getWorstPerformanceTime() {
        return this.mWorstTime;
    }

    public long getAveragePerformance() {
        return this.mAveragePerformance;
    }
}

