/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.ArrayList;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.FacadeValueAccess;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;
import jp.ossc.nimbus.service.scheduler.IOCCallScheduleTaskServiceMBean;
import jp.ossc.nimbus.service.scheduler.ScheduleTask;

public class IOCCallScheduleTaskService
extends ServiceBase
implements ScheduleTask,
IOCCallScheduleTaskServiceMBean {
    private static final long serialVersionUID = 2146486759345788960L;
    protected static final int IOC_CALL_TYPE_SYNCH_VAL = 1;
    protected static final int IOC_CALL_TYPE_SYNCH_PARALLEL_VAL = 2;
    protected static final int IOC_CALL_TYPE_SYNCH_SEQUENCE_VAL = 3;
    protected static final int IOC_CALL_TYPE_ASYNCH_VAL = 4;
    protected static final int IOC_CALL_TYPE_ASYNCH_SEQUENCE_VAL = 5;
    protected ServiceName facadeCallerServiceName;
    protected FacadeCaller facadeCaller;
    protected String[] beanFlowNames;
    protected Object[] beanFlowInputs;
    protected String iocCallType = "Synch";
    protected int iocCallTypeValue = 1;

    public void setFacadeCallerServiceName(ServiceName name) {
        this.facadeCallerServiceName = name;
    }

    public ServiceName getFacadeCallerServiceName() {
        return this.facadeCallerServiceName;
    }

    public void setBeanFlowNames(String[] names) {
        this.beanFlowNames = names;
    }

    public String[] getBeanFlowNames() {
        return this.beanFlowNames;
    }

    public void setBeanFlowInputs(Object[] in) {
        this.beanFlowInputs = in;
    }

    public Object[] getBeanFlowInputs() {
        return this.beanFlowInputs;
    }

    public void setIOCCallType(String type) {
        if ("Synch".equals(type)) {
            this.iocCallTypeValue = 1;
        } else if ("SynchParallel".equals(type)) {
            this.iocCallTypeValue = 2;
        } else if ("SynchSequence".equals(type)) {
            this.iocCallTypeValue = 3;
        } else if ("Asynch".equals(type)) {
            this.iocCallTypeValue = 4;
        } else if ("AsynchSequence".equals(type)) {
            this.iocCallTypeValue = 5;
        } else {
            throw new IllegalArgumentException("Illegal IOCCallType : " + type);
        }
        this.iocCallType = type;
    }

    public String getIOCCallType() {
        return this.iocCallType;
    }

    public void startService() throws Exception {
        if (this.facadeCallerServiceName != null) {
            this.facadeCaller = (FacadeCaller)ServiceManagerFactory.getServiceObject(this.facadeCallerServiceName);
        }
        if (this.facadeCaller == null) {
            throw new IllegalArgumentException("facadeCaller is null");
        }
        if (this.beanFlowNames == null || this.beanFlowNames.length == 0) {
            throw new IllegalArgumentException("beanFlowNames must be specified.");
        }
        if (this.beanFlowInputs != null && this.beanFlowNames.length != this.beanFlowInputs.length) {
            throw new IllegalArgumentException("beanFlowInputs is illegal.");
        }
    }

    public void setFacadeCaller(FacadeCaller caller) {
        this.facadeCaller = caller;
    }

    public void run() throws Exception {
        try {
            boolean isSynch = false;
            boolean isSequence = false;
            boolean isSynchParallel = false;
            switch (this.iocCallTypeValue) {
                case 1: {
                    isSynch = true;
                    isSequence = false;
                    break;
                }
                case 4: {
                    isSynch = false;
                    isSequence = false;
                    break;
                }
                case 3: {
                    isSynch = true;
                    isSequence = true;
                    break;
                }
                case 5: {
                    isSynch = false;
                    isSequence = true;
                    break;
                }
                case 2: {
                    isSynch = true;
                    isSequence = false;
                    isSynchParallel = true;
                    break;
                }
            }
            FacadeValue fv = null;
            ArrayList<FacadeValue> fvs = null;
            for (int i = 0; i < this.beanFlowNames.length; ++i) {
                if (fv == null || isSequence || isSynchParallel) {
                    fv = FacadeValueAccess.createCommandsValue();
                }
                Command command = FacadeValueAccess.createCommand(this.beanFlowNames[i], this.beanFlowInputs == null ? null : this.beanFlowInputs[i]);
                fv.addCommand(command);
                if (isSynchParallel) {
                    if (fvs == null) {
                        fvs = new ArrayList<FacadeValue>();
                    }
                    fvs.add(fv);
                }
                if (!isSequence) continue;
                if (isSynch) {
                    FacadeValue ret = this.facadeCaller.syncFacadeCall(fv);
                    if (ret == null || ret.getStatus() != 1) continue;
                    throw ret.getExceptions()[0];
                }
                this.facadeCaller.unsyncFacadeCall(fv);
            }
            if (!(fv == null && fvs == null || isSequence)) {
                if (isSynch) {
                    if (isSynchParallel) {
                        FacadeValue[] vals = fvs.toArray(new FacadeValue[fvs.size()]);
                        FacadeValue[] rets = this.facadeCaller.syncParallelFacadeCall(vals);
                        if (rets != null) {
                            for (int i = 0; i < rets.length; ++i) {
                                FacadeValue ret = rets[i];
                                if (ret == null || ret.getStatus() != 1) continue;
                                throw ret.getExceptions()[0];
                            }
                        }
                    } else {
                        FacadeValue ret = this.facadeCaller.syncFacadeCall(fv);
                        if (ret != null && ret.getStatus() == 1) {
                            throw ret.getExceptions()[0];
                        }
                    }
                } else {
                    this.facadeCaller.unsyncFacadeCall(fv);
                }
            }
        }
        catch (Throwable th) {
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            throw (Error)th;
        }
    }
}

