/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.soap;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.soap.JaxRpcServiceException;
import jp.ossc.nimbus.service.soap.JaxRpcServiceFactory;
import jp.ossc.nimbus.service.soap.JaxRpcServiceFactoryServiceMBean;
import jp.ossc.nimbus.service.soap.TypeMapping;

public class JaxRpcServiceFactoryService
extends ServiceBase
implements JaxRpcServiceFactory,
JaxRpcServiceFactoryServiceMBean {
    private static final long serialVersionUID = -8319395042566600989L;
    private String nameSpace;
    private String jaxRpcServiceName;
    private URL wsdlURL;
    private ServiceFactory jaxRpcFactory;
    private Map typeMappings;

    public URL getWsdlURL() {
        return this.wsdlURL;
    }

    public void setWsdlURL(URL url) {
        this.wsdlURL = url;
    }

    public void setJaxRpcServiceName(String jaxRpcServiceName) {
        this.jaxRpcServiceName = jaxRpcServiceName;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public void setTypeMapping(String encodingStyleURI, TypeMapping mapping) {
        this.typeMappings.put(encodingStyleURI, mapping);
    }

    public TypeMapping getTypeMapping(String encodingStyleURI) {
        return (TypeMapping)this.typeMappings.get(encodingStyleURI);
    }

    public void createService() throws Exception {
        this.typeMappings = new HashMap();
    }

    public void startService() throws Exception {
        if (this.nameSpace == null) {
            throw new IllegalArgumentException("nameSpace must be specified.");
        }
        if (this.jaxRpcServiceName == null) {
            throw new IllegalArgumentException("jaxRpcServiceName must be specified.");
        }
        if (this.wsdlURL == null) {
            throw new IllegalArgumentException("wsdlURL must be specified.");
        }
        this.jaxRpcFactory = ServiceFactory.newInstance();
        this.getService();
    }

    public void stopService() throws Exception {
    }

    public void destroyService() throws Exception {
        this.jaxRpcFactory = null;
        this.typeMappings = null;
    }

    public Service getService() throws JaxRpcServiceException {
        QName serviceQN = new QName(this.nameSpace, this.jaxRpcServiceName);
        Service jaxRpcService = null;
        try {
            jaxRpcService = this.jaxRpcFactory.createService(this.wsdlURL, serviceQN);
        }
        catch (ServiceException e) {
            throw new JaxRpcServiceException(e);
        }
        if (this.typeMappings.size() != 0) {
            TypeMappingRegistry registry = jaxRpcService.getTypeMappingRegistry();
            Iterator keys = this.typeMappings.keySet().iterator();
            while (keys.hasNext()) {
                String encodingStyleURI = (String)keys.next();
                TypeMapping mapping = (TypeMapping)this.typeMappings.get(encodingStyleURI);
                registry.register(encodingStyleURI, mapping.cloneTypeMapping(registry, encodingStyleURI));
            }
        }
        return jaxRpcService;
    }

    public String getJaxRpcServiceName() {
        return this.jaxRpcServiceName;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }
}

