/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.validator;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.recset.RecordSet;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.validator.MasterValidatorServiceMBean;
import jp.ossc.nimbus.util.validator.ValidateException;
import jp.ossc.nimbus.util.validator.Validator;

public class MasterValidatorService
extends ServiceBase
implements Validator,
MasterValidatorServiceMBean {
    private static final long serialVersionUID = 3833661471756025996L;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private RecordSet templateRecordSet;
    private List bindDataList;
    private ServiceName codeMasterFinderServiceName;
    private CodeMasterFinder codeMasterFinder;
    private ServiceName threadContextServiceName;
    private Context threadContext;
    private String codeMasterThreadContextKey = "CODE_MASTER";
    private String codeMasterName;
    private String recordSetSearchCondition;
    private Map bindDataMap;

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setRecordSet(RecordSet recset) {
        this.templateRecordSet = recset;
    }

    public RecordSet getRecordSet() {
        return this.templateRecordSet;
    }

    public void setBindData(int index, String valueKey) {
        if (this.bindDataList == null) {
            this.bindDataList = new ArrayList();
        }
        for (int i = this.bindDataList.size(); i <= index; ++i) {
            this.bindDataList.add(null);
        }
        if (!valueKey.startsWith("VALUE")) {
            throw new IllegalArgumentException("ValueKey must start with 'VALUE'.");
        }
        if (!valueKey.equals("VALUE")) {
            if ((valueKey = valueKey.substring("VALUE".length())).charAt(0) == '.') {
                valueKey = valueKey.substring(1);
            }
            this.bindDataList.set(index, PropertyFactory.createProperty(valueKey));
        }
    }

    public String getBindData(int index) {
        if (this.bindDataList == null || this.bindDataList.size() <= index) {
            return null;
        }
        Property prop = (Property)this.bindDataList.get(index);
        return prop == null ? "VALUE" : "VALUE." + prop.getPropertyName();
    }

    public void setCodeMasterFinderServiceName(ServiceName name) {
        this.codeMasterFinderServiceName = name;
    }

    public ServiceName getCodeMasterFinderServiceName() {
        return this.codeMasterFinderServiceName;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setCodeMasterThreadContextKey(String key) {
        this.codeMasterThreadContextKey = key;
    }

    public String getCodeMasterThreadContextKey() {
        return this.codeMasterThreadContextKey;
    }

    public void setCodeMasterName(String name) {
        this.codeMasterName = name;
    }

    public String getCodeMasterName() {
        return this.codeMasterName;
    }

    public void setRecordSetSearchCondition(String name) {
        this.recordSetSearchCondition = name;
    }

    public String getRecordSetSearchCondition() {
        return this.recordSetSearchCondition;
    }

    public void setBindDataMap(String key, String valueKey) {
        if (this.bindDataMap == null) {
            this.bindDataMap = new HashMap();
        }
        if (!valueKey.startsWith("VALUE")) {
            throw new IllegalArgumentException("ValueKey must start with 'VALUE'.");
        }
        if (valueKey.equals("VALUE")) {
            this.bindDataMap.put(key, null);
        } else {
            if ((valueKey = valueKey.substring("VALUE".length())).charAt(0) == '.') {
                valueKey = valueKey.substring(1);
            }
            this.bindDataMap.put(key, PropertyFactory.createProperty(valueKey));
        }
    }

    public String getBindDataMap(String key) {
        if (this.bindDataMap == null) {
            return null;
        }
        Property prop = (Property)this.bindDataMap.get(key);
        return prop == null ? "VALUE" : "VALUE." + prop.getPropertyName();
    }

    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
            if (this.templateRecordSet == null) {
                throw new IllegalArgumentException("RecordSet must be specified.");
            }
            if (this.bindDataList == null) {
                throw new IllegalArgumentException("BindData must be specified.");
            }
        } else {
            if (this.codeMasterFinderServiceName != null) {
                this.codeMasterFinder = (CodeMasterFinder)ServiceManagerFactory.getServiceObject(this.codeMasterFinderServiceName);
            }
            if (this.threadContextServiceName != null) {
                this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
            }
            if (this.codeMasterFinder == null && this.threadContext == null) {
                throw new IllegalArgumentException("It is necessary to set either of CodeMasterFinder or ThreadContext.");
            }
            if (this.codeMasterName == null) {
                throw new IllegalArgumentException("CodeMasterName must be specified.");
            }
            if (this.recordSetSearchCondition == null) {
                throw new IllegalArgumentException("RecordSetSearchCondition must be specified.");
            }
            if (this.bindDataMap == null || this.bindDataMap.size() == 0) {
                throw new IllegalArgumentException("BindDataMap must be specified.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate(Object obj) throws ValidateException {
        if (this.connectionFactory != null) {
            int i;
            RecordSet recset = this.templateRecordSet.cloneEmpty();
            Connection con = null;
            try {
                try {
                    con = this.connectionFactory.getConnection();
                    recset.setConnection(con);
                    recset.setLogger(this.getLogger());
                    int imax = this.bindDataList.size();
                    for (i = 0; i < imax; ++i) {
                        Property prop = (Property)this.bindDataList.get(i);
                        if (prop == null) {
                            recset.setBindData(i, obj);
                            continue;
                        }
                        recset.setBindData(i, prop.getProperty(obj));
                    }
                    i = recset.search() != 0 ? 1 : 0;
                    Object var8_16 = null;
                    if (con == null) return i != 0;
                }
                catch (ConnectionFactoryException e) {
                    throw new ValidateException(e);
                }
                catch (NoSuchPropertyException e) {
                    throw new ValidateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ValidateException(e.getCause());
                }
                catch (SQLException e) {
                    throw new ValidateException(e);
                }
            }
            catch (Throwable throwable) {
                Object var8_17 = null;
                if (con == null) throw throwable;
                try {
                    con.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                // empty catch block
                return i != 0;
            }
            con.close();
            return i != 0;
        }
        Map codeMaster = null;
        if (this.threadContext != null) {
            codeMaster = (Map)this.threadContext.get(this.codeMasterThreadContextKey);
        }
        if (codeMaster == null && this.codeMasterFinder != null) {
            codeMaster = this.codeMasterFinder.getCodeMasters();
        }
        if (codeMaster == null) {
            throw new ValidateException("CodeMaster is not found.");
        }
        Object master = codeMaster.get(this.codeMasterName);
        if (master == null) {
            throw new ValidateException("Master '" + this.codeMasterName + "' is not found.");
        }
        if (!(master instanceof RecordSet)) {
            throw new ValidateException("Master '" + this.codeMasterName + "' is not RecordSet.");
        }
        RecordSet recset = (RecordSet)master;
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator entries = this.bindDataMap.entrySet().iterator();
        try {
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String key = (String)entry.getKey();
                Property prop = (Property)entry.getValue();
                if (prop == null) {
                    params.put(key, obj);
                    continue;
                }
                params.put(key, prop.getProperty(obj));
            }
        }
        catch (NoSuchPropertyException e) {
            throw new ValidateException(e);
        }
        catch (InvocationTargetException e) {
            throw new ValidateException(e.getCause());
        }
        try {
            if (recset.searchDynamicConditionReal(this.recordSetSearchCondition, params).size() == 0) return false;
            return true;
        }
        catch (Exception e) {
            throw new ValidateException(e);
        }
    }
}

