/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.writer.IterateWritableElement;
import jp.ossc.nimbus.service.writer.PropertyWritableRecordFactoryServiceMBean;
import jp.ossc.nimbus.service.writer.SimpleElement;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.service.writer.WritableRecordFactoryService;

public class PropertyWritableRecordFactoryService
extends WritableRecordFactoryService
implements PropertyWritableRecordFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = 6929876971079349458L;
    private static final String PWRF_ = "PWRF_";
    private static final String PWRF_0 = "PWRF_0";
    private static final String PWRF_00 = "PWRF_00";
    private static final String PWRF_000 = "PWRF_000";
    private static final String PWRF_0000 = "PWRF_0000";
    private static final String PWRF_00001 = "PWRF_00001";
    private static final String ITERATE_SUFFIX = "*";
    private Properties formatKeyMapping;
    private Map writableRecordPropertyMapping;
    private Map iterateFormatKeyMappings;
    private Map iterateWritableRecordPropertyMappings;
    private Map iterateFormats;
    private Map iterateFormatMappings;

    public void setFormatKeyMapping(Properties mapping) {
        this.formatKeyMapping = mapping;
    }

    public Properties getFormatKeyMapping() {
        return this.formatKeyMapping;
    }

    public void setIterateFormatKeyMapping(String key, Properties mapping) {
        this.iterateFormatKeyMappings.put(key, mapping);
    }

    public Properties getIterateFormatKeyMapping(String key) {
        return (Properties)this.iterateFormatKeyMappings.get(key);
    }

    public void setIterateFormat(String key, String format) {
        this.iterateFormats.put(key, format);
    }

    public String getIterateFormat(String key) {
        return (String)this.iterateFormats.get(key);
    }

    public void createService() throws Exception {
        super.createService();
        this.writableRecordPropertyMapping = new HashMap();
        this.iterateFormatKeyMappings = new HashMap();
        this.iterateWritableRecordPropertyMappings = new HashMap();
        this.iterateFormats = new HashMap();
        this.iterateFormatMappings = new HashMap();
    }

    public void startService() throws Exception {
        String itrKey;
        Iterator itrKeys;
        super.startService();
        if (this.formatKeyMapping != null) {
            Iterator<Object> keys = this.formatKeyMapping.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String prop = this.formatKeyMapping.getProperty(key);
                if (prop == null || prop.length() == 0) continue;
                this.writableRecordPropertyMapping.put(key, PropertyFactory.createProperty(prop));
            }
        }
        if (this.iterateFormats.size() != 0) {
            itrKeys = this.iterateFormats.keySet().iterator();
            while (itrKeys.hasNext()) {
                itrKey = (String)itrKeys.next();
                String format = (String)this.iterateFormats.get(itrKey);
                this.iterateFormatMappings.put(itrKey, this.parseFormat(format));
                if (this.iterateFormatKeyMappings.containsKey(itrKey)) continue;
                throw new IllegalArgumentException("IterateFormatKeyMapping that corresponds to \"" + itrKey + "\" is not specified.");
            }
        }
        if (this.iterateFormatKeyMappings.size() != 0) {
            itrKeys = this.iterateFormatKeyMappings.keySet().iterator();
            while (itrKeys.hasNext()) {
                itrKey = (String)itrKeys.next();
                Properties props = (Properties)this.iterateFormatKeyMappings.get(itrKey);
                HashMap<String, Property> mapping = new HashMap<String, Property>();
                Iterator<Object> keys = props.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String prop = props.getProperty(key);
                    if (prop == null || prop.length() == 0) continue;
                    mapping.put(key, PropertyFactory.createProperty(prop));
                }
                this.iterateWritableRecordPropertyMappings.put(itrKey, mapping);
            }
        }
    }

    public void stopService() throws Exception {
        this.writableRecordPropertyMapping.clear();
        this.iterateWritableRecordPropertyMappings.clear();
        this.iterateFormatMappings.clear();
        super.stopService();
    }

    public void destroyService() throws Exception {
        this.writableRecordPropertyMapping = null;
        this.iterateFormatKeyMappings = null;
        this.iterateWritableRecordPropertyMappings = null;
        this.iterateFormats = null;
        this.iterateFormatMappings = null;
        super.destroyService();
    }

    protected Set getElementKeys(Object elements) {
        if (elements instanceof Map) {
            return super.getElementKeys(elements);
        }
        return SimpleProperty.getPropertyNames(elements);
    }

    protected WritableElement createElement(String key, Object val) {
        return this.createElement(key, val, this.writableRecordPropertyMapping);
    }

    protected WritableElement createElement(String key, Object val, Map propMapping) {
        if (key.endsWith(ITERATE_SUFFIX)) {
            Object[] array = null;
            if (val == null) {
                return super.createElement(key, val);
            }
            if (val instanceof Collection) {
                Collection col = (Collection)val;
                array = col.toArray(new Object[col.size()]);
            } else if (val.getClass().isArray()) {
                array = (Object[])val;
            } else {
                return super.createElement(key, val);
            }
            if (array == null || array.length == 0) {
                return null;
            }
            IterateWritableElement itrElement = new IterateWritableElement(key);
            if (this.iterateFormatMappings.containsKey(key)) {
                List parsedElements = (List)this.iterateFormatMappings.get(key);
                Map itrPropMapping = (Map)this.iterateWritableRecordPropertyMappings.get(key);
                for (int i = 0; i < array.length; ++i) {
                    int jmax = parsedElements.size();
                    for (int j = 0; j < jmax; ++j) {
                        WritableRecordFactoryService.ParsedElement parsedElem = (WritableRecordFactoryService.ParsedElement)parsedElements.get(j);
                        WritableElement element = null;
                        if (parsedElem.isKeyElement()) {
                            String itrElementKey = parsedElem.getValue();
                            element = this.createElement(itrElementKey, this.getElementValue(itrElementKey, array[i], itrPropMapping));
                        } else {
                            element = new SimpleElement(parsedElem.getValue());
                        }
                        if (element == null) continue;
                        itrElement.addElement(element);
                    }
                }
            } else {
                for (int i = 0; i < array.length; ++i) {
                    WritableElement element = super.createElement(key, array[i]);
                    if (element == null) continue;
                    itrElement.addElement(element);
                }
            }
            return itrElement;
        }
        return super.createElement(key, val);
    }

    protected Object getElementValue(String key, Object elements) {
        return this.getElementValue(key, elements, this.writableRecordPropertyMapping);
    }

    protected Object getElementValue(String key, Object elements, Map propMapping) {
        if (propMapping != null && propMapping.containsKey(key)) {
            Logger logger = this.getLogger();
            Property prop = (Property)propMapping.get(key);
            try {
                return prop.getProperty(elements);
            }
            catch (NoSuchPropertyException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                logger.write(PWRF_00001, (Object)key, (Throwable)e);
                return null;
            }
        }
        return super.getElementValue(key, elements);
    }
}

