/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util;

import java.util.Arrays;
import java.util.Comparator;
import jp.ossc.nimbus.util.HanZenTable;

public class HanZenOperator {
    public static final int HANKANA_FIRST = 65377;
    public static final int HANKANA_LAST = 65439;

    public static String toHankaku(String src) {
        return null;
    }

    public static String toHankaku(String src, int pos, int length) {
        return null;
    }

    public static String toZenkaku(String src) {
        if (src == null) {
            return null;
        }
        return HanZenOperator.toZenkaku(src, 0, src.length());
    }

    public static String toZenkaku(String val, int pos, int length) {
        char[][][] table = HanZenTable.HANZEN_TABLE;
        Comparator comp = HanZenTable.HANZEN_COMPARATOR;
        int retIdx = 0;
        int maxPos = pos + length;
        char[] base = new char[1];
        char[] daku = new char[2];
        char[] nChars = val.toCharArray();
        char[] nRets = new char[length];
        while (pos < maxPos) {
            char[] res;
            char nextChar;
            char currChar;
            if (!HanZenOperator.isHankaku(currChar = nChars[pos++])) {
                nRets[retIdx++] = currChar;
                continue;
            }
            if (pos < maxPos && ((nextChar = nChars[pos]) == '\uff9e' || nextChar == '\uff9f')) {
                ++pos;
                daku[0] = currChar;
                daku[1] = nextChar;
                res = HanZenOperator._convertPart(daku, table, comp);
                retIdx += HanZenOperator._putChars(nRets, retIdx, res);
                continue;
            }
            base[0] = currChar;
            res = HanZenOperator._convertPart(base, table, comp);
            retIdx += HanZenOperator._putChars(nRets, retIdx, res);
        }
        return new String(nRets, 0, retIdx);
    }

    public static boolean isHankaku(char chr) {
        return '\uff61' <= chr && chr <= '\uff9f';
    }

    public static boolean containsHankaku(String val) {
        if (val == null) {
            return false;
        }
        char[] ary = val.toCharArray();
        boolean ret = false;
        for (int cnt = 0; cnt < ary.length; ++cnt) {
            if ('\uff61' > ary[cnt] || ary[cnt] > '\uff9f') continue;
            ret = true;
            break;
        }
        return ret;
    }

    protected static int _putChars(char[] main, int mainPos, char[] parts) {
        int pos = mainPos;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == '\u0000') continue;
            main[pos++] = parts[i];
        }
        return pos - mainPos;
    }

    protected static char[] _convertPart(char[] chars, char[][][] sourceTable, Comparator comparator) {
        int index = Arrays.binarySearch((Object[])sourceTable, chars, comparator);
        if (index >= 0) {
            return sourceTable[index][1];
        }
        if (chars.length == 1) {
            return chars;
        }
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '\u0000') continue;
            char[] atom = new char[]{chars[i]};
            chars[i] = HanZenOperator._convertPart(atom, sourceTable, comparator)[0];
        }
        return chars;
    }
}

