/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;

public class ExtentionFileFilter
implements FilenameFilter,
Serializable {
    private static final long serialVersionUID = 5687776723127309667L;
    protected String extention;
    protected boolean isIgnoreCase = true;
    private String upperExtention;

    public ExtentionFileFilter() {
        this(null, true);
    }

    public ExtentionFileFilter(String ext) {
        this(ext, true);
    }

    public ExtentionFileFilter(String ext, boolean isIgnoreCase) {
        this.setExtention(ext);
        this.setIgnoreCase(isIgnoreCase);
    }

    public void setExtention(String ext) {
        if (ext == null || ext.length() == 0) {
            this.extention = null;
        } else if (ext.charAt(0) == '.') {
            this.extention = ext;
            this.upperExtention = this.extention.toUpperCase();
        } else {
            this.extention = '.' + ext;
            this.upperExtention = this.extention.toUpperCase();
        }
    }

    public String getExtention() {
        return this.extention;
    }

    public void setIgnoreCase(boolean isIgnoreCase) {
        this.isIgnoreCase = isIgnoreCase;
    }

    public boolean isIgnoreCase() {
        return this.isIgnoreCase;
    }

    public boolean accept(File dir, String fileName) {
        if (this.extention == null) {
            return true;
        }
        if (this.isIgnoreCase) {
            String tmp = fileName.toUpperCase();
            return tmp.endsWith(this.upperExtention);
        }
        return fileName.endsWith(this.extention);
    }
}

