/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import jp.ossc.nimbus.service.jms.ReconnectableSession;

public class ReconnectableQueueBrowser
implements QueueBrowser {
    protected ReconnectableSession session;
    protected QueueBrowser queueBrowser;
    protected boolean isClose;
    protected Queue queue;

    public ReconnectableQueueBrowser(ReconnectableSession session, Queue queue) throws JMSException {
        this.session = session;
        this.queueBrowser = this.createQueueBrowser(session, queue);
    }

    protected QueueBrowser createQueueBrowser(ReconnectableSession session, Queue queue) throws JMSException {
        this.queue = queue;
        return session.getRealSession().createBrowser(queue);
    }

    public Queue getQueue() throws JMSException {
        return this.queueBrowser.getQueue();
    }

    public String getMessageSelector() throws JMSException {
        return this.queueBrowser.getMessageSelector();
    }

    public Enumeration getEnumeration() throws JMSException {
        return this.queueBrowser.getEnumeration();
    }

    public void close() throws JMSException {
        this.isClose = true;
        this.queueBrowser.close();
    }

    public void reconnect() throws JMSException {
        QueueBrowser newQueueBrowser;
        if (this.isClose) {
            return;
        }
        this.queueBrowser = newQueueBrowser = this.createQueueBrowser(this.session, this.queue);
    }
}

